/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.KeyDataType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.MultiGenerationMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.ValueDataType;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.type.DataType;

class NodeCache<K, V>
implements Cache<K, V>,
PersistentCache.GenerationCache {
    private final PersistentCache cache;
    private final Cache<K, V> memCache;
    private final MultiGenerationMap<K, V> map;
    private final CacheType type;
    private final DocumentNodeStore docNodeStore;
    private final DocumentStore docStore;

    NodeCache(PersistentCache cache, Cache<K, V> memCache, DocumentNodeStore docNodeStore, DocumentStore docStore, CacheType type) {
        this.cache = cache;
        this.memCache = memCache;
        this.type = type;
        this.docNodeStore = docNodeStore;
        this.docStore = docStore;
        PersistentCache.LOG.info("wrapping map " + (Object)((Object)this.type));
        this.map = new MultiGenerationMap();
    }

    @Override
    public void addGeneration(int generation, boolean readOnly) {
        KeyDataType keyType = new KeyDataType(this.type);
        ValueDataType valueType = new ValueDataType(this.docNodeStore, this.docStore, this.type);
        MVMap.Builder b = new MVMap.Builder().keyType((DataType)keyType).valueType((DataType)valueType);
        String mapName = this.type.name();
        CacheMap m = this.cache.openMap(generation, mapName, b);
        this.map.addReadMap(generation, m);
        if (!readOnly) {
            this.map.setWriteMap(m);
        }
    }

    @Override
    public void removeGeneration(int generation) {
        this.map.removeReadMap(generation);
    }

    private V readIfPresent(K key) {
        this.cache.switchGenerationIfNeeded();
        V v = this.map.get(key);
        return v;
    }

    public void write(K key, V value) {
        this.cache.switchGenerationIfNeeded();
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    @Nullable
    public V getIfPresent(Object key) {
        Object value = this.memCache.getIfPresent(key);
        if (value != null) {
            return (V)value;
        }
        value = this.readIfPresent(key);
        if (value != null) {
            this.memCache.put(key, value);
        }
        return (V)value;
    }

    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        Object value = this.getIfPresent(key);
        if (value != null) {
            return value;
        }
        value = this.memCache.get(key, valueLoader);
        this.write(key, value);
        return value;
    }

    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        return this.memCache.getAllPresent(keys);
    }

    public void put(K key, V value) {
        this.memCache.put(key, value);
        this.write(key, value);
    }

    public void invalidate(Object key) {
        this.memCache.invalidate(key);
        this.write(key, null);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.memCache.putAll(m);
    }

    public void invalidateAll(Iterable<?> keys) {
        this.memCache.invalidateAll(keys);
    }

    public void invalidateAll() {
        this.memCache.invalidateAll();
        this.map.clear();
    }

    public long size() {
        return this.memCache.size();
    }

    public CacheStats stats() {
        return this.memCache.stats();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.memCache.asMap();
    }

    public void cleanUp() {
        this.memCache.cleanUp();
    }
}

