/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBBlobStore
extends CachingBlobStore
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RDBBlobStore.class);
    private static final int MINBLOB = 0x200000;
    private static final int IDSIZE;
    private Exception callStack;
    private RDBConnectionHandler ch;
    private String tnData;
    private String tnMeta;
    private Set<String> tablesToBeDropped = new HashSet<String>();
    private long minLastModified;

    public RDBBlobStore(DataSource ds, RDBOptions options) {
        try {
            this.initialize(ds, options);
        }
        catch (Exception ex) {
            throw new DocumentStoreException("initializing RDB blob store", ex);
        }
    }

    public RDBBlobStore(DataSource ds) {
        this(ds, new RDBOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.tablesToBeDropped.isEmpty()) {
            LOG.debug("attempting to drop: " + this.tablesToBeDropped);
            for (String tname : this.tablesToBeDropped) {
                Connection con = null;
                try {
                    con = this.ch.getRWConnection();
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("drop table " + tname);
                        stmt.close();
                        stmt = null;
                        con.commit();
                    }
                    catch (SQLException ex) {
                        this.ch.closeStatement(stmt);
                        LOG.debug("attempting to drop: " + tname);
                    }
                }
                catch (SQLException ex) {
                    LOG.debug("attempting to drop: " + tname);
                }
                finally {
                    try {
                        if (con == null) continue;
                        con.close();
                    }
                    catch (SQLException ex) {
                        LOG.debug("on close ", (Throwable)ex);
                    }
                }
            }
        }
        this.ch = null;
    }

    protected void finalize() {
        if (this.ch != null && this.callStack != null) {
            LOG.debug("finalizing RDBDocumentStore that was not disposed", (Throwable)this.callStack);
        }
    }

    private static void versionCheck(DatabaseMetaData md, int xmaj, int xmin, String description) throws SQLException {
        int maj = md.getDatabaseMajorVersion();
        int min = md.getDatabaseMinorVersion();
        if (maj < xmaj || maj == xmaj && min < xmin) {
            LOG.info("Unsupported " + description + " version: " + maj + "." + min + ", expected at least " + xmaj + "." + xmin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DataSource ds, RDBOptions options) throws Exception {
        this.tnData = RDBJDBCTools.createTableName(options.getTablePrefix(), "DATASTORE_DATA");
        this.tnMeta = RDBJDBCTools.createTableName(options.getTablePrefix(), "DATASTORE_META");
        this.ch = new RDBConnectionHandler(ds);
        Connection con = this.ch.getRWConnection();
        DatabaseMetaData md = con.getMetaData();
        String dbDesc = md.getDatabaseProductName() + " " + md.getDatabaseProductVersion();
        String driverDesc = md.getDriverName() + " " + md.getDriverVersion();
        String dbUrl = md.getURL();
        ArrayList<String> tablesCreated = new ArrayList<String>();
        ArrayList<String> tablesPresent = new ArrayList<String>();
        Statement createStatement = null;
        try {
            for (String tableName : new String[]{this.tnData, this.tnMeta}) {
                PreparedStatement checkStatement = null;
                try {
                    checkStatement = con.prepareStatement("select ID from " + tableName + " where ID = ?");
                    checkStatement.setString(1, "0");
                    checkStatement.executeQuery();
                    checkStatement.close();
                    checkStatement = null;
                    con.commit();
                    tablesPresent.add(tableName);
                }
                catch (SQLException ex) {
                    String ct;
                    this.ch.closeStatement(checkStatement);
                    con.rollback();
                    DB db = DB.getValue(md.getDatabaseProductName());
                    createStatement = con.createStatement();
                    if (this.tnMeta.equals(tableName)) {
                        ct = db.getMetaTableCreationStatement(tableName);
                        createStatement.execute(ct);
                    } else {
                        ct = db.getDataTableCreationStatement(tableName);
                        createStatement.execute(ct);
                    }
                    createStatement.close();
                    createStatement = null;
                    con.commit();
                    tablesCreated.add(tableName);
                }
            }
            if (options.isDropTablesOnClose()) {
                this.tablesToBeDropped.addAll(tablesCreated);
            }
            LOG.info("RDBBlobStore instantiated for database " + dbDesc + ", using driver: " + driverDesc + ", connecting to: " + dbUrl);
            if (!tablesPresent.isEmpty()) {
                LOG.info("Tables present upon startup: " + tablesPresent);
            }
            if (!tablesCreated.isEmpty()) {
                LOG.info("Tables created upon startup: " + tablesCreated + (options.isDropTablesOnClose() ? " (will be dropped on exit)" : ""));
            }
            this.callStack = LOG.isDebugEnabled() ? new Exception("call stack of RDBBlobStore creation") : null;
        }
        finally {
            this.ch.closeStatement(createStatement);
            this.ch.closeConnection(con);
        }
    }

    @Override
    protected void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        try {
            this.storeBlockInDatabase(digest, level, data);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBlockInDatabase(byte[] digest, int level, byte[] data) throws SQLException {
        block19: {
            String id = StringUtils.convertBytesToHex(digest);
            this.cache.put(id, data);
            Connection con = this.ch.getRWConnection();
            try {
                int count;
                long now = System.currentTimeMillis();
                PreparedStatement prep = con.prepareStatement("update " + this.tnMeta + " set LASTMOD = ? where ID = ?");
                try {
                    prep.setLong(1, now);
                    prep.setString(2, id);
                    count = prep.executeUpdate();
                }
                catch (SQLException ex) {
                    LOG.error("trying to update metadata", (Throwable)ex);
                    throw new RuntimeException("trying to update metadata", ex);
                }
                finally {
                    prep.close();
                }
                if (count != 0) break block19;
                try {
                    prep = con.prepareStatement("insert into " + this.tnData + "(ID, DATA) values(?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setBytes(2, data);
                        prep.execute();
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException ex) {
                    String message = "insert document failed for id " + id + " with length " + data.length + " (check max size of datastore_data.data)";
                    LOG.error(message, (Throwable)ex);
                    throw new RuntimeException(message, ex);
                }
                try {
                    prep = con.prepareStatement("insert into " + this.tnMeta + "(ID, LVL, LASTMOD) values(?, ?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setInt(2, level);
                        prep.setLong(3, now);
                        prep.execute();
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            finally {
                con.commit();
                this.ch.closeConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBlockFromBackend(byte[] digest) throws Exception {
        byte[] data;
        String id = StringUtils.convertBytesToHex(digest);
        Connection con = this.ch.getROConnection();
        try {
            PreparedStatement prep = con.prepareStatement("select DATA from " + this.tnData + " where ID = ?");
            try {
                prep.setString(1, id);
                ResultSet rs = prep.executeQuery();
                if (!rs.next()) {
                    throw new IOException("Datastore block " + id + " not found");
                }
                data = rs.getBytes(1);
            }
            finally {
                prep.close();
            }
        }
        finally {
            con.commit();
            this.ch.closeConnection(con);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        String id = StringUtils.convertBytesToHex(blockId.getDigest());
        byte[] data = (byte[])this.cache.get(id);
        if (data == null) {
            Connection con = this.ch.getROConnection();
            try {
                PreparedStatement prep = con.prepareStatement("select DATA from " + this.tnData + " where ID = ?");
                try {
                    prep.setString(1, id);
                    ResultSet rs = prep.executeQuery();
                    if (!rs.next()) {
                        throw new IOException("Datastore block " + id + " not found");
                    }
                    data = rs.getBytes(1);
                }
                finally {
                    prep.close();
                }
                this.cache.put(id, data);
            }
            finally {
                con.commit();
                this.ch.closeConnection(con);
            }
        }
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    @Override
    public void startMark() throws IOException {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        Connection con = this.ch.getRWConnection();
        PreparedStatement prep = null;
        try {
            if (this.minLastModified == 0L) {
                return;
            }
            String id = StringUtils.convertBytesToHex(blockId.getDigest());
            prep = con.prepareStatement("update " + this.tnMeta + " set LASTMOD = ? where ID = ? and LASTMOD < ?");
            prep.setLong(1, System.currentTimeMillis());
            prep.setString(2, id);
            prep.setLong(3, this.minLastModified);
            prep.executeUpdate();
            prep.close();
        }
        finally {
            this.ch.closeStatement(prep);
            con.commit();
            this.ch.closeConnection(con);
        }
    }

    @Override
    public int sweep() throws IOException {
        try {
            return this.sweepFromDatabase();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sweepFromDatabase() throws SQLException {
        int n;
        Connection con = this.ch.getRWConnection();
        PreparedStatement prepCheck = null;
        PreparedStatement prepDelMeta = null;
        PreparedStatement prepDelData = null;
        ResultSet rs = null;
        try {
            int count = 0;
            prepCheck = con.prepareStatement("select ID from " + this.tnMeta + " where LASTMOD < ?");
            prepCheck.setLong(1, this.minLastModified);
            rs = prepCheck.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            rs.close();
            rs = null;
            prepCheck.close();
            prepCheck = null;
            prepDelMeta = con.prepareStatement("delete from " + this.tnMeta + " where ID = ?");
            prepDelData = con.prepareStatement("delete from " + this.tnData + " where ID = ?");
            for (String id : ids) {
                prepDelMeta.setString(1, id);
                prepDelMeta.execute();
                prepDelData.setString(1, id);
                prepDelData.execute();
                ++count;
            }
            prepDelMeta.close();
            prepDelMeta = null;
            prepDelData.close();
            prepDelData = null;
            this.minLastModified = 0L;
            n = count;
            this.ch.closeResultSet(rs);
        }
        catch (Throwable throwable) {
            this.ch.closeResultSet(rs);
            this.ch.closeStatement(prepCheck);
            this.ch.closeStatement(prepDelMeta);
            this.ch.closeStatement(prepDelData);
            con.commit();
            this.ch.closeConnection(con);
            throw throwable;
        }
        this.ch.closeStatement(prepCheck);
        this.ch.closeStatement(prepDelMeta);
        this.ch.closeStatement(prepDelData);
        con.commit();
        this.ch.closeConnection(con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        if (chunkIds.isEmpty()) {
            return true;
        }
        Connection con = this.ch.getRWConnection();
        PreparedStatement prepMeta = null;
        PreparedStatement prepData = null;
        try {
            StringBuilder inClause = new StringBuilder();
            int batch = chunkIds.size();
            for (int i = 0; i < batch; ++i) {
                inClause.append('?');
                if (i == batch - 1) continue;
                inClause.append(',');
            }
            if (maxLastModifiedTime > 0L) {
                prepMeta = con.prepareStatement("delete from " + this.tnMeta + " where ID in (" + inClause.toString() + ") and LASTMOD <= ?");
                prepMeta.setLong(batch + 1, maxLastModifiedTime);
                prepData = con.prepareStatement("delete from " + this.tnData + " where ID in (" + inClause.toString() + ") and not exists(select * from " + this.tnMeta + " m where ID = m.ID and m.LASTMOD <= ?)");
                prepData.setLong(batch + 1, maxLastModifiedTime);
            } else {
                prepMeta = con.prepareStatement("delete from " + this.tnMeta + " where ID in (" + inClause.toString() + ")");
                prepData = con.prepareStatement("delete from " + this.tnData + " where ID in (" + inClause.toString() + ")");
            }
            for (int idx = 0; idx < batch; ++idx) {
                prepMeta.setString(idx + 1, chunkIds.get(idx));
                prepData.setString(idx + 1, chunkIds.get(idx));
            }
            prepMeta.execute();
            prepData.execute();
            prepMeta.close();
            prepMeta = null;
            prepData.close();
            prepData = null;
        }
        finally {
            this.ch.closeStatement(prepMeta);
            this.ch.closeStatement(prepData);
            con.commit();
            this.ch.closeConnection(con);
        }
        return true;
    }

    @Override
    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        return new ChunkIdIterator(this.ch, maxLastModifiedTime, this.tnMeta);
    }

    static {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            IDSIZE = md.getDigestLength() * 2;
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error("can't determine digest length for blob store", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private static class ChunkIdIterator
    extends AbstractIterator<String> {
        private long maxLastModifiedTime;
        private RDBConnectionHandler ch;
        private static int BATCHSIZE = 65536;
        private List<String> results = new LinkedList<String>();
        private String lastId = null;
        private String metaTable;

        public ChunkIdIterator(RDBConnectionHandler ch, long maxLastModifiedTime, String metaTable) {
            this.maxLastModifiedTime = maxLastModifiedTime;
            this.ch = ch;
            this.metaTable = metaTable;
        }

        protected String computeNext() {
            if (!this.results.isEmpty()) {
                return this.results.remove(0);
            }
            if (this.refill()) {
                return this.computeNext();
            }
            return (String)this.endOfData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean refill() {
            boolean bl;
            StringBuffer query = new StringBuffer();
            query.append("select ID from " + this.metaTable);
            if (this.maxLastModifiedTime > 0L) {
                query.append(" where LASTMOD <= ?");
                if (this.lastId != null) {
                    query.append(" and ID > ?");
                }
            } else if (this.lastId != null) {
                query.append(" where ID > ?");
            }
            query.append(" order by ID");
            Connection connection = null;
            connection = this.ch.getROConnection();
            PreparedStatement prep = null;
            ResultSet rs = null;
            try {
                prep = connection.prepareStatement(query.toString());
                int idx = 1;
                if (this.maxLastModifiedTime > 0L) {
                    prep.setLong(idx++, this.maxLastModifiedTime);
                }
                if (this.lastId != null) {
                    prep.setString(idx, this.lastId);
                }
                prep.setFetchSize(BATCHSIZE);
                rs = prep.executeQuery();
                while (rs.next()) {
                    this.lastId = rs.getString(1);
                    this.results.add(this.lastId);
                }
                rs.close();
                rs = null;
                bl = !this.results.isEmpty();
                this.ch.closeResultSet(rs);
            }
            catch (Throwable throwable) {
                try {
                    this.ch.closeResultSet(rs);
                    this.ch.closeStatement(prep);
                    connection.commit();
                    this.ch.closeConnection(connection);
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.debug("error executing ID lookup", (Throwable)ex);
                    this.ch.rollbackConnection(connection);
                    this.ch.closeConnection(connection);
                    return false;
                }
            }
            this.ch.closeStatement(prep);
            connection.commit();
            this.ch.closeConnection(connection);
            return bl;
        }
    }

    protected static enum DB {
        H2("H2"){

            @Override
            public void checkVersion(DatabaseMetaData md) throws SQLException {
                RDBBlobStore.versionCheck(md, 1, 4, this.description);
            }
        }
        ,
        DB2("DB2"){

            @Override
            public void checkVersion(DatabaseMetaData md) throws SQLException {
                RDBBlobStore.versionCheck(md, 10, 5, this.description);
            }

            @Override
            public String getDataTableCreationStatement(String tableName) {
                return "create table " + tableName + " (ID varchar(" + IDSIZE + ") not null primary key, DATA blob(" + 0x200000 + "))";
            }
        }
        ,
        MSSQL("Microsoft SQL Server"){

            @Override
            public void checkVersion(DatabaseMetaData md) throws SQLException {
                RDBBlobStore.versionCheck(md, 11, 0, this.description);
            }

            @Override
            public String getDataTableCreationStatement(String tableName) {
                return "create table " + tableName + " (ID varchar(" + IDSIZE + ") not null primary key, DATA varbinary(max))";
            }
        }
        ,
        MYSQL("MySQL"){

            @Override
            public void checkVersion(DatabaseMetaData md) throws SQLException {
                RDBBlobStore.versionCheck(md, 5, 5, this.description);
            }

            @Override
            public String getDataTableCreationStatement(String tableName) {
                return "create table " + tableName + " (ID varchar(" + IDSIZE + ") not null primary key, DATA mediumblob)";
            }
        }
        ,
        ORACLE("Oracle"){

            @Override
            public void checkVersion(DatabaseMetaData md) throws SQLException {
                RDBBlobStore.versionCheck(md, 12, 1, this.description);
            }

            @Override
            public String getMetaTableCreationStatement(String tableName) {
                return "create table " + tableName + " (ID varchar(" + IDSIZE + ") not null primary key, LVL number, LASTMOD number)";
            }
        }
        ,
        POSTGRES("PostgreSQL"){

            @Override
            public void checkVersion(DatabaseMetaData md) throws SQLException {
                RDBBlobStore.versionCheck(md, 9, 3, this.description);
            }

            @Override
            public String getDataTableCreationStatement(String tableName) {
                return "create table " + tableName + " (ID varchar(" + IDSIZE + ") not null primary key, DATA bytea)";
            }
        }
        ,
        DEFAULT("default"){};

        protected String description;

        public void checkVersion(DatabaseMetaData md) throws SQLException {
            LOG.info("Unknown database type: " + md.getDatabaseProductName());
        }

        public String getDataTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(" + IDSIZE + ") not null primary key, DATA blob)";
        }

        public String getMetaTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(" + IDSIZE + ") not null primary key, LVL int, LASTMOD bigint)";
        }

        private DB(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        @Nonnull
        public static DB getValue(String desc) {
            for (DB db : DB.values()) {
                if (db.description.equals(desc)) {
                    return db;
                }
                if (db != DB2 || !desc.startsWith("DB2/")) continue;
                return db;
            }
            LOG.error("DB type " + desc + " unknown, trying default settings");
            DB.DEFAULT.description = desc + " - using default settings";
            return DEFAULT;
        }
    }
}

