/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBConnectionHandler {
    private final DataSource ds;
    private static final Logger LOG = LoggerFactory.getLogger(RDBConnectionHandler.class);
    private static final boolean CHECKCONNECTIONONCLOSE = Boolean.getBoolean("org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler.CHECKCONNECTIONONCLOSE");

    public RDBConnectionHandler(@Nonnull DataSource ds) {
        this.ds = ds;
    }

    @Nonnull
    public Connection getROConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        c.setAutoCommit(false);
        c.setReadOnly(true);
        return c;
    }

    @Nonnull
    public Connection getRWConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        c.setAutoCommit(false);
        c.setReadOnly(false);
        return c;
    }

    public void rollbackConnection(@Nullable Connection c) {
        if (c != null) {
            try {
                c.rollback();
            }
            catch (SQLException ex) {
                LOG.error("error on rollback (ignored)", (Throwable)ex);
            }
        }
    }

    public void closeConnection(Connection c) {
        if (c != null) {
            try {
                if (CHECKCONNECTIONONCLOSE) {
                    try {
                        c.setReadOnly(!c.isReadOnly());
                        c.setReadOnly(!c.isReadOnly());
                    }
                    catch (SQLException ex2) {
                        LOG.error("got dirty connection", (Throwable)ex2);
                        throw new DocumentStoreException("dirty connection on close", ex2);
                    }
                }
                c.close();
            }
            catch (SQLException ex) {
                LOG.error("exception on connection close (ignored)", (Throwable)ex);
            }
        }
    }

    public <T extends Statement> T closeStatement(@CheckForNull T stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                LOG.debug("Closing statement", (Throwable)ex);
            }
        }
        return null;
    }

    public ResultSet closeResultSet(@CheckForNull ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                LOG.debug("Closing result set", (Throwable)ex);
            }
        }
        return null;
    }
}

