/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheValue;

public final class StringValue
implements CacheValue {
    private final String value;

    public StringValue(@Nonnull String value) {
        this.value = (String)Preconditions.checkNotNull((Object)value);
    }

    @Override
    public int getMemory() {
        return 56 + this.value.length() * 2;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StringValue) {
            StringValue other = (StringValue)obj;
            return this.value.equals(other.value);
        }
        return false;
    }

    public String toString() {
        return this.value;
    }

    public String asString() {
        return this.value;
    }

    public static StringValue fromString(String value) {
        return new StringValue(value);
    }
}

