/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.ProgressNotificationEditor;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexUpdate
implements Editor {
    private static final Logger log = LoggerFactory.getLogger(IndexUpdate.class);
    private final IndexUpdateRootState rootState;
    private final NodeBuilder builder;
    private final IndexUpdate parent;
    private final String name;
    private String path;
    private final List<Editor> editors = Lists.newArrayList();
    private final Map<String, Editor> reindex = new HashMap<String, Editor>();
    private MissingIndexProviderStrategy missingProvider = new MissingIndexProviderStrategy();

    public IndexUpdate(IndexEditorProvider provider, String async, NodeState root, NodeBuilder builder, IndexUpdateCallback updateCallback) {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.rootState = new IndexUpdateRootState(provider, async, root, updateCallback);
        this.builder = (NodeBuilder)Preconditions.checkNotNull((Object)builder);
    }

    private IndexUpdate(IndexUpdate parent, String name) {
        this.parent = (IndexUpdate)Preconditions.checkNotNull((Object)parent);
        this.name = name;
        this.rootState = parent.rootState;
        this.builder = parent.builder.getChildNode((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        CommitFailedException exception;
        this.collectIndexEditors(this.builder.getChildNode("oak:index"), before);
        if (!this.reindex.isEmpty()) {
            log.info("Reindexing will be performed for following indexes: {}", this.reindex.keySet());
            this.rootState.reindexedIndexes.addAll(this.reindex.keySet());
        }
        if ((exception = EditorDiff.process(VisibleEditor.wrap(IndexUpdate.wrapProgress(CompositeEditor.compose(this.reindex.values()), "Reindexing")), EmptyNodeState.MISSING_NODE, after)) != null) {
            throw exception;
        }
        for (Editor editor : this.editors) {
            editor.enter(before, after);
        }
    }

    public boolean isReindexingPerformed() {
        return !this.getReindexStats().isEmpty();
    }

    public List<String> getReindexStats() {
        return this.rootState.getReindexStats();
    }

    private boolean shouldReindex(NodeBuilder definition, NodeState before, String name) {
        boolean result;
        PropertyState ps = definition.getProperty("reindex");
        if (ps != null && ps.getValue(Type.BOOLEAN).booleanValue()) {
            return true;
        }
        boolean bl = result = !before.getChildNode("oak:index").hasChildNode(name);
        if (result) {
            log.info("Found a new index node [{}]. Reindexing is requested", (Object)name);
        }
        return result;
    }

    private void collectIndexEditors(NodeBuilder definitions, NodeState before) throws CommitFailedException {
        for (String name : definitions.getChildNodeNames()) {
            String type;
            NodeBuilder definition = definitions.getChildNode(name);
            if (!Objects.equal((Object)this.rootState.async, (Object)definition.getString("async")) || (type = definition.getString("type")) == null) continue;
            boolean shouldReindex = this.shouldReindex(definition, before, name);
            Editor editor = this.rootState.provider.getIndexEditor(type, definition, this.rootState.root, this.rootState.newCallback(IndexUpdate.getIndexPath(this.getPath(), name), shouldReindex));
            if (editor == null) {
                this.missingProvider.onMissingIndex(type, definition);
                continue;
            }
            if (shouldReindex) {
                if (definition.getBoolean("reindex-async") && definition.getString("async") == null) {
                    definition.setProperty("async", "async-reindex");
                    continue;
                }
                definition.setProperty("reindex", false);
                this.incrementReIndexCount(definition);
                for (String rm : definition.getChildNodeNames()) {
                    if (!NodeStateUtils.isHidden(rm)) continue;
                    definition.getChildNode(rm).remove();
                }
                this.reindex.put(PathUtils.concat(this.getPath(), "oak:index", name), editor);
                continue;
            }
            this.editors.add(editor);
        }
    }

    private void incrementReIndexCount(NodeBuilder definition) {
        long count = 0L;
        if (definition.hasProperty("reindexCount")) {
            count = definition.getProperty("reindexCount").getValue(Type.LONG);
        }
        definition.setProperty("reindexCount", count + 1L);
    }

    private String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.leave(before, after);
        }
        if (this.parent == null) {
            if (this.rootState.isReindexingPerformed()) {
                log.info(this.rootState.getReport());
            } else if (log.isDebugEnabled()) {
                log.debug(this.rootState.getReport());
            }
        }
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyDeleted(before);
        }
    }

    @Override
    @Nonnull
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        ArrayList children = Lists.newArrayListWithCapacity((int)(1 + this.editors.size()));
        children.add(new IndexUpdate(this, name));
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeAdded(name, after);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    @Override
    @Nonnull
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        ArrayList children = Lists.newArrayListWithCapacity((int)(1 + this.editors.size()));
        children.add(new IndexUpdate(this, name));
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeChanged(name, before, after);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    @Override
    @CheckForNull
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        ArrayList children = Lists.newArrayListWithCapacity((int)this.editors.size());
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeDeleted(name, before);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    protected Set<String> getReindexedDefinitions() {
        return this.reindex.keySet();
    }

    private static String getIndexPath(String path, String indexName) {
        if (PathUtils.denotesRoot(path)) {
            return "/oak:index/" + indexName;
        }
        return path + "/" + "oak:index" + "/" + indexName;
    }

    private static Editor wrapProgress(Editor editor, String message) {
        return ProgressNotificationEditor.wrap(editor, log, message);
    }

    public IndexUpdate withMissingProviderStrategy(MissingIndexProviderStrategy missingProvider) {
        this.missingProvider = missingProvider;
        return this;
    }

    private static final class IndexUpdateRootState {
        final IndexEditorProvider provider;
        final String async;
        final NodeState root;
        final IndexUpdateCallback updateCallback;
        final Set<String> reindexedIndexes = Sets.newHashSet();
        final Map<String, CountingCallback> callbacks = Maps.newHashMap();

        private IndexUpdateRootState(IndexEditorProvider provider, String async, NodeState root, IndexUpdateCallback updateCallback) {
            this.provider = (IndexEditorProvider)Preconditions.checkNotNull((Object)provider);
            this.async = async;
            this.root = (NodeState)Preconditions.checkNotNull((Object)root);
            this.updateCallback = (IndexUpdateCallback)Preconditions.checkNotNull((Object)updateCallback);
        }

        public IndexUpdateCallback newCallback(String indexPath, boolean reindex) {
            CountingCallback cb = new CountingCallback(indexPath, reindex);
            this.callbacks.put(cb.indexName, cb);
            return cb;
        }

        public String getReport() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Indexing report");
            for (CountingCallback cb : this.callbacks.values()) {
                if (!log.isDebugEnabled() && !cb.reindex) continue;
                pw.printf("    - %s%n", cb);
            }
            return sw.toString();
        }

        public List<String> getReindexStats() {
            ArrayList stats = Lists.newArrayList();
            for (CountingCallback cb : this.callbacks.values()) {
                if (!cb.reindex) continue;
                stats.add(cb.toString());
            }
            return stats;
        }

        public boolean isReindexingPerformed() {
            return !this.reindexedIndexes.isEmpty();
        }

        private class CountingCallback
        implements IndexUpdateCallback {
            final String indexName;
            final boolean reindex;
            final Stopwatch watch = Stopwatch.createStarted();
            int count;

            private CountingCallback(String indexName, boolean reindex) {
                this.indexName = indexName;
                this.reindex = reindex;
            }

            @Override
            public void indexUpdate() throws CommitFailedException {
                ++this.count;
                if (this.count % 10000 == 0) {
                    log.info("{} => Indexed {} nodes in {} ...", new Object[]{this.indexName, this.count, this.watch});
                    this.watch.reset().start();
                }
                IndexUpdateRootState.this.updateCallback.indexUpdate();
            }

            public String toString() {
                String reindexMarker = this.reindex ? "*" : "";
                return this.indexName + reindexMarker + "(" + this.count + ")";
            }
        }
    }

    public static class MissingIndexProviderStrategy {
        public void onMissingIndex(String type, NodeBuilder definition) throws CommitFailedException {
            PropertyState ps = definition.getProperty("reindex");
            if (ps != null && ps.getValue(Type.BOOLEAN).booleanValue()) {
                return;
            }
            definition.setProperty("reindex", true);
        }
    }
}

