/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounterMBean;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.util.ApproximateCounter;

public class NodeCounter
implements NodeCounterMBean {
    private final NodeStore store;

    public NodeCounter(NodeStore store) {
        this.store = store;
    }

    private static NodeState child(NodeState n, String ... path) {
        return NodeCounter.child(n, Arrays.asList(path));
    }

    private static NodeState child(NodeState n, Iterable<String> path) {
        for (String p : path) {
            if (n == null) break;
            if (p.length() <= 0) continue;
            n = n.getChildNode(p);
        }
        return n;
    }

    @Override
    public long getEstimatedNodeCount(String path) {
        return NodeCounter.getEstimatedNodeCount(this.store.getRoot(), path, false);
    }

    public static long getEstimatedNodeCount(NodeState root, String path, boolean max) {
        long syncCount;
        NodeState s = NodeCounter.child(root, PathUtils.elements(path));
        if (s == null || !s.exists()) {
            return 0L;
        }
        if (!max && (syncCount = ApproximateCounter.getCountSync(s)) != -1L) {
            return syncCount;
        }
        PropertyState p = s.getProperty(":count");
        if (p != null) {
            long x = p.getValue(Type.LONG);
            if (max) {
                x += 100L;
            }
            return x;
        }
        s = NodeCounter.child(root, "oak:index", "counter", ":index");
        if (s == null) {
            return -1L;
        }
        if ((s = NodeCounter.child(s, PathUtils.elements(path))) == null || !s.exists()) {
            long x = 0L;
            if (max) {
                x += 2000L;
            }
            return x;
        }
        p = s.getProperty(":count");
        if (p == null) {
            long x = 0L;
            if (max) {
                x += 2000L;
            }
            return x;
        }
        long x = p.getValue(Type.LONG);
        if (max) {
            x += 100L;
        }
        return x;
    }

    @Override
    public String getEstimatedChildNodeCounts(String path, int level) {
        StringBuilder buff = new StringBuilder();
        this.collectCounts(buff, path, level);
        return buff.toString();
    }

    private void collectCounts(StringBuilder buff, String path, int level) {
        long count = this.getEstimatedNodeCount(path);
        if (count > 0L) {
            if (buff.length() > 0) {
                buff.append(",\n");
            }
            buff.append(path).append(": ").append(count);
        }
        if (level <= 0) {
            return;
        }
        NodeState s = NodeCounter.child(this.store.getRoot(), PathUtils.elements(path));
        if (!s.exists()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (ChildNodeEntry childNodeEntry : s.getChildNodeEntries()) {
            names.add(childNodeEntry.getName());
        }
        Collections.sort(names);
        for (String string : names) {
            s.getChildNode(string);
            String child = PathUtils.concat(path, string);
            this.collectCounts(buff, child, level - 1);
        }
    }
}

