/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.nodetype;

import org.apache.jackrabbit.JcrConstants;
import org.apache.jackrabbit.oak.plugins.index.nodetype.NodeTypeIndexLookup;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class NodeTypeIndex
implements QueryIndex,
JcrConstants {
    NodeTypeIndex() {
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        if (filter.getFullTextConstraint() != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.containsNativeConstraint()) {
            return Double.POSITIVE_INFINITY;
        }
        if (!NodeTypeIndex.hasNodeTypeRestriction(filter)) {
            return Double.POSITIVE_INFINITY;
        }
        NodeTypeIndexLookup lookup = new NodeTypeIndexLookup(root);
        if (lookup.isIndexed(filter.getPath(), filter)) {
            return lookup.getCost(filter);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Cursor query(Filter filter, NodeState root) {
        NodeTypeIndexLookup lookup = new NodeTypeIndexLookup(root);
        if (!NodeTypeIndex.hasNodeTypeRestriction(filter) || !lookup.isIndexed(filter.getPath(), filter)) {
            throw new IllegalStateException("NodeType index is used even when no index is available for filter " + filter);
        }
        return Cursors.newPathCursorDistinct(lookup.query(filter), filter.getQueryEngineSettings());
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        return "nodeType " + filter.toString();
    }

    @Override
    public String getIndexName() {
        return "nodeType";
    }

    private static boolean hasNodeTypeRestriction(Filter filter) {
        return !filter.matchesAllTypes();
    }
}

