/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedPropertyIndexLookup;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.OrderedContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedPropertyIndex
implements QueryIndex,
QueryIndex.AdvancedQueryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedPropertyIndex.class);

    @Override
    public String getIndexName() {
        return "ordered";
    }

    OrderedPropertyIndexLookup getLookup(NodeState root) {
        return new OrderedPropertyIndexLookup(root);
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    static QueryIndex.IndexPlan.Builder getIndexPlanBuilder(Filter filter) {
        QueryIndex.IndexPlan.Builder b = new QueryIndex.IndexPlan.Builder();
        b.setCostPerExecution(1.0);
        b.setCostPerEntry(1.3);
        b.setFulltextIndex(false);
        b.setIncludesNodeData(false);
        b.setFilter(filter);
        b.setDelayed(false);
        return b;
    }

    @Override
    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState root) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getPlans(Filter, List<OrderEntry>, NodeState)");
            LOG.debug("getPlans() - filter: {} - ", (Object)filter);
            LOG.debug("getPlans() - sortOrder: {} - ", sortOrder);
            LOG.debug("getPlans() - rootState: {} - ", (Object)root);
        }
        ArrayList<QueryIndex.IndexPlan> plans = new ArrayList<QueryIndex.IndexPlan>();
        if (filter.getFullTextConstraint() != null) {
            return plans;
        }
        if (filter.containsNativeConstraint()) {
            return plans;
        }
        OrderedPropertyIndexLookup lookup = this.getLookup(root);
        Collection<Filter.PropertyRestriction> restrictions = filter.getPropertyRestrictions();
        String filterPath = filter.getPath();
        if (sortOrder != null) {
            for (QueryIndex.OrderEntry oe : sortOrder) {
                lookup.collectPlans(filter, filterPath, oe, plans);
            }
        }
        for (Filter.PropertyRestriction pr : restrictions) {
            lookup.collectPlans(filter, filterPath, pr, plans);
        }
        return plans;
    }

    @Override
    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        Iterator<QueryIndex.OrderEntry> i$;
        LOG.debug("getPlanDescription({}, {})", (Object)plan, (Object)root);
        StringBuilder buff = new StringBuilder("ordered");
        NodeState definition = plan.getDefinition();
        int depth = 1;
        boolean found = false;
        if (plan.getPropertyRestriction() != null) {
            Filter.PropertyRestriction pr = plan.getPropertyRestriction();
            String propertyName = PathUtils.getName(pr.propertyName);
            String operation = null;
            PropertyValue value = null;
            if (pr.isNotNullRestriction()) {
                operation = "is not null";
            } else if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                operation = "=";
                value = pr.first;
            } else if (pr.first != null && !pr.first.equals(pr.last)) {
                if (OrderedIndex.OrderDirection.isAscending(definition)) {
                    value = pr.first;
                    operation = pr.firstIncluding ? ">=" : ">";
                }
            } else if (pr.last != null && !pr.last.equals(pr.first) && !OrderedIndex.OrderDirection.isAscending(definition)) {
                value = pr.last;
                String string = operation = pr.lastIncluding ? "<=" : "<";
            }
            if (operation != null) {
                buff.append(' ').append(propertyName).append(' ').append(operation).append(' ').append(value);
                found = true;
            }
        }
        List<QueryIndex.OrderEntry> sortOrder = plan.getSortOrder();
        if (!found && sortOrder != null && !sortOrder.isEmpty() && (i$ = sortOrder.iterator()).hasNext()) {
            QueryIndex.OrderEntry oe = i$.next();
            String propertyName = PathUtils.getName(oe.getPropertyName());
            depth = PathUtils.getDepth(oe.getPropertyName());
            buff.append(" order by ").append(propertyName);
        }
        if (depth > 1) {
            buff.append(" ancestor ").append(depth - 1);
        }
        return buff.toString();
    }

    @Override
    public Cursor query(QueryIndex.IndexPlan plan, NodeState root) {
        LOG.debug("query(IndexPlan, NodeState)");
        LOG.debug("query() - plan: {}", (Object)plan);
        LOG.debug("query() - rootState: {}", (Object)root);
        Filter filter = plan.getFilter();
        List<QueryIndex.OrderEntry> sortOrder = plan.getSortOrder();
        String pathPrefix = plan.getPathPrefix();
        Iterable<String> paths = null;
        OrderedContentMirrorStoreStrategy strategy = OrderedPropertyIndexLookup.getStrategy(plan.getDefinition());
        int depth = 1;
        Filter.PropertyRestriction pr = plan.getPropertyRestriction();
        if (pr != null) {
            String propertyName = PathUtils.getName(pr.propertyName);
            depth = PathUtils.getDepth(pr.propertyName);
            paths = strategy.query(plan.getFilter(), propertyName, plan.getDefinition(), pr, pathPrefix);
        }
        if (paths == null && sortOrder != null && !sortOrder.isEmpty()) {
            for (QueryIndex.OrderEntry oe : sortOrder) {
                String propertyName = PathUtils.getName(oe.getPropertyName());
                depth = PathUtils.getDepth(oe.getPropertyName());
                paths = strategy.query(plan.getFilter(), propertyName, plan.getDefinition(), new Filter.PropertyRestriction(), pathPrefix);
            }
        }
        if (paths == null) {
            throw new IllegalStateException("OrderedPropertyIndex index is used even when no index is available for filter " + filter);
        }
        Cursor cursor = Cursors.newPathCursor(paths, filter.getQueryEngineSettings());
        if (depth > 1) {
            cursor = Cursors.newAncestorCursor(cursor, depth - 1, filter.getQueryEngineSettings());
        }
        return cursor;
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        return this.getPlanDescription(OrderedPropertyIndex.getIndexPlanBuilder(filter).build(), root);
    }

    @Override
    public Cursor query(Filter filter, NodeState root) {
        return this.query(OrderedPropertyIndex.getIndexPlanBuilder(filter).build(), root);
    }
}

