/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.UniqueEntryStoreStrategy;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class PropertyIndexEditor
implements IndexEditor {
    private static final IndexStoreStrategy MIRROR = new ContentMirrorStoreStrategy();
    private static final IndexStoreStrategy UNIQUE = new UniqueEntryStoreStrategy();
    private final PropertyIndexEditor parent;
    private final String name;
    private String path;
    private final NodeBuilder definition;
    private final NodeState root;
    private final Set<String> propertyNames;
    private final Predicate<NodeState> typePredicate;
    private final Set<String> keysToCheckForUniqueness;
    private boolean typeChanged;
    private Set<String> beforeKeys;
    private Set<String> afterKeys;
    private final IndexUpdateCallback updateCallback;

    public PropertyIndexEditor(NodeBuilder definition, NodeState root, IndexUpdateCallback updateCallback) {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.definition = definition;
        this.root = root;
        PropertyState names = definition.getProperty("propertyNames");
        this.propertyNames = names.count() == 1 ? Collections.singleton(names.getValue(Type.NAME, 0)) : Sets.newHashSet(names.getValue(Type.NAMES));
        this.typePredicate = definition.hasProperty("declaringNodeTypes") ? new TypePredicate(root, definition.getNames("declaringNodeTypes")) : null;
        this.keysToCheckForUniqueness = definition.getBoolean("unique") ? Sets.newHashSet() : null;
        this.updateCallback = updateCallback;
    }

    PropertyIndexEditor(PropertyIndexEditor parent, String name) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.definition = parent.definition;
        this.root = parent.root;
        this.propertyNames = parent.getPropertyNames();
        this.typePredicate = parent.typePredicate;
        this.keysToCheckForUniqueness = parent.keysToCheckForUniqueness;
        this.updateCallback = parent.updateCallback;
    }

    Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    private String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    private static Set<String> addValueKeys(Set<String> keys, PropertyState property) {
        if (property.getType().tag() != 2 && property.count() > 0) {
            if (keys == null) {
                keys = Sets.newHashSet();
            }
            keys.addAll(PropertyIndex.encode(PropertyValues.create(property)));
        }
        return keys;
    }

    private static Set<String> getMatchingKeys(NodeState state, Iterable<String> propertyNames) {
        Set<String> keys = null;
        for (String propertyName : propertyNames) {
            PropertyState property = state.getProperty(propertyName);
            if (property == null) continue;
            keys = PropertyIndexEditor.addValueKeys(keys, property);
        }
        return keys;
    }

    IndexStoreStrategy getStrategy(boolean unique) {
        return unique ? UNIQUE : MIRROR;
    }

    @Override
    public void enter(NodeState before, NodeState after) {
        this.typeChanged = this.typePredicate == null;
        this.beforeKeys = null;
        this.afterKeys = null;
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.typePredicate != null) {
            if (this.typeChanged) {
                this.beforeKeys = PropertyIndexEditor.getMatchingKeys(before, this.getPropertyNames());
                this.afterKeys = PropertyIndexEditor.getMatchingKeys(after, this.getPropertyNames());
            }
            if (this.beforeKeys != null && !this.typePredicate.apply((Object)before)) {
                this.beforeKeys = null;
            }
            if (this.afterKeys != null && !this.typePredicate.apply((Object)after)) {
                this.afterKeys = null;
            }
        }
        if (this.beforeKeys != null || this.afterKeys != null) {
            if (this.beforeKeys == null || this.typePredicate != null && !this.typePredicate.apply((Object)before)) {
                this.beforeKeys = Sets.newHashSet();
            } else if (this.afterKeys == null) {
                this.afterKeys = Sets.newHashSet();
            } else {
                HashSet sharedKeys = Sets.newHashSet(this.beforeKeys);
                sharedKeys.retainAll(this.afterKeys);
                this.beforeKeys.removeAll(sharedKeys);
                this.afterKeys.removeAll(sharedKeys);
            }
            if (!this.beforeKeys.isEmpty() || !this.afterKeys.isEmpty()) {
                this.updateCallback.indexUpdate();
                NodeBuilder index = this.definition.child(":index");
                String properties = this.definition.getString("propertyNames");
                this.getStrategy(this.keysToCheckForUniqueness != null).update(index, this.getPath(), properties, this.definition, this.beforeKeys, this.afterKeys);
                if (this.keysToCheckForUniqueness != null) {
                    this.keysToCheckForUniqueness.addAll(this.afterKeys);
                }
            }
        }
        if (this.parent == null) {
            this.definition.child(":index");
            if (this.keysToCheckForUniqueness != null && !this.keysToCheckForUniqueness.isEmpty()) {
                NodeState indexMeta = this.definition.getNodeState();
                IndexStoreStrategy s = this.getStrategy(true);
                for (String key : this.keysToCheckForUniqueness) {
                    if (s.count(this.root, indexMeta, Collections.singleton(key), 2) <= 1L) continue;
                    String msg = String.format("Uniqueness constraint violated at path [%s] for one of the property in %s having value %s", this.getPath(), this.propertyNames, key);
                    throw new CommitFailedException("Constraint", 30, msg);
                }
            }
        }
    }

    private static boolean isTypeProperty(String name) {
        return "jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name);
    }

    @Override
    public void propertyAdded(PropertyState after) {
        String name = after.getName();
        boolean bl = this.typeChanged = this.typeChanged || PropertyIndexEditor.isTypeProperty(name);
        if (this.getPropertyNames().contains(name)) {
            this.afterKeys = PropertyIndexEditor.addValueKeys(this.afterKeys, after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) {
        String name = after.getName();
        boolean bl = this.typeChanged = this.typeChanged || PropertyIndexEditor.isTypeProperty(name);
        if (this.getPropertyNames().contains(name)) {
            this.beforeKeys = PropertyIndexEditor.addValueKeys(this.beforeKeys, before);
            this.afterKeys = PropertyIndexEditor.addValueKeys(this.afterKeys, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) {
        String name = before.getName();
        boolean bl = this.typeChanged = this.typeChanged || PropertyIndexEditor.isTypeProperty(name);
        if (this.getPropertyNames().contains(name)) {
            this.beforeKeys = PropertyIndexEditor.addValueKeys(this.beforeKeys, before);
        }
    }

    PropertyIndexEditor getChildIndexEditor(@Nonnull PropertyIndexEditor parent, @Nonnull String name) {
        return new PropertyIndexEditor(parent, name);
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) {
        return this.getChildIndexEditor(this, name);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return this.getChildIndexEditor(this, name);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) {
        return this.getChildIndexEditor(this, name);
    }
}

