/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.strategy;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedContentMirrorStoreStrategy
extends ContentMirrorStoreStrategy {
    public static final Iterable<String> EMPTY_NEXT = Collections.nCopies(OrderedIndex.LANES, "");
    public static final String[] EMPTY_NEXT_ARRAY = (String[])Iterables.toArray(EMPTY_NEXT, String.class);
    public static final String NEXT = ":next";
    public static final String START = ":start";
    public static final NodeState EMPTY_START_NODE = EmptyNodeState.EMPTY_NODE.builder().setProperty(":next", EMPTY_NEXT, Type.STRINGS).getNodeState();
    private static final Logger LOG = LoggerFactory.getLogger(OrderedContentMirrorStoreStrategy.class);
    private static final Random RND = new Random(System.currentTimeMillis());
    private static final int MAX_RETRIES = OrderedIndex.LANES + 1;
    private OrderedIndex.OrderDirection direction = OrderedIndex.DEFAULT_DIRECTION;

    public OrderedContentMirrorStoreStrategy() {
    }

    public OrderedContentMirrorStoreStrategy(OrderedIndex.OrderDirection direction) {
        this();
        this.direction = direction;
    }

    private static void printWalkedLanes(String msg, String[] walked) {
        if (LOG.isTraceEnabled()) {
            String m;
            String string = m = msg == null ? "" : msg;
            if (walked == null) {
                LOG.trace(m + " walked: null");
            } else {
                for (int i = 0; i < walked.length; ++i) {
                    LOG.trace("{}walked[{}]: {}", new Object[]{m, i, walked[i]});
                }
            }
        }
    }

    @Override
    NodeBuilder fetchKeyNode(@Nonnull NodeBuilder index, @Nonnull String key) {
        LOG.debug("fetchKeyNode() - === new item '{}'", (Object)key);
        NodeBuilder node = null;
        NodeBuilder start = index.child(START);
        OrderedIndex.Predicate<String> condition = this.direction.isAscending() ? new PredicateGreaterThan(key, true) : new PredicateLessThan(key, true);
        String[] walked = new String[OrderedIndex.LANES];
        if (Strings.isNullOrEmpty((String)OrderedContentMirrorStoreStrategy.getPropertyNext(start))) {
            OrderedContentMirrorStoreStrategy.setPropertyNext(start, EMPTY_NEXT_ARRAY);
        }
        String entry = this.seek(index, condition, walked, 0, new FixingDanglingLinkCallback(index));
        if (LOG.isDebugEnabled()) {
            LOG.debug("fetchKeyNode() - entry: {} ", (Object)entry);
            OrderedContentMirrorStoreStrategy.printWalkedLanes("fetchKeyNode() - ", walked);
        }
        if (entry != null && entry.equals(key)) {
            LOG.debug("fetchKeyNode() - node already there.");
            node = index.getChildNode(key);
        } else {
            node = index.child(key);
            OrderedContentMirrorStoreStrategy.setPropertyNext(node, EMPTY_NEXT_ARRAY);
            int lane = this.getLane();
            LOG.debug("fetchKeyNode() - extracted lane: {}", (Object)lane);
            for (int l = lane; l >= 0; --l) {
                NodeBuilder predecessor = index.getChildNode(walked[l]);
                String next = OrderedContentMirrorStoreStrategy.getPropertyNext(predecessor, l);
                OrderedContentMirrorStoreStrategy.setPropertyNext(predecessor, key, l);
                OrderedContentMirrorStoreStrategy.setPropertyNext(node, next, l);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("fetchKeyNode() - on lane: {}", (Object)l);
                LOG.debug("fetchKeyNode() - next from previous: {}", (Object)next);
                LOG.debug("fetchKeyNode() - new status of predecessor name: {} - {} ", (Object)walked[l], (Object)predecessor.getProperty(NEXT));
                LOG.debug("fetchKeyNode() - new node name: {} - {}", (Object)key, (Object)node.getProperty(NEXT));
            }
        }
        return node;
    }

    @Override
    void prune(NodeBuilder index, Deque<NodeBuilder> builders, String key) {
        LOG.debug("prune() - deleting: {}", (Object)key);
        for (NodeBuilder node : builders) {
            if (node.hasProperty("match") || node.getChildNodeCount(1L) > 0L) {
                return;
            }
            if (!node.exists()) continue;
            if (node.hasProperty(NEXT)) {
                String lane0Next;
                String entry;
                String[] walkedLanes = new String[OrderedIndex.LANES];
                do {
                    entry = this.seek(index, new PredicateEquals(key), walkedLanes, 0, new LoggingDanglinLinkCallback());
                    lane0Next = OrderedContentMirrorStoreStrategy.getPropertyNext(index.getChildNode(walkedLanes[0]));
                    if (LOG.isDebugEnabled()) {
                        for (int i = 0; i < walkedLanes.length; ++i) {
                            LOG.debug("prune() - walkedLanes[{}]: {}", (Object)i, (Object)walkedLanes[i]);
                        }
                    }
                    for (int lane = walkedLanes.length - 1; lane >= 0; --lane) {
                        String prevNext = OrderedContentMirrorStoreStrategy.getPropertyNext(index.getChildNode(walkedLanes[lane]), lane);
                        if (!key.equals(prevNext)) continue;
                        String currNext = OrderedContentMirrorStoreStrategy.getPropertyNext(node, lane);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("prune() - setting next for '{}' on lane '{}' with '{}'", new Object[]{walkedLanes[lane], lane, currNext});
                        }
                        OrderedContentMirrorStoreStrategy.setPropertyNext(index.getChildNode(walkedLanes[lane]), currNext, lane);
                    }
                } while (entry != null && !key.equals(lane0Next));
            }
            node.remove();
        }
    }

    @Override
    @Nonnull
    Iterable<? extends ChildNodeEntry> getChildNodeEntries(@Nonnull NodeState index) {
        return this.getChildNodeEntries(index, false);
    }

    @Nonnull
    Iterable<? extends ChildNodeEntry> getChildNodeEntries(@Nonnull NodeState index, boolean includeStart) {
        Iterable<Object> cne = null;
        NodeState start = index.getChildNode(START);
        String startNext = OrderedContentMirrorStoreStrategy.getPropertyNext(start);
        cne = (!start.exists() || Strings.isNullOrEmpty((String)startNext)) && !includeStart ? Collections.emptyList() : new FullIterable(index, includeStart);
        return cne;
    }

    public Iterable<String> query(Filter filter, String indexName, NodeState indexMeta, Filter.PropertyRestriction pr) {
        return this.query(filter, indexName, indexMeta, pr, "");
    }

    public Iterable<String> query(Filter filter, String indexName, NodeState indexMeta, Filter.PropertyRestriction pr, String pathPrefix) {
        return this.query(filter, indexName, indexMeta, ":index", pr, pathPrefix);
    }

    public Iterable<String> query(final Filter filter, final String indexName, NodeState indexMeta, String indexStorageNodeName, Filter.PropertyRestriction pr, String pathPrefix) {
        String lastEncoded;
        if (LOG.isDebugEnabled()) {
            LOG.debug("query() - filter: {}", (Object)filter);
            LOG.debug("query() - indexName: {}", (Object)indexName);
            LOG.debug("query() - indexMeta: {}", (Object)indexMeta);
            LOG.debug("query() - indexStorageNodeName: {}", (Object)indexStorageNodeName);
            LOG.debug("query() - pr: {}", (Object)pr);
        }
        NodeState indexState = indexMeta.getChildNode(indexStorageNodeName);
        ReadOnlyBuilder index = new ReadOnlyBuilder(indexState);
        final String firstEncoded = pr.first == null ? null : OrderedContentMirrorStoreStrategy.encode(pr.first.getValue(Type.STRING));
        String string = lastEncoded = pr.last == null ? null : OrderedContentMirrorStoreStrategy.encode(pr.last.getValue(Type.STRING));
        if (firstEncoded != null && !firstEncoded.equals(lastEncoded)) {
            LOG.debug("'>' & '>=' and between use case");
            Iterable<String> it = Collections.emptyList();
            if (lastEncoded == null) {
                LOG.debug("> & >= case.");
                String firstValuableItemKey = this.seek(index, new PredicateGreaterThan(firstEncoded, pr.firstIncluding));
                if (firstValuableItemKey != null) {
                    OrderedChildNodeEntry firstValueableItem = new OrderedChildNodeEntry(firstValuableItemKey, indexState.getChildNode(firstValuableItemKey));
                    if (this.direction.isAscending()) {
                        SeekedIterable childrenIterable = new SeekedIterable(indexState, firstValueableItem);
                        it = new QueryResultsWrapper(filter, indexName, childrenIterable, pathPrefix);
                    } else {
                        it = new QueryResultsWrapper(filter, indexName, new BetweenIterable(indexState, firstValueableItem, firstEncoded, pr.firstIncluding, this.direction), pathPrefix);
                    }
                }
            } else {
                String first = firstEncoded;
                String last = lastEncoded;
                boolean includeFirst = pr.firstIncluding;
                boolean includeLast = pr.lastIncluding;
                if (LOG.isDebugEnabled()) {
                    String op1 = includeFirst ? ">=" : ">";
                    String op2 = includeLast ? "<=" : "<";
                    LOG.debug("in between case. direction: {} - Condition: (x {} {} AND x {} {})", new Object[]{this.direction, op1, first, op2, last});
                }
                String firstValuableItemKey = this.direction.equals((Object)OrderedIndex.OrderDirection.ASC) ? this.seek(index, new PredicateGreaterThan(first, includeFirst)) : this.seek(index, new PredicateLessThan(last, includeLast));
                LOG.debug("firstValueableItem: {}", (Object)firstValuableItemKey);
                if (firstValuableItemKey != null) {
                    OrderedChildNodeEntry firstValueableItem = new OrderedChildNodeEntry(firstValuableItemKey, indexState.getChildNode(firstValuableItemKey));
                    BetweenIterable childrenIterable = new BetweenIterable(indexState, firstValueableItem, last, includeLast, this.direction);
                    it = new QueryResultsWrapper(filter, indexName, childrenIterable, pathPrefix);
                }
            }
            return it;
        }
        if (lastEncoded != null && !lastEncoded.equals(firstEncoded)) {
            LOG.debug("'<' & '<=' use case");
            String searchfor = lastEncoded;
            boolean include = pr.lastIncluding;
            PredicateLessThan predicate = new PredicateLessThan(searchfor, include);
            LOG.debug("< & <= case. - searchfor: {} - include: {} - predicate: {}", new Object[]{searchfor, include, predicate});
            String firstValueableItemKey = this.seek(index, predicate);
            LOG.debug("firstValuableItem: {}", (Object)firstValueableItemKey);
            Iterable<String> it = Collections.emptyList();
            if (firstValueableItemKey != null) {
                OrderedChildNodeEntry firstValueableItem = new OrderedChildNodeEntry(firstValueableItemKey, indexState.getChildNode(firstValueableItemKey));
                it = this.direction.isAscending() ? new QueryResultsWrapper(filter, indexName, new BetweenIterable(indexState, firstValueableItem, searchfor, include, this.direction), pathPrefix) : new QueryResultsWrapper(filter, indexName, new SeekedIterable(indexState, firstValueableItem), pathPrefix);
            }
            return it;
        }
        if (firstEncoded != null && firstEncoded.equals(lastEncoded)) {
            LOG.debug("'property = $value' case");
            final NodeState key = indexState.getChildNode(firstEncoded);
            final String pf = pathPrefix;
            if (key.exists()) {
                return new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        ContentMirrorStoreStrategy.PathIterator pi = new ContentMirrorStoreStrategy.PathIterator(filter, indexName, pf);
                        pi.setPathContainsValue(true);
                        pi.enqueue((Iterator<? extends ChildNodeEntry>)Iterators.singletonIterator((Object)new MemoryChildNodeEntry(firstEncoded, key)));
                        return pi;
                    }
                };
            }
            return Collections.emptyList();
        }
        LOG.debug("property is not null. AKA 'open query'. FullIterable");
        return new QueryResultsWrapper(filter, indexName, new FullIterable(indexState, false), pathPrefix);
    }

    private static String encode(@Nonnull String value) {
        String v;
        Preconditions.checkNotNull((Object)value);
        try {
            v = URLEncoder.encode(value, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error while encoding value.");
            v = value;
        }
        return v;
    }

    public long count(NodeState indexMeta, Filter.PropertyRestriction pr, int max) {
        long count = 0L;
        NodeState content = indexMeta.getChildNode(":index");
        Filter.PropertyRestriction lpr = pr;
        if (content.exists()) {
            if (lpr == null) {
                lpr = new Filter.PropertyRestriction();
            }
            if (lpr.firstIncluding && lpr.lastIncluding && lpr.first != null && lpr.first.equals(lpr.last)) {
                String value = lpr.first.getValue(Type.STRING);
                NodeState n = content.getChildNode(value);
                if (n.exists()) {
                    ContentMirrorStoreStrategy.CountingNodeVisitor v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                    v.visit(n);
                    count = v.getEstimatedCount();
                }
            } else if (lpr.isNotNullRestriction()) {
                PropertyState ec = indexMeta.getProperty("entryCount");
                if (ec != null) {
                    count = ec.getValue(Type.LONG);
                } else {
                    ContentMirrorStoreStrategy.CountingNodeVisitor v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                    v.visit(content);
                    count = v.getEstimatedCount();
                }
            } else if (lpr.first != null && !lpr.first.equals(lpr.last)) {
                ContentMirrorStoreStrategy.CountingNodeVisitor v;
                String value = lpr.first.getValue(Type.STRING);
                final String vv = OrderedContentMirrorStoreStrategy.encode(value);
                final boolean include = lpr.firstIncluding;
                final OrderedIndex.OrderDirection dd = this.direction;
                Iterable<? extends ChildNodeEntry> children = this.getChildNodeEntries(content);
                OrderedIndex.Predicate<String> predicate = new OrderedIndex.Predicate<String>(){
                    private String v;
                    private boolean i;
                    private OrderedIndex.OrderDirection d;
                    {
                        this.v = vv;
                        this.i = include;
                        this.d = dd;
                    }

                    public boolean apply(String input) {
                        boolean b = this.d.equals((Object)OrderedIndex.OrderDirection.ASC) ? this.v.compareTo(input) > 0 : this.v.compareTo(input) < 0;
                        b = b || this.i && this.v.equals(input);
                        return b;
                    }

                    @Override
                    public String getSearchFor() {
                        throw new UnsupportedOperationException();
                    }
                };
                int depthTotal = 0;
                for (ChildNodeEntry childNodeEntry : children) {
                    String converted = childNodeEntry.getName();
                    if (!predicate.apply(converted)) continue;
                    v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                    v.visit(content.getChildNode(childNodeEntry.getName()));
                    depthTotal = (int)((long)depthTotal + v.depthTotal);
                    if ((count += (long)v.getCount()) <= (long)max) continue;
                    break;
                }
                v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                v.depthTotal = depthTotal;
                v.count = (int)Math.min(count, Integer.MAX_VALUE);
                count = v.getEstimatedCount();
            } else if (lpr.last != null && !lpr.last.equals(lpr.first)) {
                ContentMirrorStoreStrategy.CountingNodeVisitor v;
                String value = lpr.last.getValue(Type.STRING);
                final String vv = OrderedContentMirrorStoreStrategy.encode(value);
                final boolean include = lpr.lastIncluding;
                final OrderedIndex.OrderDirection dd = this.direction;
                Iterable<? extends ChildNodeEntry> children = this.getChildNodeEntries(content);
                OrderedIndex.Predicate<String> predicate = new OrderedIndex.Predicate<String>(){
                    private String v;
                    private boolean i;
                    private OrderedIndex.OrderDirection d;
                    {
                        this.v = vv;
                        this.i = include;
                        this.d = dd;
                    }

                    public boolean apply(String input) {
                        boolean b = this.d.equals((Object)OrderedIndex.OrderDirection.ASC) ? this.v.compareTo(input) < 0 : this.v.compareTo(input) > 0;
                        b = b || this.i && this.v.equals(input);
                        return b;
                    }

                    @Override
                    public String getSearchFor() {
                        throw new UnsupportedOperationException();
                    }
                };
                int depthTotal = 0;
                for (ChildNodeEntry childNodeEntry : children) {
                    String converted = childNodeEntry.getName();
                    if (!predicate.apply(converted)) continue;
                    v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                    v.visit(content.getChildNode(childNodeEntry.getName()));
                    depthTotal = (int)((long)depthTotal + v.depthTotal);
                    if ((count += (long)v.getCount()) <= (long)max) continue;
                    break;
                }
                v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                v.depthTotal = depthTotal;
                v.count = (int)Math.min(count, Integer.MAX_VALUE);
                count = v.getEstimatedCount();
            }
        }
        return count;
    }

    String seek(@Nonnull NodeBuilder index, @Nonnull OrderedIndex.Predicate<String> condition) {
        return this.seek(index, condition, null, 0, new LoggingDanglinLinkCallback());
    }

    /*
     * Enabled aggressive block sorting
     */
    String seek(@Nonnull NodeBuilder index, @Nonnull OrderedIndex.Predicate<String> condition, @Nullable String[] walkedLanes, int retries, @Nullable DanglingLinkCallback callback) {
        int lane;
        boolean keepWalked = false;
        String searchfor = condition.getSearchFor();
        if (LOG.isDebugEnabled()) {
            LOG.debug("seek() - Searching for: {}", (Object)condition.getSearchFor());
            LOG.debug("seek() - condition: {}", condition);
        }
        OrderedIndex.Predicate<String> predicate = this.direction.isAscending() ? new PredicateLessThan(searchfor, true) : new PredicateGreaterThan(searchfor, true);
        String currentKey = START;
        String found = null;
        if (walkedLanes != null) {
            if (walkedLanes.length != OrderedIndex.LANES) {
                throw new IllegalArgumentException(String.format("Wrong size for keeping track of the Walked Lanes. Expected %d but was %d", OrderedIndex.LANES, walkedLanes.length));
            }
            for (int i = 0; i < walkedLanes.length; ++i) {
                walkedLanes[i] = currentKey;
            }
            keepWalked = true;
        }
        if (this.direction.isAscending() && condition instanceof PredicateLessThan || this.direction.isDescending() && condition instanceof PredicateGreaterThan) {
            LOG.debug("seek() - cross case");
            lane = 0;
            do {
                boolean stillLaning = lane < OrderedIndex.LANES;
                String nextkey = OrderedContentMirrorStoreStrategy.getPropertyNext(index.getChildNode(currentKey), lane);
                if ((Strings.isNullOrEmpty((String)nextkey) || !predicate.apply(nextkey)) && lane < OrderedIndex.LANES) {
                    ++lane;
                } else if (condition.apply(nextkey)) {
                    found = nextkey;
                } else {
                    currentKey = nextkey;
                    if (keepWalked && !Strings.isNullOrEmpty((String)currentKey) && walkedLanes != null) {
                        walkedLanes[lane] = currentKey;
                    }
                }
                if (!Strings.isNullOrEmpty((String)nextkey) && predicate.apply(nextkey)) continue;
                if (!stillLaning) return found;
            } while (found == null);
            return found;
        }
        LOG.debug("seek() - plain case");
        lane = OrderedIndex.LANES - 1;
        NodeBuilder currentNode = null;
        int iteration = 0;
        boolean exitCondition = true;
        do {
            String nextkey;
            boolean stillLaning;
            block21: {
                ++iteration;
                boolean bl = stillLaning = lane > 0;
                if (currentNode == null) {
                    currentNode = index.getChildNode(currentKey);
                }
                if ((Strings.isNullOrEmpty((String)(nextkey = OrderedContentMirrorStoreStrategy.getPropertyNext(currentNode, lane))) || !predicate.apply(nextkey)) && lane > 0) {
                    --lane;
                } else {
                    if (condition.apply(nextkey)) {
                        if (OrderedContentMirrorStoreStrategy.ensureAndCleanNode(index, nextkey, currentKey, lane, callback)) {
                            found = nextkey;
                            break block21;
                        } else {
                            if (retries < MAX_RETRIES) {
                                return this.seek(index, condition, walkedLanes, ++retries, callback);
                            }
                            LOG.debug("Attempted a lookup and fix for {} times. Leaving it be and returning null", (Object)retries);
                            return null;
                        }
                    }
                    currentKey = nextkey;
                    currentNode = null;
                    if (keepWalked && !Strings.isNullOrEmpty((String)currentKey) && walkedLanes != null) {
                        for (int l = lane; l >= 0; --l) {
                            walkedLanes[l] = currentKey;
                        }
                    }
                }
            }
            boolean bl = exitCondition = (!Strings.isNullOrEmpty((String)nextkey) && predicate.apply(nextkey) || stillLaning) && found == null;
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("seek()::plain case - --- iteration: {}", (Object)iteration);
            LOG.trace("seek()::plain case - retries: {},  MAX_RETRIES: {}", (Object)retries, (Object)MAX_RETRIES);
            LOG.trace("seek()::plain case - lane: {}", (Object)lane);
            LOG.trace("seek()::plain case - currentKey: {}", (Object)currentKey);
            LOG.trace("seek()::plain case - nextkey: {}", (Object)nextkey);
            LOG.trace("seek()::plain case - condition.apply(nextkey): {}", (Object)condition.apply(nextkey));
            LOG.trace("seek()::plain case - found: {}", (Object)found);
            LOG.trace("seek()::plain case - !Strings.isNullOrEmpty(nextkey): {}", (Object)(!Strings.isNullOrEmpty((String)nextkey) ? 1 : 0));
            LOG.trace("seek()::plain case - walkingPredicate.apply(nextkey): {}", (Object)predicate.apply(nextkey));
            LOG.trace("seek()::plain case - stillLaning: {}", (Object)stillLaning);
            LOG.trace("seek()::plain case - While Condition: {}", (Object)exitCondition);
        } while (exitCondition);
        return found;
    }

    private static boolean ensureAndCleanNode(@Nonnull NodeBuilder index, @Nonnull String next, @Nonnull String current, int lane, @Nullable DanglingLinkCallback callback) {
        Preconditions.checkNotNull((Object)index);
        Preconditions.checkNotNull((Object)next);
        Preconditions.checkNotNull((Object)current);
        Preconditions.checkArgument((lane < OrderedIndex.LANES && lane >= 0 ? 1 : 0) != 0, (Object)"The lane must be between 0 and LANES");
        if (index.getChildNode(next).exists()) {
            return true;
        }
        if (callback != null) {
            callback.perform(current, next, lane);
        }
        return false;
    }

    static void setPropertyNext(@Nonnull NodeBuilder node, String ... next) {
        if (node != null && next != null) {
            int len;
            for (len = next.length - 1; len >= 0 && next[len].length() == 0; --len) {
            }
            ArrayList<String> list = new ArrayList<String>(++len);
            for (int i = 0; i < len; ++i) {
                list.add(next[i]);
            }
            node.setProperty(NEXT, list, Type.STRINGS);
        }
    }

    public static void setPropertyNext(@Nonnull NodeBuilder node, String value, int lane) {
        PropertyState next;
        if (node != null && value != null && lane >= 0 && lane < OrderedIndex.LANES && (next = node.getProperty(NEXT)) != null) {
            Object[] values;
            if (next.isArray()) {
                values = (String[])Iterables.toArray(next.getValue(Type.STRINGS), String.class);
                if (values.length < OrderedIndex.LANES) {
                    LOG.debug("topping-up the number of lanes.");
                    ArrayList vv = Lists.newArrayList((Object[])values);
                    for (int i = vv.size(); i < OrderedIndex.LANES; ++i) {
                        vv.add("");
                    }
                    values = vv.toArray(new String[vv.size()]);
                }
            } else {
                values = (String[])Iterables.toArray(EMPTY_NEXT, String.class);
                values[0] = next.getValue(Type.STRING);
            }
            values[lane] = value;
            OrderedContentMirrorStoreStrategy.setPropertyNext(node, (String[])values);
        }
    }

    static String getPropertyNext(@Nonnull NodeState nodeState) {
        return OrderedContentMirrorStoreStrategy.getPropertyNext(nodeState, 0);
    }

    static String getPropertyNext(@Nonnull NodeState state, int lane) {
        return OrderedContentMirrorStoreStrategy.getPropertyNext(new ReadOnlyBuilder(state), lane);
    }

    public static String getPropertyNext(@Nonnull NodeBuilder node) {
        return OrderedContentMirrorStoreStrategy.getPropertyNext(node, 0);
    }

    public static String getPropertyNext(@Nonnull NodeBuilder node, int lane) {
        Preconditions.checkNotNull((Object)node);
        String next = "";
        PropertyState ps = node.getProperty(NEXT);
        if (ps != null) {
            if (ps.isArray()) {
                int count = ps.count();
                if (count > 0 && count > lane) {
                    next = ps.getValue(Type.STRING, lane);
                }
            } else {
                next = ps.getValue(Type.STRING);
            }
        }
        return next;
    }

    public int getLane() {
        return this.getLane(RND);
    }

    protected int getLane(@Nonnull Random rnd) {
        int lane;
        int maxLanes = OrderedIndex.LANES - 1;
        for (lane = 0; rnd.nextDouble() < OrderedIndex.DEFAULT_PROBABILITY && lane < maxLanes; ++lane) {
        }
        return lane;
    }

    static class FixingDanglingLinkCallback
    extends LoggingDanglinLinkCallback {
        private final NodeBuilder indexContent;

        public FixingDanglingLinkCallback(@Nonnull NodeBuilder indexContent) {
            this.indexContent = (NodeBuilder)Preconditions.checkNotNull((Object)indexContent);
        }

        @Override
        public void perform(String current, String next, int lane) {
            super.perform(current, next, lane);
            for (int l = lane; l < OrderedIndex.LANES; ++l) {
                OrderedContentMirrorStoreStrategy.setPropertyNext(this.indexContent.getChildNode(current), "", lane);
            }
        }
    }

    static class LoggingDanglinLinkCallback
    implements DanglingLinkCallback {
        private boolean alreadyLogged;

        LoggingDanglinLinkCallback() {
        }

        @Override
        public void perform(@Nonnull String current, @Nonnull String next, int lane) {
            Preconditions.checkNotNull((Object)next);
            Preconditions.checkNotNull((Object)current);
            Preconditions.checkArgument((lane < OrderedIndex.LANES && lane >= 0 ? 1 : 0) != 0, (Object)"The lane must be between 0 and LANES");
            if (!this.alreadyLogged) {
                LOG.warn("Dangling link to '{}' found on lane '{}' for key '{}'. Trying to clean it up. You may consider a reindex", new Object[]{next, lane, current});
                this.alreadyLogged = true;
            }
        }
    }

    static interface DanglingLinkCallback {
        public void perform(String var1, String var2, int var3);
    }

    private static class BetweenIterator
    extends SeekedIterator {
        private OrderedIndex.Predicate<String> condition;

        public BetweenIterator(NodeState index, NodeState start, ChildNodeEntry first, final String lastKey, final boolean lastInclude, final OrderedIndex.OrderDirection direction) {
            super(index, start, first);
            this.condition = new OrderedIndex.Predicate<String>(){
                private String v;
                private boolean i;
                private OrderedIndex.OrderDirection d;
                {
                    this.v = lastKey;
                    this.i = lastInclude;
                    this.d = direction;
                }

                public boolean apply(String input) {
                    boolean compareTo = this.d.equals((Object)OrderedIndex.OrderDirection.ASC) ? this.v.compareTo(input) > 0 : this.v.compareTo(input) < 0;
                    boolean equals = this.v.equals(input);
                    boolean apply = compareTo || this.i && equals;
                    return apply;
                }

                @Override
                public String getSearchFor() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = super.hasNext();
            String name = this.getCurrentName();
            if (name != null && hasNext) {
                String next = OrderedContentMirrorStoreStrategy.getPropertyNext(this.current);
                hasNext = hasNext && this.condition.apply(next);
            }
            return hasNext;
        }
    }

    private static class BetweenIterable
    extends SeekedIterable {
        private String lastKey;
        private boolean lastInclude;
        private OrderedIndex.OrderDirection direction;

        public BetweenIterable(NodeState index, ChildNodeEntry first, String lastKey, boolean lastInclude, OrderedIndex.OrderDirection direction) {
            super(index, first);
            this.lastKey = lastKey;
            this.lastInclude = lastInclude;
            this.direction = direction;
        }

        @Override
        public Iterator<ChildNodeEntry> iterator() {
            return new BetweenIterator(this.index, this.start, this.first, this.lastKey, this.lastInclude, this.direction);
        }
    }

    static class PredicateLessThan
    implements OrderedIndex.Predicate<String> {
        private String searchforOriginal;
        private boolean include;

        public PredicateLessThan(@Nonnull String searchfor) {
            this(searchfor, false);
        }

        public PredicateLessThan(@Nonnull String searchfor, boolean include) {
            this.searchforOriginal = searchfor;
            this.include = include;
        }

        public boolean apply(String arg0) {
            boolean b = false;
            if (!Strings.isNullOrEmpty((String)arg0)) {
                String name = arg0;
                b = this.searchforOriginal.compareTo(name) > 0 || this.include && this.searchforOriginal.equals(name);
            }
            return b;
        }

        @Override
        public String getSearchFor() {
            return this.searchforOriginal;
        }
    }

    static class PredicateGreaterThan
    implements OrderedIndex.Predicate<String> {
        private String searchforDecoded;
        private boolean include;

        public PredicateGreaterThan(@Nonnull String searchfor) {
            this(searchfor, false);
        }

        public PredicateGreaterThan(@Nonnull String searchfor, boolean include) {
            this.searchforDecoded = searchfor;
            this.include = include;
        }

        public boolean apply(String arg0) {
            boolean b = false;
            if (!Strings.isNullOrEmpty((String)arg0)) {
                String name = arg0;
                b = this.searchforDecoded.compareTo(name) < 0 || this.include && this.searchforDecoded.equals(name);
            }
            return b;
        }

        @Override
        public String getSearchFor() {
            return this.searchforDecoded;
        }
    }

    static class PredicateEquals
    implements OrderedIndex.Predicate<String> {
        private String searchfor;

        public PredicateEquals(@Nonnull String searchfor) {
            this.searchfor = searchfor;
        }

        public boolean apply(String arg0) {
            return !Strings.isNullOrEmpty((String)arg0) && this.searchfor.equals(arg0);
        }

        @Override
        public String getSearchFor() {
            return this.searchfor;
        }
    }

    private static class SeekedIterable
    extends FullIterable {
        ChildNodeEntry first;

        public SeekedIterable(NodeState index, ChildNodeEntry first) {
            super(index, false);
            this.first = first;
        }

        @Override
        public Iterator<ChildNodeEntry> iterator() {
            return new SeekedIterator(this.index, this.start, this.first);
        }
    }

    private static class SeekedIterator
    extends FullIterator {
        private boolean firstReturned;
        private ChildNodeEntry first;

        public SeekedIterator(NodeState index, NodeState start, ChildNodeEntry first) {
            super(index, start, false, first.getNodeState());
            this.first = first;
        }

        @Override
        public boolean hasNext() {
            return !this.firstReturned || super.hasNext();
        }

        @Override
        public ChildNodeEntry next() {
            if (this.firstReturned) {
                return super.next();
            }
            this.currentName = this.first.getName();
            this.current = this.first.getNodeState();
            this.firstReturned = true;
            return this.first;
        }
    }

    private static class FullIterable
    implements Iterable<ChildNodeEntry> {
        private boolean includeStart;
        NodeState index;
        NodeState start;
        NodeState current;

        public FullIterable(NodeState index, boolean includeStart) {
            this.index = index;
            this.includeStart = includeStart;
            NodeState s = index.getChildNode(OrderedContentMirrorStoreStrategy.START);
            this.start = includeStart && !s.exists() ? EMPTY_START_NODE : s;
            this.current = this.start;
        }

        @Override
        public Iterator<ChildNodeEntry> iterator() {
            return new FullIterator(this.index, this.start, this.includeStart, this.current);
        }
    }

    private static class FullIterator
    implements Iterator<ChildNodeEntry> {
        private boolean includeStart;
        private NodeState start;
        NodeState current;
        private NodeState index;
        private NodeBuilder builder;
        String currentName;
        private DanglingLinkCallback dlc = new LoggingDanglinLinkCallback();

        public FullIterator(NodeState index, NodeState start, boolean includeStart, NodeState current) {
            this.includeStart = includeStart;
            this.start = start;
            this.current = current;
            this.index = index;
            this.builder = new ReadOnlyBuilder(index);
        }

        @Override
        public boolean hasNext() {
            String next = OrderedContentMirrorStoreStrategy.getPropertyNext(this.current);
            boolean hasNext = this.includeStart && this.start.equals(this.current) || !this.includeStart && !Strings.isNullOrEmpty((String)next) && OrderedContentMirrorStoreStrategy.ensureAndCleanNode(this.builder, next, this.currentName == null ? "" : this.currentName, 0, this.dlc);
            return hasNext;
        }

        @Override
        public ChildNodeEntry next() {
            OrderedChildNodeEntry entry = null;
            if (this.includeStart && this.start.equals(this.current)) {
                entry = new OrderedChildNodeEntry(OrderedContentMirrorStoreStrategy.START, this.current);
                this.includeStart = false;
            } else if (this.hasNext()) {
                this.currentName = OrderedContentMirrorStoreStrategy.getPropertyNext(this.current);
                this.current = this.index.getChildNode(this.currentName);
                entry = new OrderedChildNodeEntry(this.currentName, this.current);
            } else {
                throw new NoSuchElementException();
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        String getCurrentName() {
            return this.currentName;
        }
    }

    private static class QueryResultsWrapper
    implements Iterable<String> {
        private Iterable<ChildNodeEntry> children;
        private String indexName;
        private Filter filter;
        private String pathPrefix;

        public QueryResultsWrapper(Filter filter, String indexName, Iterable<ChildNodeEntry> children, String pathPrefix) {
            this.children = children;
            this.indexName = indexName;
            this.filter = filter;
            this.pathPrefix = pathPrefix;
        }

        @Override
        public Iterator<String> iterator() {
            ContentMirrorStoreStrategy.PathIterator pi = new ContentMirrorStoreStrategy.PathIterator(this.filter, this.indexName, this.pathPrefix);
            pi.setPathContainsValue(true);
            pi.enqueue(this.children.iterator());
            return pi;
        }
    }

    static class OrderedChildNodeEntry
    extends AbstractChildNodeEntry {
        private final String name;
        private final NodeState state;

        public OrderedChildNodeEntry(@Nonnull String name, @Nonnull NodeState state) {
            this.name = name;
            this.state = state;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        @Nonnull
        public NodeState getNodeState() {
            return this.state;
        }
    }
}

