/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.name.NamespaceConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.Text;

public class Namespaces
implements NamespaceConstants {
    private static final Map<String, String> ENCODED_URIS = Maps.newConcurrentMap();

    private Namespaces() {
    }

    public static void setupNamespaces(NodeBuilder system) {
        if (!system.hasChildNode("rep:namespaces")) {
            NodeBuilder namespaces = Namespaces.createStandardMappings(system);
            Namespaces.buildIndexNode(namespaces);
        }
    }

    public static NodeBuilder createStandardMappings(NodeBuilder system) {
        Preconditions.checkState((!system.hasChildNode("rep:namespaces") ? 1 : 0) != 0);
        NodeBuilder namespaces = system.setChildNode("rep:namespaces");
        namespaces.setProperty("jcr:primaryType", "rep:Unstructured", Type.NAME);
        namespaces.setProperty("jcr", "http://www.jcp.org/jcr/1.0");
        namespaces.setProperty("nt", "http://www.jcp.org/jcr/nt/1.0");
        namespaces.setProperty("mix", "http://www.jcp.org/jcr/mix/1.0");
        namespaces.setProperty("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces.setProperty("sv", "http://www.jcp.org/jcr/sv/1.0");
        namespaces.setProperty("rep", "internal");
        return namespaces;
    }

    /*
     * WARNING - void declaration
     */
    public static String addCustomMapping(NodeBuilder namespaces, String uri, String prefixHint) {
        for (PropertyState propertyState : namespaces.getProperties()) {
            String prefix;
            if (propertyState.getType() != Type.STRING || !Namespaces.isValidPrefix(prefix = propertyState.getName()) || !uri.equals(propertyState.getValue(Type.STRING))) continue;
            return prefix;
        }
        String prefix = prefixHint;
        boolean bl = true;
        while (namespaces.hasProperty(prefix)) {
            void var4_6;
            prefix = prefixHint + (int)(++var4_6);
        }
        namespaces.setProperty(prefix, uri);
        return prefix;
    }

    public static void buildIndexNode(NodeBuilder namespaces) {
        HashSet prefixes = Sets.newHashSet((Object[])new String[]{""});
        HashSet uris = Sets.newHashSet((Object[])new String[]{""});
        HashMap<String, String> reverse = new HashMap<String, String>();
        for (PropertyState propertyState : namespaces.getProperties()) {
            String prefix = propertyState.getName();
            if (!Type.STRING.equals(propertyState.getType()) || !Namespaces.isValidPrefix(prefix)) continue;
            prefixes.add(prefix);
            String uri = propertyState.getValue(Type.STRING);
            uris.add(uri);
            reverse.put(uri, prefix);
        }
        NodeBuilder data = namespaces.setChildNode("rep:nsdata");
        data.setProperty("jcr:primaryType", "rep:Unstructured", Type.NAME);
        data.setProperty("rep:prefixes", prefixes, Type.STRINGS);
        data.setProperty("rep:uris", uris, Type.STRINGS);
        for (Map.Entry e : reverse.entrySet()) {
            data.setProperty(Namespaces.encodeUri((String)e.getKey()), e.getValue());
        }
    }

    private static Tree getNamespaceTree(Tree root) {
        return root.getChild("jcr:system").getChild("rep:namespaces");
    }

    public static Map<String, String> getNamespaceMap(Tree root) {
        HashMap map = Maps.newHashMap();
        map.put("", "");
        Tree namespaces = Namespaces.getNamespaceTree(root);
        for (PropertyState propertyState : namespaces.getProperties()) {
            String prefix = propertyState.getName();
            if (!Type.STRING.equals(propertyState.getType()) || !Namespaces.isValidPrefix(prefix)) continue;
            map.put(prefix, propertyState.getValue(Type.STRING));
        }
        return map;
    }

    static String[] getNamespacePrefixes(Tree root) {
        Set<String> prefSet = Namespaces.getNamespacePrefixesAsSet(root);
        Object[] prefixes = prefSet.toArray(new String[prefSet.size()]);
        Arrays.sort(prefixes);
        return prefixes;
    }

    static Set<String> getNamespacePrefixesAsSet(Tree root) {
        return Namespaces.safeGet(Namespaces.getNamespaceTree(root).getChild("rep:nsdata"), "rep:prefixes");
    }

    public static String getNamespacePrefix(Tree root, String uri) {
        if (uri.isEmpty()) {
            return uri;
        }
        Tree nsdata = Namespaces.getNamespaceTree(root).getChild("rep:nsdata");
        PropertyState ps = nsdata.getProperty(Namespaces.encodeUri(uri));
        if (ps != null) {
            return ps.getValue(Type.STRING);
        }
        return null;
    }

    static String[] getNamespaceURIs(Tree root) {
        Set<String> uris = Namespaces.safeGet(Namespaces.getNamespaceTree(root).getChild("rep:nsdata"), "rep:uris");
        return uris.toArray(new String[uris.size()]);
    }

    public static String getNamespaceURI(Tree root, String prefix) {
        PropertyState property;
        if (prefix.isEmpty()) {
            return prefix;
        }
        if (Namespaces.isValidPrefix(prefix) && (property = Namespaces.getNamespaceTree(root).getProperty(prefix)) != null && property.getType() == Type.STRING) {
            return property.getValue(Type.STRING);
        }
        return null;
    }

    public static String encodeUri(String uri) {
        String encoded = ENCODED_URIS.get(uri);
        if (encoded == null) {
            encoded = Text.escapeIllegalJcrChars(uri);
            if (ENCODED_URIS.size() > 1000) {
                ENCODED_URIS.clear();
            }
            ENCODED_URIS.put(uri, encoded);
        }
        return encoded;
    }

    static Set<String> safeGet(Tree tree, String name) {
        PropertyState ps = tree.getProperty(name);
        if (ps == null) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(ps.getValue(Type.STRINGS));
    }

    public static boolean isValidPrefix(String prefix) {
        return prefix.indexOf(58) == -1;
    }

    public static boolean isValidLocalName(String local) {
        if (local.isEmpty() || ".".equals(local) || "..".equals(local)) {
            return false;
        }
        for (int i = 0; i < local.length(); ++i) {
            char ch = local.charAt(i);
            if (Character.isSpaceChar(ch)) {
                if (i == 0) {
                    return false;
                }
                if (i == local.length() - 1) {
                    return false;
                }
                if (ch == ' ') continue;
                return false;
            }
            if ("/:[]|*".indexOf(ch) == -1) continue;
            return false;
        }
        return true;
    }
}

