/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;

public final class RecordId
implements Comparable<RecordId> {
    private static final Pattern PATTERN = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(:(0|[1-9][0-9]*)|\\.([0-9a-f]{4}))");
    public static RecordId[] EMPTY_ARRAY = new RecordId[0];
    private final SegmentId segmentId;
    private final int offset;

    public static RecordId fromString(SegmentTracker factory, String id) {
        Matcher matcher = PATTERN.matcher(id);
        if (matcher.matches()) {
            UUID uuid = UUID.fromString(matcher.group(1));
            SegmentId segmentId = factory.getSegmentId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            int offset = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : Integer.parseInt(matcher.group(4), 16) << 2;
            return new RecordId(segmentId, offset);
        }
        throw new IllegalArgumentException("Bad record identifier: " + id);
    }

    public RecordId(SegmentId segmentId, int offset) {
        Preconditions.checkArgument((offset < 262144 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset % 4 == 0 ? 1 : 0) != 0);
        this.segmentId = (SegmentId)Preconditions.checkNotNull((Object)segmentId);
        this.offset = offset;
    }

    public SegmentId getSegmentId() {
        return this.segmentId;
    }

    public int getOffset() {
        return this.offset;
    }

    public Segment getSegment() {
        return this.segmentId.getSegment();
    }

    @Override
    public int compareTo(RecordId that) {
        Preconditions.checkNotNull((Object)that);
        int diff = this.segmentId.compareTo(that.segmentId);
        if (diff == 0) {
            diff = this.offset - that.offset;
        }
        return diff;
    }

    public String toString() {
        return String.format("%s.%04x", this.segmentId, this.offset >> 2);
    }

    public String toString10() {
        return String.format("%s:%d", this.segmentId, this.offset);
    }

    public int hashCode() {
        return this.segmentId.hashCode() ^ this.offset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RecordId) {
            RecordId that = (RecordId)object;
            return this.offset == that.offset && this.segmentId.equals(that.segmentId);
        }
        return false;
    }
}

