/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.plugins.identifier.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.segment.SegmentCheckpointMBean;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStoreProvider;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategyMBean;
import org.apache.jackrabbit.oak.plugins.segment.compaction.DefaultCompactionStrategyMBean;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStoreGCMonitor;
import org.apache.jackrabbit.oak.plugins.segment.file.GCMonitorMBean;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitorTracker;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.ProxyNodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Jackrabbit Oak Segment NodeStore Service", description="NodeStore implementation based on Document model. For configuration option refer to http://jackrabbit.apache.org/oak/docs/osgi_config.html#SegmentNodeStore. Note that for system stability purpose it is advisable to not change these settings at runtime. Instead the config change should be done via file system based config file and this view should ONLY be used to determine which options are supported")
public class SegmentNodeStoreService
extends ProxyNodeStore
implements Observable,
SegmentStoreProvider {
    public static final String NAME = "name";
    @Property(label="Directory", description="Directory location used to store the segment tar files. If not specified then looks for framework property 'repository.home' otherwise use a subdirectory with name 'tarmk'")
    public static final String DIRECTORY = "repository.home";
    @Property(label="Mode", description="TarMK mode (64 for memory mapping, 32 for normal file access)")
    public static final String MODE = "tarmk.mode";
    @Property(intValue={256}, label="Maximum Tar File Size (MB)", description="TarMK maximum file size (MB)")
    public static final String SIZE = "tarmk.size";
    @Property(intValue={256}, label="Cache size (MB)", description="Cache size for storing most recently used Segments")
    public static final String CACHE = "cache";
    @Property(boolValue={false}, label="Clone Binaries", description="Clone the binary segments while performing compaction")
    public static final String COMPACTION_CLONE_BINARIES = "compaction.cloneBinaries";
    @Property(options={@PropertyOption(name="CLEAN_ALL", value="CLEAN_ALL"), @PropertyOption(name="CLEAN_NONE", value="CLEAN_NONE"), @PropertyOption(name="CLEAN_OLD", value="CLEAN_OLD")}, value={"CLEAN_OLD"}, label="Cleanup Strategy", description="Cleanup strategy used for live in memory segment references while performing cleanup. 1. CLEAN_NONE: All in memory references are considered valid, 2. CLEAN_OLD: Only in memory references older than a certain age are considered valid (compaction.cleanup.timestamp), 3. CLEAN_ALL: None of the in memory references are considered valid")
    public static final String COMPACTION_CLEANUP = "compaction.cleanup";
    @Property(longValue={36000000L}, label="Reference expiry time (ms)", description="Time interval in ms beyond which in memory segment references would be ignored while performing cleanup")
    public static final String COMPACTION_CLEANUP_TIMESTAMP = "compaction.cleanup.timestamp";
    @Property(byteValue={5}, label="Memory Multiplier", description="TarMK compaction available memory multiplier needed to run compaction")
    public static final String COMPACTION_MEMORY_THRESHOLD = "compaction.memoryThreshold";
    @Property(boolValue={false}, label="Pause Compaction", description="When enabled compaction would not be performed")
    public static final String PAUSE_COMPACTION = "pauseCompaction";
    @Property(boolValue={false}, label="Standby Mode", description="Flag indicating that this component will not register as a NodeStore but just as a NodeStoreProvider")
    public static final String STANDBY = "standby";
    @Property(boolValue={false}, label="Custom BlobStore", description="Boolean value indicating that a custom BlobStore is to be used. By default large binary content would be stored within segment tar files")
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private SegmentStore store;
    private SegmentNodeStore delegate;
    private ObserverTracker observerTracker;
    private GCMonitorTracker gcMonitor;
    private ComponentContext context;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile BlobStore blobStore;
    private ServiceRegistration storeRegistration;
    private ServiceRegistration providerRegistration;
    private Registration checkpointRegistration;
    private Registration revisionGCRegistration;
    private Registration blobGCRegistration;
    private Registration compactionStrategyRegistration;
    private Registration fsgcMonitorMBean;
    private WhiteboardExecutor executor;
    private boolean customBlobStore;

    @Override
    protected synchronized SegmentNodeStore getNodeStore() {
        Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"service must be activated when used");
        return this.delegate;
    }

    @Activate
    private void activate(ComponentContext context) throws IOException {
        this.context = context;
        this.customBlobStore = Boolean.parseBoolean(SegmentNodeStoreService.lookup(context, CUSTOM_BLOB_STORE));
        if (this.blobStore == null && this.customBlobStore) {
            this.log.info("BlobStore use enabled. SegmentNodeStore would be initialized when BlobStore would be available");
        } else {
            this.registerNodeStore();
        }
    }

    public void registerNodeStore() throws IOException {
        if (this.registerSegmentStore()) {
            boolean standby = PropertiesUtil.toBoolean(SegmentNodeStoreService.lookup(this.context, STANDBY), false);
            this.providerRegistration = this.context.getBundleContext().registerService(SegmentStoreProvider.class.getName(), (Object)this, null);
            if (!standby) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("service.pid", SegmentNodeStore.class.getName());
                ((Dictionary)props).put("oak.nodestore.description", new String[]{"nodeStoreType=segment"});
                this.storeRegistration = this.context.getBundleContext().registerService(NodeStore.class.getName(), (Object)this, props);
            }
        }
    }

    public synchronized boolean registerSegmentStore() throws IOException {
        String cache;
        String size;
        if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
            return false;
        }
        Dictionary properties = this.context.getProperties();
        this.name = String.valueOf(properties.get(NAME));
        String directory = SegmentNodeStoreService.lookup(this.context, DIRECTORY);
        directory = directory == null ? "tarmk" : FilenameUtils.concat((String)directory, (String)"segmentstore");
        String mode = SegmentNodeStoreService.lookup(this.context, MODE);
        if (mode == null) {
            mode = System.getProperty(MODE, System.getProperty("sun.arch.data.model", "32"));
        }
        if ((size = SegmentNodeStoreService.lookup(this.context, SIZE)) == null) {
            size = System.getProperty(SIZE, "256");
        }
        if ((cache = SegmentNodeStoreService.lookup(this.context, CACHE)) == null) {
            cache = System.getProperty(CACHE);
        }
        boolean pauseCompaction = PropertiesUtil.toBoolean(SegmentNodeStoreService.lookup(this.context, PAUSE_COMPACTION), false);
        boolean cloneBinaries = PropertiesUtil.toBoolean(SegmentNodeStoreService.lookup(this.context, COMPACTION_CLONE_BINARIES), false);
        long cleanupTs = PropertiesUtil.toLong(SegmentNodeStoreService.lookup(this.context, COMPACTION_CLEANUP_TIMESTAMP), 36000000L);
        String cleanup = SegmentNodeStoreService.lookup(this.context, COMPACTION_CLEANUP);
        if (cleanup == null) {
            cleanup = CompactionStrategy.CLEANUP_DEFAULT.toString();
        }
        String memoryThresholdS = SegmentNodeStoreService.lookup(this.context, COMPACTION_MEMORY_THRESHOLD);
        byte memoryThreshold = 5;
        if (memoryThresholdS != null) {
            memoryThreshold = Byte.valueOf(memoryThresholdS);
        }
        CompactionStrategy compactionStrategy = new CompactionStrategy(pauseCompaction, cloneBinaries, CompactionStrategy.CleanupType.valueOf(cleanup), cleanupTs, memoryThreshold){

            @Override
            public boolean compacted(Callable<Boolean> setHead) throws Exception {
                return SegmentNodeStoreService.this.delegate.locked(setHead);
            }
        };
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        this.gcMonitor = new GCMonitorTracker();
        this.gcMonitor.start(whiteboard);
        FileStore.Builder storeBuilder = FileStore.newFileStore(new File(directory)).withCacheSize(Integer.parseInt(cache)).withMaxFileSize(Integer.parseInt(size)).withMemoryMapping("64".equals(mode)).withGCMonitor(this.gcMonitor);
        if (this.customBlobStore) {
            this.log.info("Initializing SegmentNodeStore with BlobStore [{}]", (Object)this.blobStore);
            this.store = storeBuilder.withBlobStore(this.blobStore).create().setCompactionStrategy(compactionStrategy);
        } else {
            this.store = storeBuilder.create().setCompactionStrategy(compactionStrategy);
        }
        FileStoreGCMonitor fsgcMonitor = new FileStoreGCMonitor(Clock.SIMPLE);
        this.fsgcMonitorMBean = new CompositeRegistration(whiteboard.register(GCMonitor.class, fsgcMonitor, Collections.emptyMap()), WhiteboardUtils.registerMBean(whiteboard, GCMonitorMBean.class, fsgcMonitor, "GC Monitor", "File Store garbage collection monitor"), WhiteboardUtils.scheduleWithFixedDelay(whiteboard, fsgcMonitor, 1L));
        this.delegate = new SegmentNodeStore(this.store);
        this.observerTracker = new ObserverTracker(this.delegate);
        this.observerTracker.start(this.context.getBundleContext());
        this.executor = new WhiteboardExecutor();
        this.executor.start(whiteboard);
        this.checkpointRegistration = WhiteboardUtils.registerMBean(whiteboard, CheckpointMBean.class, new SegmentCheckpointMBean(this.delegate), "CheckpointManger", "Segment node store checkpoint management");
        RevisionGC revisionGC = new RevisionGC(new Runnable(){

            @Override
            public void run() {
                SegmentNodeStoreService.this.store.gc();
            }
        }, this.executor);
        this.revisionGCRegistration = WhiteboardUtils.registerMBean(whiteboard, RevisionGCMBean.class, revisionGC, "RevisionGarbageCollection", "Segment node store revision garbage collection");
        if (SharedDataStoreUtils.isShared(this.blobStore)) {
            try {
                String repoId = ClusterRepositoryInfo.createId(this.delegate);
                ((SharedDataStore)((Object)this.blobStore)).addMetadataRecord(new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getNameFromId(repoId));
            }
            catch (Exception e) {
                throw new IOException("Could not register a unique repositoryId", e);
            }
        }
        if (this.store.getBlobStore() instanceof GarbageCollectableBlobStore) {
            BlobGarbageCollector gc = new BlobGarbageCollector(){

                @Override
                public void collectGarbage(boolean sweep) throws Exception {
                    MarkSweepGarbageCollector gc = new MarkSweepGarbageCollector(new SegmentBlobReferenceRetriever(SegmentNodeStoreService.this.store.getTracker()), (GarbageCollectableBlobStore)SegmentNodeStoreService.this.store.getBlobStore(), SegmentNodeStoreService.this.executor, ClusterRepositoryInfo.getId(SegmentNodeStoreService.this.delegate));
                    gc.collectGarbage(sweep);
                }
            };
            this.blobGCRegistration = WhiteboardUtils.registerMBean(whiteboard, BlobGCMBean.class, new BlobGC(gc, this.executor), "BlobGarbageCollection", "Segment node store blob garbage collection");
        }
        this.compactionStrategyRegistration = WhiteboardUtils.registerMBean(whiteboard, CompactionStrategyMBean.class, new DefaultCompactionStrategyMBean(compactionStrategy), "CompactionStrategy", "Segment node store compaction strategy settings");
        this.log.info("SegmentNodeStore initialized");
        return true;
    }

    private static String lookup(ComponentContext context, String property) {
        if (context.getProperties().get(property) != null) {
            return context.getProperties().get(property).toString();
        }
        if (context.getBundleContext().getProperty(property) != null) {
            return context.getBundleContext().getProperty(property);
        }
        return null;
    }

    @Deactivate
    public synchronized void deactivate() {
        this.unregisterNodeStore();
        if (this.observerTracker != null) {
            this.observerTracker.stop();
        }
        if (this.gcMonitor != null) {
            this.gcMonitor.stop();
        }
        this.delegate = null;
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        this.blobStore = blobStore;
        this.registerNodeStore();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    private void unregisterNodeStore() {
        if (this.providerRegistration != null) {
            this.providerRegistration.unregister();
            this.providerRegistration = null;
        }
        if (this.storeRegistration != null) {
            this.storeRegistration.unregister();
            this.storeRegistration = null;
        }
        if (this.checkpointRegistration != null) {
            this.checkpointRegistration.unregister();
            this.checkpointRegistration = null;
        }
        if (this.revisionGCRegistration != null) {
            this.revisionGCRegistration.unregister();
            this.revisionGCRegistration = null;
        }
        if (this.blobGCRegistration != null) {
            this.blobGCRegistration.unregister();
            this.blobGCRegistration = null;
        }
        if (this.compactionStrategyRegistration != null) {
            this.compactionStrategyRegistration.unregister();
            this.compactionStrategyRegistration = null;
        }
        if (this.fsgcMonitorMBean != null) {
            this.fsgcMonitorMBean.unregister();
            this.fsgcMonitorMBean = null;
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    @Override
    public SegmentStore getSegmentStore() {
        return this.store;
    }

    @Override
    public Closeable addObserver(Observer observer) {
        return this.getNodeStore().addObserver(observer);
    }

    public String toString() {
        return this.name + ": " + this.delegate;
    }
}

