/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.compaction;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.segment.CompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;

public abstract class CompactionStrategy {
    public static final boolean PAUSE_DEFAULT = false;
    public static final boolean CLONE_BINARIES_DEFAULT = false;
    public static final CleanupType CLEANUP_DEFAULT = CleanupType.CLEAN_OLD;
    public static final long TIMESTAMP_DEFAULT = 36000000L;
    public static final byte MEMORY_THRESHOLD_DEFAULT = 5;
    public static CompactionStrategy NO_COMPACTION = new CompactionStrategy(true, false, CleanupType.CLEAN_NONE, 0L, 5){

        @Override
        public boolean compacted(@Nonnull Callable<Boolean> setHead) throws Exception {
            return false;
        }
    };
    private boolean paused;
    private boolean cloneBinaries;
    @Nonnull
    private CleanupType cleanupType;
    private long olderThan;
    private byte memoryThreshold = (byte)5;
    private CompactionMap compactionMap;
    private long compactionStart = System.currentTimeMillis();

    protected CompactionStrategy(boolean paused, boolean cloneBinaries, @Nonnull CleanupType cleanupType, long olderThan, byte memoryThreshold) {
        Preconditions.checkArgument((olderThan >= 0L ? 1 : 0) != 0);
        this.paused = paused;
        this.cloneBinaries = cloneBinaries;
        this.cleanupType = (CleanupType)((Object)Preconditions.checkNotNull((Object)((Object)cleanupType)));
        this.olderThan = olderThan;
        this.memoryThreshold = memoryThreshold;
    }

    public boolean canRemove(SegmentId id) {
        switch (this.cleanupType) {
            case CLEAN_ALL: {
                return true;
            }
            case CLEAN_NONE: {
                return false;
            }
            case CLEAN_OLD: {
                return this.compactionStart - id.getCreationTime() > this.olderThan;
            }
        }
        return false;
    }

    public boolean cloneBinaries() {
        return this.cloneBinaries;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setCloneBinaries(boolean cloneBinaries) {
        this.cloneBinaries = cloneBinaries;
    }

    public void setCleanupType(@Nonnull CleanupType cleanupType) {
        this.cleanupType = (CleanupType)((Object)Preconditions.checkNotNull((Object)((Object)cleanupType)));
    }

    public void setOlderThan(long olderThan) {
        Preconditions.checkArgument((olderThan >= 0L ? 1 : 0) != 0);
        this.olderThan = olderThan;
    }

    public void setCompactionMap(@Nonnull CompactionMap compactionMap) {
        this.compactionMap = (CompactionMap)Preconditions.checkNotNull((Object)compactionMap);
    }

    String getCleanupType() {
        return this.cleanupType.toString();
    }

    long getOlderThan() {
        return this.olderThan;
    }

    @CheckForNull
    public CompactionMap getCompactionMap() {
        return this.compactionMap;
    }

    public String toString() {
        return "DefaultCompactionStrategy [pauseCompaction=" + this.paused + ", cloneBinaries=" + this.cloneBinaries + ", cleanup=" + (Object)((Object)this.cleanupType) + ", olderThan=" + this.olderThan + ']';
    }

    public void setCompactionStart(long ms) {
        this.compactionStart = ms;
    }

    public byte getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(byte memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public abstract boolean compacted(@Nonnull Callable<Boolean> var1) throws Exception;

    public static enum CleanupType {
        CLEAN_ALL,
        CLEAN_NONE,
        CLEAN_OLD;

    }
}

