/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class NativeFunctionImpl
extends ConstraintImpl {
    public static final String NATIVE_PREFIX = "native*";
    private final String selectorName;
    private final String language;
    private final StaticOperandImpl nativeSearchExpression;
    private SelectorImpl selector;

    NativeFunctionImpl(String selectorName, String language, StaticOperandImpl expression) {
        this.selectorName = selectorName;
        this.language = language;
        this.nativeSearchExpression = expression;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("native(");
        builder.append(this.quote(this.selectorName));
        builder.append(", ");
        builder.append(this.quote(this.language));
        builder.append(", ");
        builder.append(this.getNativeSearchExpression());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public boolean evaluate() {
        if (!(this.selector.getIndex() instanceof QueryIndex.NativeQueryIndex)) {
            throw new IllegalArgumentException("No full-text index was found that can process the condition " + this.toString());
        }
        return true;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.selector)) {
            PropertyValue v = this.nativeSearchExpression.currentValue();
            f.restrictProperty(NATIVE_PREFIX + this.language, Operator.EQUAL, v);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            this.selector.restrictSelector(this);
        }
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.emptySet();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    public StaticOperandImpl getNativeSearchExpression() {
        return this.nativeSearchExpression;
    }
}

