/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.OrImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;

public class NotImpl
extends ConstraintImpl {
    private ConstraintImpl constraint;

    public NotImpl(ConstraintImpl constraint) {
        this.constraint = constraint;
    }

    public ConstraintImpl getConstraint() {
        return this.constraint;
    }

    @Override
    public ConstraintImpl simplify() {
        ConstraintImpl simple = this.constraint.simplify();
        if (simple instanceof AndImpl) {
            AndImpl and = (AndImpl)simple;
            ArrayList constraints = Lists.newArrayList();
            for (ConstraintImpl constraint : and.getConstraints()) {
                constraints.add(new NotImpl(constraint));
            }
            return new OrImpl(constraints).simplify();
        }
        if (simple instanceof OrImpl) {
            OrImpl or = (OrImpl)simple;
            ArrayList constraints = Lists.newArrayList();
            for (ConstraintImpl constraint : or.getConstraints()) {
                constraints.add(new NotImpl(constraint));
            }
            return new AndImpl(constraints).simplify();
        }
        if (simple instanceof NotImpl) {
            return ((NotImpl)simple).constraint;
        }
        if (simple != this.constraint) {
            return new NotImpl(simple);
        }
        return this;
    }

    @Override
    public boolean evaluate() {
        return !this.constraint.evaluate();
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return this.constraint.getSelectors();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "not " + this.protect(this.constraint);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().isOuterJoinRightHandSide()) {
            return;
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
    }
}

