/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.xpath;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.query.xpath.Expression;
import org.apache.jackrabbit.oak.query.xpath.Order;
import org.apache.jackrabbit.oak.query.xpath.Selector;

public class Statement {
    private boolean explain;
    private boolean measure;
    private Selector columnSelector;
    private ArrayList<Expression> columnList = new ArrayList();
    private ArrayList<Selector> selectors;
    private Expression where;
    ArrayList<Order> orderList = new ArrayList();
    String xpathQuery;

    public Statement optimize() {
        if (this.explain || this.measure) {
            return this;
        }
        if (this.where == null) {
            return this;
        }
        this.where = this.where.optimize();
        ArrayList<Expression> unionList = new ArrayList<Expression>();
        Statement.addToUnionList(this.where, unionList);
        if (unionList.size() == 1) {
            return this;
        }
        Statement union = null;
        for (int i = 0; i < unionList.size(); ++i) {
            Expression e = unionList.get(i);
            Statement s = new Statement();
            s.columnSelector = this.columnSelector;
            s.selectors = this.selectors;
            s.columnList = this.columnList;
            s.where = e;
            union = union == null ? s : new UnionStatement(union.optimize(), s.optimize());
        }
        union.orderList = this.orderList;
        union.xpathQuery = this.xpathQuery;
        return union;
    }

    private static void addToUnionList(Expression condition, ArrayList<Expression> unionList) {
        if (condition instanceof Expression.OrCondition) {
            Expression.OrCondition or = (Expression.OrCondition)condition;
            Statement.addToUnionList(or.left, unionList);
            Statement.addToUnionList(or.right, unionList);
            return;
        }
        if (condition instanceof Expression.AndCondition) {
            Expression.AndCondition and = (Expression.AndCondition)condition;
            and = and.pullOrRight();
            if (and.right instanceof Expression.OrCondition) {
                Expression.OrCondition or = (Expression.OrCondition)and.right;
                Statement.addToUnionList(new Expression.AndCondition(and.left, or.left), unionList);
                Statement.addToUnionList(new Expression.AndCondition(and.left, or.right), unionList);
                return;
            }
        }
        unionList.add(condition);
    }

    public String toString() {
        int i;
        StringBuilder buff = new StringBuilder();
        if (this.explain) {
            buff.append("explain ");
        } else if (this.measure) {
            buff.append("measure ");
        }
        buff.append("select ");
        buff.append(new Expression.Property(this.columnSelector, "jcr:path", false).toString());
        if (this.selectors.size() > 1) {
            buff.append(" as ").append('[').append("jcr:path").append(']');
        }
        buff.append(", ");
        buff.append(new Expression.Property(this.columnSelector, "jcr:score", false).toString());
        if (this.selectors.size() > 1) {
            buff.append(" as ").append('[').append("jcr:score").append(']');
        }
        if (this.columnList.isEmpty()) {
            buff.append(", ");
            buff.append(new Expression.Property(this.columnSelector, "*", false).toString());
        } else {
            for (i = 0; i < this.columnList.size(); ++i) {
                buff.append(", ");
                Expression e = this.columnList.get(i);
                String columnName = e.toString();
                buff.append(columnName);
                if (this.selectors.size() <= 1) continue;
                buff.append(" as [").append(e.getColumnAliasName()).append("]");
            }
        }
        buff.append(" from ");
        for (i = 0; i < this.selectors.size(); ++i) {
            String nodeType;
            Selector s = this.selectors.get(i);
            if (i > 0) {
                buff.append(" inner join ");
            }
            if ((nodeType = s.nodeType) == null) {
                nodeType = "nt:base";
            }
            buff.append('[' + nodeType + ']').append(" as ").append(s.name);
            if (s.joinCondition == null) continue;
            buff.append(" on ").append(s.joinCondition);
        }
        if (this.where != null) {
            buff.append(" where ").append(this.where.toString());
        }
        if (!this.orderList.isEmpty()) {
            buff.append(" order by ");
            for (i = 0; i < this.orderList.size(); ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.orderList.get(i));
            }
        }
        Statement.appendXPathAsComment(buff, this.xpathQuery);
        return buff.toString();
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    public void setMeasure(boolean measure) {
        this.measure = measure;
    }

    public void addSelectColumn(Expression.Property p) {
        this.columnList.add(p);
    }

    public void setSelectors(ArrayList<Selector> selectors) {
        this.selectors = selectors;
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public void addOrderBy(Order order) {
        this.orderList.add(order);
    }

    public void setColumnSelector(Selector columnSelector) {
        this.columnSelector = columnSelector;
    }

    public void setOriginalQuery(String xpathQuery) {
        this.xpathQuery = xpathQuery;
    }

    private static void appendXPathAsComment(StringBuilder buff, String xpath) {
        if (xpath == null) {
            return;
        }
        buff.append(" /* xpath: ");
        String xpathEscaped = xpath.replaceAll("\\*\\/", "* /");
        buff.append(xpathEscaped);
        buff.append(" */");
    }

    static class UnionStatement
    extends Statement {
        private final Statement s1;
        private final Statement s2;

        UnionStatement(Statement s1, Statement s2) {
            this.s1 = s1;
            this.s2 = s2;
        }

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append(this.s1).append(" union ").append(this.s2);
            if (this.orderList != null && !this.orderList.isEmpty()) {
                buff.append(" order by ");
                for (int i = 0; i < this.orderList.size(); ++i) {
                    if (i > 0) {
                        buff.append(", ");
                    }
                    buff.append(this.orderList.get(i));
                }
            }
            Statement.appendXPathAsComment(buff, this.xpathQuery);
            return buff.toString();
        }
    }
}

