/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.authentication.token.TokenAuthentication;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.TokenProviderCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(TokenLoginModule.class);
    private TokenProvider tokenProvider;
    private TokenCredentials tokenCredentials;
    private TokenInfo tokenInfo;
    private String userId;
    private Set<? extends Principal> principals;

    @Override
    public boolean login() throws LoginException {
        TokenCredentials tc;
        TokenAuthentication authentication;
        this.tokenProvider = this.getTokenProvider();
        if (this.tokenProvider == null) {
            return false;
        }
        Credentials credentials = this.getCredentials();
        if (credentials instanceof TokenCredentials && (authentication = new TokenAuthentication(this.tokenProvider)).authenticate(tc = (TokenCredentials)credentials)) {
            this.tokenCredentials = tc;
            this.tokenInfo = authentication.getTokenInfo();
            this.userId = this.tokenInfo.getUserId();
            this.principals = this.getPrincipals(this.userId);
            log.debug("Login: adding login name to shared state.");
            this.sharedState.put("javax.security.auth.login.name", this.userId);
            return true;
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        Credentials shared;
        if (this.tokenCredentials != null) {
            this.updateSubject(this.tokenCredentials, this.getAuthInfo(this.tokenInfo), this.principals);
            return true;
        }
        if (this.tokenProvider != null && this.sharedState.containsKey("org.apache.jackrabbit.credentials") && (shared = this.getSharedCredentials()) != null && this.tokenProvider.doCreateToken(shared)) {
            TokenInfo ti;
            Root r = this.getRoot();
            if (r != null) {
                r.refresh();
            }
            if ((ti = this.tokenProvider.createToken(shared)) != null) {
                TokenCredentials tc = new TokenCredentials(ti.getToken());
                Map<String, String> attributes = ti.getPrivateAttributes();
                for (String name : attributes.keySet()) {
                    tc.setAttribute(name, attributes.get(name));
                }
                attributes = ti.getPublicAttributes();
                for (String name : attributes.keySet()) {
                    tc.setAttribute(name, attributes.get(name));
                }
                this.sharedState.put("javax.security.auth.login.attributes", attributes);
                this.updateSubject(tc, null, null);
            } else {
                log.debug("TokenProvider failed to create a login token for user " + this.userId);
                throw new LoginException("Failed to create login token for user " + this.userId);
            }
        }
        this.clearState();
        return false;
    }

    @Override
    @Nonnull
    protected Set<Class> getSupportedCredentials() {
        return Collections.singleton(TokenCredentials.class);
    }

    @Override
    protected void clearState() {
        super.clearState();
        this.tokenCredentials = null;
        this.tokenInfo = null;
        this.userId = null;
        this.principals = null;
    }

    @CheckForNull
    private TokenProvider getTokenProvider() {
        TokenProvider provider = null;
        SecurityProvider securityProvider = this.getSecurityProvider();
        Root root = this.getRoot();
        if (root != null && securityProvider != null) {
            TokenConfiguration tokenConfig = securityProvider.getConfiguration(TokenConfiguration.class);
            provider = tokenConfig.getTokenProvider(root);
        }
        if (provider == null && this.callbackHandler != null) {
            try {
                TokenProviderCallback tcCallback = new TokenProviderCallback();
                this.callbackHandler.handle(new Callback[]{tcCallback});
                provider = tcCallback.getTokenProvider();
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
            catch (UnsupportedCallbackException e) {
                log.warn(e.getMessage());
            }
        }
        return provider;
    }

    @CheckForNull
    private AuthInfo getAuthInfo(@Nullable TokenInfo tokenInfo) {
        if (tokenInfo != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            Map<String, String> publicAttributes = tokenInfo.getPublicAttributes();
            for (String attrName : publicAttributes.keySet()) {
                attributes.put(attrName, publicAttributes.get(attrName));
            }
            return new AuthInfoImpl(tokenInfo.getUserId(), attributes, this.principals);
        }
        return null;
    }

    private void updateSubject(@Nonnull TokenCredentials tc, @Nullable AuthInfo authInfo, @Nullable Set<? extends Principal> principals) {
        if (!this.subject.isReadOnly()) {
            this.subject.getPublicCredentials().add(tc);
            if (principals != null) {
                this.subject.getPrincipals().addAll(principals);
            }
            if (authInfo != null) {
                TokenLoginModule.setAuthInfo(authInfo, this.subject);
            }
        }
    }
}

