/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.Text;

final class AuthorizationContext
implements Context,
AccessControlConstants,
PermissionConstants {
    private static final Context INSTANCE = new AuthorizationContext();

    private AuthorizationContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean definesProperty(@Nonnull Tree parent, @Nonnull PropertyState property) {
        return this.definesTree(parent);
    }

    @Override
    public boolean definesContextRoot(@Nonnull Tree tree) {
        String name = tree.getName();
        if (POLICY_NODE_NAMES.contains(name)) {
            return "rep:ACL".equals(TreeUtil.getPrimaryTypeName(tree));
        }
        return "rep:permissionStore".equals(name);
    }

    @Override
    public boolean definesTree(@Nonnull Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName(tree);
        return AC_NODETYPE_NAMES.contains(ntName) || PERMISSION_NODETYPE_NAMES.contains(ntName);
    }

    @Override
    public boolean definesLocation(@Nonnull TreeLocation location) {
        Tree tree = location.getTree();
        if (tree != null && location.exists()) {
            PropertyState p = location.getProperty();
            return p == null ? this.definesTree(tree) : this.definesProperty(tree, p);
        }
        String path = location.getPath();
        String name = Text.getName(location.getPath());
        return POLICY_NODE_NAMES.contains(name) || ACE_PROPERTY_NAMES.contains(name) || path.startsWith("/jcr:system/rep:permissionStore");
    }
}

