/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;

class CompositeAccessControlManager
extends AbstractAccessControlManager {
    private final List<AccessControlManager> acMgrs;

    public CompositeAccessControlManager(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper, @Nonnull SecurityProvider securityProvider, @Nonnull List<AccessControlManager> acMgrs) {
        super(root, namePathMapper, securityProvider);
        this.acMgrs = acMgrs;
    }

    @Override
    @Nonnull
    public Privilege[] getSupportedPrivileges(String absPath) throws RepositoryException {
        ImmutableList.Builder privs = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            privs.add((Object[])acMgr.getSupportedPrivileges(absPath));
        }
        ImmutableList l = privs.build();
        return l.toArray(new Privilege[l.size()]);
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            policies.add((Object[])acMgr.getPolicies(absPath));
        }
        ImmutableList l = policies.build();
        return l.toArray(new AccessControlPolicy[l.size()]);
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        ImmutableList.Builder privs = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            privs.add((Object[])acMgr.getEffectivePolicies(absPath));
        }
        ImmutableList l = privs.build();
        return l.toArray(new AccessControlPolicy[l.size()]);
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        ArrayList l = Lists.newArrayList();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner)) continue;
            l.add(acMgr.getApplicablePolicies(absPath));
        }
        return new AccessControlPolicyIteratorAdapter(Iterators.concat((Iterator[])((Iterator[])l.toArray(new AccessControlPolicyIterator[l.size()]))));
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)acMgr).defines(absPath, policy)) continue;
            acMgr.setPolicy(absPath, policy);
            return;
        }
        throw new AccessControlException("Cannot set access control policy " + policy + "; no PolicyOwner found.");
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)acMgr).defines(absPath, policy)) continue;
            acMgr.removePolicy(absPath, policy);
            return;
        }
        throw new AccessControlException("Cannot remove access control policy " + policy + "; no PolicyOwner found.");
    }

    @Override
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager) || !(acMgr instanceof PolicyOwner)) continue;
            policies.add((Object[])((JackrabbitAccessControlManager)acMgr).getApplicablePolicies(principal));
        }
        ImmutableList l = policies.build();
        return l.toArray(new JackrabbitAccessControlPolicy[l.size()]);
    }

    @Override
    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws RepositoryException {
        ImmutableList.Builder privs = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            privs.add((Object[])((JackrabbitAccessControlManager)acMgr).getPolicies(principal));
        }
        ImmutableList l = privs.build();
        return l.toArray(new JackrabbitAccessControlPolicy[l.size()]);
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws RepositoryException {
        ImmutableList.Builder privs = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            privs.add((Object[])((JackrabbitAccessControlManager)acMgr).getEffectivePolicies(principals));
        }
        ImmutableList l = privs.build();
        return l.toArray(new AccessControlPolicy[l.size()]);
    }
}

