/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;

class CompositePermissionProvider
implements PermissionProvider {
    private final Root root;
    private final List<AggregatedPermissionProvider> pps;
    private final CompositeRepositoryPermission repositoryPermission;
    private Root immutableRoot;
    private PrivilegeBitsProvider pbp;

    CompositePermissionProvider(@Nonnull Root root, @Nonnull List<AggregatedPermissionProvider> pps) {
        this.root = root;
        this.pps = pps;
        this.repositoryPermission = new CompositeRepositoryPermission();
        this.immutableRoot = RootFactory.createReadOnlyRoot(root);
        this.pbp = new PrivilegeBitsProvider(this.immutableRoot);
    }

    @Override
    public void refresh() {
        this.immutableRoot = RootFactory.createReadOnlyRoot(this.root);
        this.pbp = new PrivilegeBitsProvider(this.immutableRoot);
        for (PermissionProvider permissionProvider : this.pps) {
            permissionProvider.refresh();
        }
    }

    @Override
    @Nonnull
    public Set<String> getPrivileges(final @Nullable Tree tree) {
        PrivilegeBits result = null;
        Iterable providers = Iterables.filter(this.pps, (Predicate)new Predicate<AggregatedPermissionProvider>(){

            public boolean apply(@Nullable AggregatedPermissionProvider pp) {
                return pp != null && (tree != null || pp.handlesRepositoryPermissions());
            }
        });
        for (AggregatedPermissionProvider pp : providers) {
            PrivilegeBits privs = this.pbp.getBits(pp.getPrivileges(tree));
            if (result == null) {
                result = PrivilegeBits.getInstance();
                result.add(privs);
                continue;
            }
            result.retain(privs);
        }
        return this.pbp.getPrivilegeNames(result);
    }

    @Override
    public boolean hasPrivileges(final @Nullable Tree tree, String ... privilegeNames) {
        for (final String privName : this.pbp.getAggregatedPrivilegeNames(privilegeNames)) {
            Iterable providers = Iterables.filter(this.pps, (Predicate)new Predicate<AggregatedPermissionProvider>(){

                public boolean apply(@Nullable AggregatedPermissionProvider pp) {
                    return pp != null && (tree == null ? pp.handlesRepositoryPermissions() : pp.handles(tree, CompositePermissionProvider.this.pbp.getBits(privName)));
                }
            });
            for (AggregatedPermissionProvider pp : providers) {
                if (pp.hasPrivileges(tree, privName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return this.repositoryPermission;
    }

    @Override
    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        ImmutableTree immTree;
        ImmutableTree immutableTree = immTree = tree instanceof ImmutableTree ? (ImmutableTree)tree : (ImmutableTree)this.immutableRoot.getTree(tree.getPath());
        if (tree.isRoot()) {
            return new CompositeTreePermission(immTree, new CompositeTreePermission());
        }
        if (!(parentPermission instanceof CompositeTreePermission)) {
            throw new IllegalArgumentException("Illegal parent permission instance. Expected CompositeTreePermission.");
        }
        return new CompositeTreePermission(immTree, (CompositeTreePermission)parentPermission);
    }

    @Override
    public boolean isGranted(final @Nonnull Tree parent, @Nullable PropertyState property, final long permissions) {
        if (Permissions.isAggregate(permissions)) {
            for (final long permission : Permissions.aggregates(permissions)) {
                Iterable providers;
                if (CompositePermissionProvider.grantsPermission(parent, property, permission, providers = Iterables.filter(this.pps, (Predicate)new Predicate<AggregatedPermissionProvider>(){

                    public boolean apply(@Nullable AggregatedPermissionProvider pp) {
                        return pp != null && pp.handles(parent, permission);
                    }
                }))) continue;
                return false;
            }
            return true;
        }
        Iterable providers = Iterables.filter(this.pps, (Predicate)new Predicate<AggregatedPermissionProvider>(){

            public boolean apply(@Nullable AggregatedPermissionProvider pp) {
                return pp != null && pp.handles(parent, permissions);
            }
        });
        return CompositePermissionProvider.grantsPermission(parent, property, permissions, providers);
    }

    @Override
    public boolean isGranted(final @Nonnull String oakPath, @Nonnull String jcrActions) {
        final String[] actions = Text.explode(jcrActions, 44, false);
        switch (actions.length) {
            case 0: {
                return true;
            }
            case 1: {
                Iterable providers = Iterables.filter(this.pps, (Predicate)new Predicate<AggregatedPermissionProvider>(){

                    public boolean apply(@Nullable AggregatedPermissionProvider pp) {
                        return pp != null && pp.handles(oakPath, actions[0]);
                    }
                });
                return CompositePermissionProvider.grantsAction(oakPath, actions[0], providers);
            }
        }
        for (final String action : actions) {
            Iterable providers = Iterables.filter(this.pps, (Predicate)new Predicate<AggregatedPermissionProvider>(){

                public boolean apply(@Nullable AggregatedPermissionProvider pp) {
                    return pp != null && pp.handles(oakPath, action);
                }
            });
            if (CompositePermissionProvider.grantsAction(oakPath, action, providers)) continue;
            return false;
        }
        return true;
    }

    private static boolean grantsPermission(@Nonnull Tree parent, @Nullable PropertyState property, long permission, @Nonnull Iterable<AggregatedPermissionProvider> providers) {
        Iterator<AggregatedPermissionProvider> it = providers.iterator();
        while (it.hasNext()) {
            AggregatedPermissionProvider pp = it.next();
            boolean isGranted = pp.isGranted(parent, property, permission);
            if (it.hasNext() && isGranted) continue;
            return isGranted;
        }
        return false;
    }

    private static boolean grantsAction(@Nonnull String oakPath, @Nonnull String action, @Nonnull Iterable<AggregatedPermissionProvider> providers) {
        Iterator<AggregatedPermissionProvider> it = providers.iterator();
        while (it.hasNext()) {
            AggregatedPermissionProvider pp = it.next();
            boolean isGranted = pp.isGranted(oakPath, action);
            if (it.hasNext() && isGranted) continue;
            return isGranted;
        }
        return false;
    }

    private static boolean grantsRepoPermission(long permission, @Nonnull Iterable<AggregatedPermissionProvider> providers) {
        Iterator<AggregatedPermissionProvider> it = providers.iterator();
        while (it.hasNext()) {
            AggregatedPermissionProvider pp = it.next();
            boolean isGranted = pp.getRepositoryPermission().isGranted(permission);
            if (it.hasNext() && isGranted) continue;
            return isGranted;
        }
        return false;
    }

    private class CompositeRepositoryPermission
    implements RepositoryPermission {
        private CompositeRepositoryPermission() {
        }

        @Override
        public boolean isGranted(long repositoryPermissions) {
            Iterable providers = Iterables.filter((Iterable)CompositePermissionProvider.this.pps, (Predicate)new Predicate<AggregatedPermissionProvider>(){

                public boolean apply(@Nullable AggregatedPermissionProvider provider) {
                    return provider != null && provider.handlesRepositoryPermissions();
                }
            });
            if (Permissions.isAggregate(repositoryPermissions)) {
                for (long permission : Permissions.aggregates(repositoryPermissions)) {
                    if (CompositePermissionProvider.grantsRepoPermission(permission, providers)) continue;
                    return false;
                }
                return true;
            }
            return CompositePermissionProvider.grantsRepoPermission(repositoryPermissions, providers);
        }
    }

    private final class CompositeTreePermission
    implements TreePermission {
        private final ImmutableTree tree;
        private final CompositeTreePermission parentPermission;
        private final Map<AggregatedPermissionProvider, TreePermission> map;
        private Boolean canRead;

        private CompositeTreePermission() {
            this.tree = null;
            this.parentPermission = null;
            this.map = ImmutableMap.of();
        }

        private CompositeTreePermission(@Nonnull ImmutableTree tree, CompositeTreePermission parentPermission) {
            this.tree = tree;
            this.parentPermission = parentPermission;
            this.map = new LinkedHashMap<AggregatedPermissionProvider, TreePermission>(CompositePermissionProvider.this.pps.size());
            for (AggregatedPermissionProvider provider : CompositePermissionProvider.this.pps) {
                TreePermission tp = provider.getTreePermission(tree, this.getParentPermission(provider));
                this.map.put(provider, tp);
            }
        }

        @Override
        @Nonnull
        public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
            ImmutableTree childTree = new ImmutableTree(this.tree, childName, childState);
            return new CompositeTreePermission(childTree, this);
        }

        @Override
        public boolean canRead() {
            if (this.canRead == null) {
                this.canRead = false;
                Iterator<Map.Entry<AggregatedPermissionProvider, TreePermission>> it = this.map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<AggregatedPermissionProvider, TreePermission> entry = it.next();
                    TreePermission tp = entry.getValue();
                    if (!entry.getKey().handles(tp, 1L)) continue;
                    boolean isGranted = entry.getValue().canRead();
                    if (it.hasNext() && isGranted) continue;
                    this.canRead = isGranted;
                    break;
                }
            }
            return this.canRead;
        }

        @Override
        public boolean canRead(@Nonnull PropertyState property) {
            Iterator<Map.Entry<AggregatedPermissionProvider, TreePermission>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<AggregatedPermissionProvider, TreePermission> entry = it.next();
                TreePermission tp = entry.getValue();
                if (!entry.getKey().handles(tp, 2L)) continue;
                boolean isGranted = entry.getValue().canRead(property);
                if (it.hasNext() && isGranted) continue;
                return isGranted;
            }
            return false;
        }

        @Override
        public boolean canReadAll() {
            return false;
        }

        @Override
        public boolean canReadProperties() {
            return false;
        }

        @Override
        public boolean isGranted(long permissions) {
            if (Permissions.isAggregate(permissions)) {
                for (long permission : Permissions.aggregates(permissions)) {
                    if (this.grantsPermission(permission, null)) continue;
                    return false;
                }
                return true;
            }
            return this.grantsPermission(permissions, null);
        }

        @Override
        public boolean isGranted(long permissions, @Nonnull PropertyState property) {
            if (Permissions.isAggregate(permissions)) {
                for (long permission : Permissions.aggregates(permissions)) {
                    if (this.grantsPermission(permission, property)) continue;
                    return false;
                }
                return true;
            }
            return this.grantsPermission(permissions, property);
        }

        private boolean grantsPermission(long permission, @Nullable PropertyState property) {
            Iterator<Map.Entry<AggregatedPermissionProvider, TreePermission>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                boolean isGranted;
                Map.Entry<AggregatedPermissionProvider, TreePermission> entry = it.next();
                if (!entry.getKey().handles(this, permission)) continue;
                TreePermission tp = entry.getValue();
                boolean bl = isGranted = property == null ? tp.isGranted(permission) : tp.isGranted(permission, property);
                if (it.hasNext() && isGranted) continue;
                return isGranted;
            }
            return false;
        }

        @Nonnull
        private TreePermission getParentPermission(AggregatedPermissionProvider provider) {
            TreePermission parent = null;
            if (this.parentPermission != null) {
                parent = this.parentPermission.map.get(provider);
            }
            return parent == null ? TreePermission.EMPTY : parent;
        }
    }
}

