/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.version.VersionConstants;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.EntryPredicate;
import org.apache.jackrabbit.oak.security.authorization.permission.NoPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryCache;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStoreImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.ReadStatus;
import org.apache.jackrabbit.oak.security.authorization.permission.TreeTypeProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CompiledPermissionImpl
implements CompiledPermissions,
PermissionConstants {
    private static final Logger log = LoggerFactory.getLogger(CompiledPermissionImpl.class);
    private static final Map<Long, PrivilegeBits> READ_BITS = ImmutableMap.of((Object)3L, (Object)PrivilegeBits.BUILT_IN.get("jcr:read"), (Object)1L, (Object)PrivilegeBits.BUILT_IN.get("rep:readNodes"), (Object)2L, (Object)PrivilegeBits.BUILT_IN.get("rep:readProperties"), (Object)128L, (Object)PrivilegeBits.BUILT_IN.get("jcr:readAccessControl"));
    private Root root;
    private final String workspaceName;
    private final ReadPolicy readPolicy;
    private PermissionStoreImpl store;
    private final PermissionEntryProvider userStore;
    private final PermissionEntryProvider groupStore;
    private PrivilegeBitsProvider bitsProvider;
    private final TreeTypeProvider typeProvider;

    private CompiledPermissionImpl(@Nonnull Set<Principal> principals, @Nonnull Root root, @Nonnull String workspaceName, @Nonnull RestrictionProvider restrictionProvider, @Nonnull AuthorizationConfiguration acConfig) {
        this.root = root;
        this.workspaceName = workspaceName;
        this.bitsProvider = new PrivilegeBitsProvider(root);
        Set readPaths = acConfig.getParameters().getConfigValue("readPaths", DEFAULT_READ_PATHS);
        this.readPolicy = readPaths.isEmpty() ? EmptyReadPolicy.INSTANCE : new DefaultReadPolicy(readPaths);
        this.store = new PermissionStoreImpl(root, workspaceName, restrictionProvider);
        HashSet<String> userNames = new HashSet<String>(principals.size());
        HashSet<String> groupNames = new HashSet<String>(principals.size());
        for (Principal principal : principals) {
            if (principal instanceof Group) {
                groupNames.add(principal.getName());
                continue;
            }
            userNames.add(principal.getName());
        }
        ConfigurationParameters options = acConfig.getParameters();
        PermissionEntryCache cache = new PermissionEntryCache();
        this.userStore = new PermissionEntryProviderImpl(this.store, cache, userNames, options);
        this.groupStore = new PermissionEntryProviderImpl(this.store, cache, groupNames, options);
        this.typeProvider = new TreeTypeProvider(acConfig.getContext());
    }

    static CompiledPermissions create(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull AuthorizationConfiguration acConfig) {
        Tree permissionsTree = PermissionUtil.getPermissionsRoot(root, workspaceName);
        if (!permissionsTree.exists() || principals.isEmpty()) {
            return NoPermissions.getInstance();
        }
        return new CompiledPermissionImpl(principals, root, workspaceName, acConfig.getRestrictionProvider(), acConfig);
    }

    @Override
    public void refresh(@Nonnull Root root, @Nonnull String workspaceName) {
        this.root = root;
        this.bitsProvider = new PrivilegeBitsProvider(root);
        this.store.flush(root);
        this.userStore.flush();
        this.groupStore.flush();
    }

    @Override
    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return new RepositoryPermission(){

            @Override
            public boolean isGranted(long repositoryPermissions) {
                return CompiledPermissionImpl.this.hasPermissions(CompiledPermissionImpl.this.getEntryIterator(new EntryPredicate()), repositoryPermissions, null);
            }
        };
    }

    @Override
    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        if (tree.isRoot()) {
            return new TreePermissionImpl(tree, 1, TreePermission.EMPTY);
        }
        int parentType = CompiledPermissionImpl.getParentType(parentPermission);
        int type = this.typeProvider.getType(tree, parentType);
        switch (type) {
            case 16: {
                return TreePermission.ALL;
            }
            case 2: {
                String ntName = TreeUtil.getPrimaryTypeName(tree);
                if (ntName == null) {
                    return TreePermission.EMPTY;
                }
                if (VersionConstants.VERSION_STORE_NT_NAMES.contains(ntName) || "nt:activity".equals(ntName)) {
                    return new TreePermissionImpl(tree, 2, parentPermission);
                }
                Tree versionableTree = this.getVersionableTree(tree);
                if (versionableTree == null) {
                    log.warn("Cannot retrieve versionable node for " + tree.getPath());
                    return TreePermission.EMPTY;
                }
                while (!versionableTree.exists()) {
                    versionableTree = versionableTree.getParent();
                }
                TreePermission pp = this.getParentPermission(versionableTree, 2);
                return new TreePermissionImpl(versionableTree, 2, pp);
            }
            case 4: {
                return TreePermission.EMPTY;
            }
        }
        return new TreePermissionImpl(tree, type, parentPermission);
    }

    @Nonnull
    private TreePermission getParentPermission(@Nonnull Tree tree, int type) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        while (!tree.isRoot()) {
            if (!(tree = tree.getParent()).exists()) continue;
            trees.add(0, tree);
        }
        TreePermission pp = TreePermission.EMPTY;
        for (Tree tr : trees) {
            pp = new TreePermissionImpl(tr, type, pp);
        }
        return pp;
    }

    @Override
    public boolean isGranted(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) {
        int type = this.typeProvider.getType(tree);
        switch (type) {
            case 16: {
                return true;
            }
            case 2: {
                Tree versionableTree = this.getVersionableTree(tree);
                if (versionableTree == null) {
                    return false;
                }
                if (versionableTree.exists()) {
                    return this.internalIsGranted(versionableTree, property, permissions);
                }
                String path = versionableTree.getPath();
                if (property != null) {
                    path = PathUtils.concat(path, property.getName());
                }
                return this.isGranted(path, permissions);
            }
            case 4: {
                return false;
            }
        }
        return this.internalIsGranted(tree, property, permissions);
    }

    @Override
    public boolean isGranted(@Nonnull String path, long permissions) {
        Iterator<PermissionEntry> it = this.getEntryIterator(new EntryPredicate(path, Permissions.respectParentPermissions(permissions)));
        return this.hasPermissions(it, permissions, path);
    }

    @Override
    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        return this.bitsProvider.getPrivilegeNames(this.internalGetPrivileges(tree));
    }

    @Override
    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return this.internalGetPrivileges(tree).includes(this.bitsProvider.getBits(privilegeNames));
    }

    private boolean internalIsGranted(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) {
        Iterator<PermissionEntry> it = this.getEntryIterator(tree, property, permissions);
        return this.hasPermissions(it, permissions, tree.getPath());
    }

    private boolean hasPermissions(@Nonnull Iterator<PermissionEntry> entries, long permissions, @Nullable String path) {
        String parentPath;
        PrivilegeBits parentDenyBits;
        PrivilegeBits parentAllowBits;
        boolean isReadable;
        boolean bl = isReadable = Permissions.diff(3L, permissions) != 3L && this.readPolicy.isReadablePath(path, false);
        if (!entries.hasNext() && !isReadable) {
            return false;
        }
        boolean respectParent = path != null && Permissions.respectParentPermissions(permissions);
        long allows = isReadable ? 3L : 0L;
        long denies = 0L;
        PrivilegeBits allowBits = PrivilegeBits.getInstance();
        if (isReadable) {
            allowBits.add(this.bitsProvider.getBits("jcr:read"));
        }
        PrivilegeBits denyBits = PrivilegeBits.getInstance();
        if (respectParent) {
            parentAllowBits = PrivilegeBits.getInstance();
            parentDenyBits = PrivilegeBits.getInstance();
            parentPath = PermissionUtil.getParentPathOrNull(path);
        } else {
            parentAllowBits = PrivilegeBits.EMPTY;
            parentDenyBits = PrivilegeBits.EMPTY;
            parentPath = null;
        }
        while (entries.hasNext()) {
            boolean matchesParent;
            PermissionEntry entry = entries.next();
            if (respectParent && parentPath != null && (matchesParent = entry.matchesParent(parentPath))) {
                if (entry.isAllow) {
                    parentAllowBits.addDifference(entry.privilegeBits, parentDenyBits);
                } else {
                    parentDenyBits.addDifference(entry.privilegeBits, parentAllowBits);
                }
            }
            if (entry.isAllow) {
                allowBits.addDifference(entry.privilegeBits, denyBits);
                long ap = PrivilegeBits.calculatePermissions(allowBits, parentAllowBits, true);
                if (((allows |= Permissions.diff(ap, denies)) | permissions ^ 0xFFFFFFFFFFFFFFFFL) != -1L) continue;
                return true;
            }
            denyBits.addDifference(entry.privilegeBits, allowBits);
            long dp = PrivilegeBits.calculatePermissions(denyBits, parentDenyBits, false);
            if (!Permissions.includes(denies |= Permissions.diff(dp, allows), permissions)) continue;
            return false;
        }
        return (allows | permissions ^ 0xFFFFFFFFFFFFFFFFL) == -1L;
    }

    @Nonnull
    private PrivilegeBits internalGetPrivileges(@Nullable Tree tree) {
        int type = tree == null ? 1 : this.typeProvider.getType(tree);
        switch (type) {
            case 16: {
                return PrivilegeBits.EMPTY;
            }
            case 2: {
                Tree versionableTree = this.getVersionableTree(tree);
                if (versionableTree == null || !versionableTree.exists()) {
                    return PrivilegeBits.EMPTY;
                }
                return this.getPrivilegeBits(versionableTree);
            }
            case 4: {
                return PrivilegeBits.EMPTY;
            }
        }
        return this.getPrivilegeBits(tree);
    }

    @Nonnull
    private PrivilegeBits getPrivilegeBits(@Nullable Tree tree) {
        EntryPredicate pred = tree == null ? new EntryPredicate() : new EntryPredicate(tree, null, false);
        Iterator<PermissionEntry> entries = this.getEntryIterator(pred);
        PrivilegeBits allowBits = PrivilegeBits.getInstance();
        PrivilegeBits denyBits = PrivilegeBits.getInstance();
        while (entries.hasNext()) {
            PermissionEntry entry = entries.next();
            if (entry.isAllow) {
                allowBits.addDifference(entry.privilegeBits, denyBits);
                continue;
            }
            denyBits.addDifference(entry.privilegeBits, allowBits);
        }
        if (tree != null && this.readPolicy.isReadableTree(tree, false)) {
            allowBits.add(this.bitsProvider.getBits("jcr:read"));
        }
        return allowBits;
    }

    @Nonnull
    private Iterator<PermissionEntry> getEntryIterator(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) {
        return this.getEntryIterator(new EntryPredicate(tree, property, Permissions.respectParentPermissions(permissions)));
    }

    @Nonnull
    private Iterator<PermissionEntry> getEntryIterator(@Nonnull EntryPredicate predicate) {
        Iterator<PermissionEntry> userEntries = this.userStore.getEntryIterator(predicate);
        Iterator<PermissionEntry> groupEntries = this.groupStore.getEntryIterator(predicate);
        return Iterators.concat(userEntries, groupEntries);
    }

    @CheckForNull
    private Tree getVersionableTree(@Nonnull Tree versionStoreTree) {
        String relPath = "";
        String versionablePath = null;
        Tree t = versionStoreTree;
        while (t.exists() && !t.isRoot() && !VersionConstants.VERSION_STORE_ROOT_NAMES.contains(t.getName())) {
            String ntName = TreeUtil.getPrimaryTypeName(t);
            if ("jcr:frozenNode".equals(t.getName()) && t != versionStoreTree) {
                relPath = PathUtils.relativize(t.getPath(), versionStoreTree.getPath());
            } else {
                if ("nt:versionHistory".equals(ntName)) {
                    PropertyState prop = t.getProperty(this.workspaceName);
                    if (prop != null) {
                        versionablePath = PathUtils.concat(prop.getValue(Type.PATH), relPath);
                    }
                    return versionablePath == null ? null : this.root.getTree(versionablePath);
                }
                if ("nt:configuration".equals(ntName)) {
                    String rootId = TreeUtil.getString(t, "jcr:root");
                    if (rootId != null) {
                        versionablePath = new IdentifierManager(this.root).getPath(rootId);
                        return versionablePath == null ? null : this.root.getTree(versionablePath);
                    }
                    log.error("Missing mandatory property jcr:root with configuration node.");
                    return null;
                }
                if ("nt:activity".equals(ntName)) {
                    return versionStoreTree;
                }
            }
            t = t.getParent();
        }
        return versionStoreTree;
    }

    private static int getParentType(@Nonnull TreePermission parentPermission) {
        if (parentPermission instanceof TreePermissionImpl) {
            return ((TreePermissionImpl)parentPermission).type;
        }
        if (parentPermission == TreePermission.EMPTY) {
            return 1;
        }
        throw new IllegalArgumentException("Illegal TreePermission implementation.");
    }

    private static final class DefaultReadPolicy
    implements ReadPolicy {
        private final String[] readPaths;
        private final String[] altReadPaths;
        private final boolean isDefaultPaths;

        private DefaultReadPolicy(Set<String> readPaths) {
            this.readPaths = readPaths.toArray(new String[readPaths.size()]);
            this.altReadPaths = new String[readPaths.size()];
            int i = 0;
            for (String p : this.readPaths) {
                this.altReadPaths[i++] = p + '/';
            }
            this.isDefaultPaths = readPaths.size() == PermissionConstants.DEFAULT_READ_PATHS.size() && readPaths.containsAll(PermissionConstants.DEFAULT_READ_PATHS);
        }

        @Override
        public boolean isReadableTree(@Nonnull Tree tree, @Nullable TreePermissionImpl parent) {
            if (parent != null) {
                if (parent.readableTree) {
                    return true;
                }
                if (!this.isDefaultPaths || parent.tree.getName().equals("jcr:system")) {
                    return this.isReadableTree(tree, true);
                }
                return false;
            }
            return this.isReadableTree(tree, true);
        }

        @Override
        public boolean isReadableTree(@Nonnull Tree tree, boolean exactMatch) {
            String targetPath = tree.getPath();
            for (String path : this.readPaths) {
                if (!targetPath.equals(path)) continue;
                return true;
            }
            if (!exactMatch) {
                for (String path : this.altReadPaths) {
                    if (!targetPath.startsWith(path)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isReadablePath(@Nullable String treePath, boolean exactMatch) {
            if (treePath != null) {
                for (String path : this.readPaths) {
                    if (!treePath.equals(path)) continue;
                    return true;
                }
                if (!exactMatch) {
                    for (String path : this.altReadPaths) {
                        if (!treePath.startsWith(path)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static final class EmptyReadPolicy
    implements ReadPolicy {
        private static final ReadPolicy INSTANCE = new EmptyReadPolicy();

        private EmptyReadPolicy() {
        }

        @Override
        public boolean isReadableTree(@Nonnull Tree tree, @Nullable TreePermissionImpl parent) {
            return false;
        }

        @Override
        public boolean isReadableTree(@Nonnull Tree tree, boolean exactMatch) {
            return false;
        }

        @Override
        public boolean isReadablePath(@Nullable String treePath, boolean exactMatch) {
            return false;
        }
    }

    private static interface ReadPolicy {
        public boolean isReadableTree(@Nonnull Tree var1, @Nullable TreePermissionImpl var2);

        public boolean isReadableTree(@Nonnull Tree var1, boolean var2);

        public boolean isReadablePath(@Nullable String var1, boolean var2);
    }

    private static final class LazyIterator
    extends AbstractLazyIterator<PermissionEntry> {
        private final TreePermissionImpl treePermission;
        private final boolean isUser;
        private final EntryPredicate predicate;
        private Iterator<PermissionEntry> nextEntries = Iterators.emptyIterator();
        private TreePermissionImpl tp;

        private LazyIterator(@Nonnull TreePermissionImpl treePermission, boolean isUser, @Nonnull EntryPredicate predicate) {
            this.treePermission = treePermission;
            this.isUser = isUser;
            this.predicate = predicate;
            this.tp = treePermission;
        }

        @Override
        protected PermissionEntry getNext() {
            PermissionEntry next = null;
            while (next == null) {
                if (this.nextEntries.hasNext()) {
                    PermissionEntry pe = this.nextEntries.next();
                    if (this.predicate.apply(pe)) {
                        next = pe;
                        continue;
                    }
                    this.treePermission.skipped = true;
                    continue;
                }
                if (this.tp == null) break;
                this.nextEntries = this.isUser ? this.tp.getUserEntries() : this.tp.getGroupEntries();
                this.tp = this.tp.parent;
            }
            return next;
        }
    }

    private final class TreePermissionImpl
    implements TreePermission {
        private final Tree tree;
        private final TreePermissionImpl parent;
        private final int type;
        private final boolean readableTree;
        private Collection<PermissionEntry> userEntries;
        private Collection<PermissionEntry> groupEntries;
        private boolean skipped;
        private ReadStatus readStatus;

        private TreePermissionImpl(Tree tree, int treeType, TreePermission parentPermission) {
            this.tree = tree;
            this.parent = parentPermission instanceof TreePermissionImpl ? (TreePermissionImpl)parentPermission : null;
            this.readableTree = CompiledPermissionImpl.this.readPolicy.isReadableTree(tree, this.parent);
            this.type = treeType;
        }

        @Override
        @Nonnull
        public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
            ImmutableTree childTree = new ImmutableTree((ImmutableTree)this.tree, childName, childState);
            return CompiledPermissionImpl.this.getTreePermission(childTree, this);
        }

        @Override
        public boolean canRead() {
            boolean isAcTree = this.isAcTree();
            if (!isAcTree && this.readableTree) {
                return true;
            }
            if (this.readStatus == null) {
                this.readStatus = ReadStatus.DENY_THIS;
                long permission = isAcTree ? 128L : 1L;
                PrivilegeBits requiredBits = (PrivilegeBits)READ_BITS.get(permission);
                Iterator<PermissionEntry> it = this.getIterator(null, permission);
                while (it.hasNext()) {
                    PermissionEntry entry = it.next();
                    if (entry.privilegeBits.includes(requiredBits)) {
                        this.readStatus = ReadStatus.create(entry, permission, this.skipped);
                        break;
                    }
                    if (permission != 1L || !entry.privilegeBits.includes((PrivilegeBits)READ_BITS.get(2L))) continue;
                    this.skipped = true;
                }
            }
            return this.readStatus.allowsThis();
        }

        @Override
        public boolean canRead(@Nonnull PropertyState property) {
            boolean isAcTree = this.isAcTree();
            if (!isAcTree && this.readableTree) {
                return true;
            }
            if (this.readStatus != null && this.readStatus.allowsProperties()) {
                return true;
            }
            long permission = isAcTree ? 128L : 2L;
            Iterator<PermissionEntry> it = this.getIterator(property, permission);
            while (it.hasNext()) {
                PermissionEntry entry = it.next();
                if (!entry.privilegeBits.includes((PrivilegeBits)READ_BITS.get(permission))) continue;
                return entry.isAllow;
            }
            return false;
        }

        @Override
        public boolean canReadAll() {
            return this.readStatus != null && this.readStatus.allowsAll();
        }

        @Override
        public boolean canReadProperties() {
            return this.readStatus != null && this.readStatus.allowsProperties();
        }

        @Override
        public boolean isGranted(long permissions) {
            return CompiledPermissionImpl.this.hasPermissions(this.getIterator(null, permissions), permissions, this.tree.getPath());
        }

        @Override
        public boolean isGranted(long permissions, @Nonnull PropertyState property) {
            return CompiledPermissionImpl.this.hasPermissions(this.getIterator(property, permissions), permissions, this.tree.getPath());
        }

        private Iterator<PermissionEntry> getIterator(@Nullable PropertyState property, long permissions) {
            EntryPredicate predicate = new EntryPredicate(this.tree, property, Permissions.respectParentPermissions(permissions));
            return Iterators.concat((Iterator)new LazyIterator(this, true, predicate), (Iterator)new LazyIterator(this, false, predicate));
        }

        private Iterator<PermissionEntry> getUserEntries() {
            if (this.userEntries == null) {
                this.userEntries = CompiledPermissionImpl.this.userStore.getEntries(this.tree);
            }
            return this.userEntries.iterator();
        }

        private Iterator<PermissionEntry> getGroupEntries() {
            if (this.groupEntries == null) {
                this.groupEntries = CompiledPermissionImpl.this.groupStore.getEntries(this.tree);
            }
            return this.groupEntries.iterator();
        }

        private boolean isAcTree() {
            return this.type == 8;
        }
    }
}

