/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;

abstract class AuthorizableBaseProvider
implements UserConstants {
    final ConfigurationParameters config;
    final Root root;
    final IdentifierManager identifierManager;

    AuthorizableBaseProvider(@Nonnull Root root, @Nonnull ConfigurationParameters config) {
        this.root = (Root)Preconditions.checkNotNull((Object)root);
        this.config = (ConfigurationParameters)Preconditions.checkNotNull((Object)config);
        this.identifierManager = new IdentifierManager(root);
    }

    @CheckForNull
    Tree getByID(@Nonnull String authorizableId, @Nonnull AuthorizableType authorizableType) {
        return this.getByContentID(AuthorizableBaseProvider.getContentID(authorizableId), authorizableType);
    }

    @CheckForNull
    Tree getByContentID(@Nonnull String contentId, @Nonnull AuthorizableType authorizableType) {
        Tree tree = this.identifierManager.getTree(contentId);
        if (UserUtil.isType(tree, authorizableType)) {
            return tree;
        }
        return null;
    }

    @CheckForNull
    Tree getByPath(@Nonnull String authorizableOakPath) {
        Tree tree = this.root.getTree(authorizableOakPath);
        if (UserUtil.isType(tree, AuthorizableType.AUTHORIZABLE)) {
            return tree;
        }
        return null;
    }

    @Nonnull
    String getContentID(@Nonnull Tree authorizableTree) {
        return IdentifierManager.getIdentifier(authorizableTree);
    }

    @Nonnull
    static String getContentID(@Nonnull String authorizableId) {
        return IdentifierManager.generateUUID(authorizableId.toLowerCase());
    }
}

