/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.PathMapper;
import org.apache.jackrabbit.oak.security.user.AdminPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.UserImpl;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.SystemUserPrincipal;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;

public class SystemUserImpl
extends UserImpl {
    SystemUserImpl(@Nonnull String id, @Nonnull Tree tree, @Nonnull UserManagerImpl userManager) throws RepositoryException {
        super(id, tree, userManager);
    }

    @Override
    void checkValidTree(Tree tree) throws RepositoryException {
        super.checkValidTree(tree);
        if (!UserUtil.isSystemUser(tree)) {
            throw new IllegalArgumentException("Invalid user node: node type rep:SystemUser expected.");
        }
    }

    @Override
    public Principal getPrincipal() throws RepositoryException {
        if (this.isAdmin()) {
            return new AdminPrincipalImpl(this.getPrincipalName(), this.getTree(), (PathMapper)this.getUserManager().getNamePathMapper());
        }
        return new SystemUserPrincipalImpl(this.getTree());
    }

    @Override
    public boolean isSystemUser() {
        return true;
    }

    @Override
    public void changePassword(String password) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("system user");
    }

    @Override
    public void changePassword(String password, String oldPassword) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("system user");
    }

    private final class SystemUserPrincipalImpl
    extends TreeBasedPrincipal
    implements SystemUserPrincipal {
        private SystemUserPrincipalImpl(Tree tree) throws RepositoryException {
            super(SystemUserImpl.this.getPrincipalName(), tree, (PathMapper)SystemUserImpl.this.getUserManager().getNamePathMapper());
        }
    }
}

