/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import java.security.Principal;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableWrapper;
import org.apache.jackrabbit.oak.security.user.autosave.GroupImpl;
import org.apache.jackrabbit.oak.security.user.autosave.UserImpl;

public class AutoSaveEnabledManager
implements UserManager {
    private final UserManager dlg;
    private final Root root;
    private boolean autosave = true;

    public AutoSaveEnabledManager(UserManager dlg, Root root) {
        this.dlg = dlg;
        this.root = root;
    }

    @Override
    public Authorizable getAuthorizable(String id) throws RepositoryException {
        return this.wrap(this.dlg.getAuthorizable(id));
    }

    @Override
    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        return this.wrap(this.dlg.getAuthorizable(principal));
    }

    @Override
    public Authorizable getAuthorizableByPath(String path) throws RepositoryException {
        return this.wrap(this.dlg.getAuthorizableByPath(path));
    }

    @Override
    public Iterator<Authorizable> findAuthorizables(String relPath, String value) throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.dlg.findAuthorizables(relPath, value), this);
    }

    @Override
    public Iterator<Authorizable> findAuthorizables(String relPath, String value, int searchType) throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.dlg.findAuthorizables(relPath, value, searchType), this);
    }

    @Override
    public Iterator<Authorizable> findAuthorizables(Query query) throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.dlg.findAuthorizables(query), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String userID, String password) throws RepositoryException {
        try {
            User user = this.wrap(this.dlg.createUser(userID, password));
            return user;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String userID, String password, Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        try {
            User user = this.wrap(this.dlg.createUser(userID, password, principal, intermediatePath));
            return user;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createSystemUser(String userID, String intermediatePath) throws RepositoryException {
        try {
            User user = this.wrap(this.dlg.createUser(userID, intermediatePath));
            return user;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String groupId) throws RepositoryException {
        try {
            Group group = this.wrap(this.dlg.createGroup(groupId));
            return group;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(Principal principal) throws RepositoryException {
        try {
            Group group = this.wrap(this.dlg.createGroup(principal));
            return group;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(Principal principal, String groupId) throws RepositoryException {
        try {
            Group group = this.wrap(this.dlg.createGroup(principal, groupId));
            return group;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String groupID, Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        try {
            Group group = this.wrap(this.dlg.createGroup(groupID, principal, intermediatePath));
            return group;
        }
        finally {
            this.autosave();
        }
    }

    @Override
    public boolean isAutoSave() {
        return this.autosave;
    }

    @Override
    public void autoSave(boolean enable) throws RepositoryException {
        this.autosave = enable;
    }

    void autosave() throws RepositoryException {
        if (this.autosave) {
            try {
                this.root.commit();
            }
            catch (CommitFailedException e) {
                throw e.asRepositoryException();
            }
            finally {
                this.root.refresh();
            }
        }
    }

    @CheckForNull
    Authorizable wrap(@Nullable Authorizable authorizable) {
        if (authorizable == null) {
            return null;
        }
        if (authorizable.isGroup()) {
            return this.wrap((Group)authorizable);
        }
        return this.wrap((User)authorizable);
    }

    @Nonnull
    User wrap(@Nonnull User user) {
        return new UserImpl(user, this);
    }

    @Nonnull
    Group wrap(@Nonnull Group group) {
        return new GroupImpl(group, this);
    }
}

