/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import javax.annotation.Nonnull;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.query.RelationOp;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.util.Text;

public final class QueryUtil {
    private QueryUtil() {
    }

    @Nonnull
    public static String getSearchRoot(AuthorizableType type, ConfigurationParameters config) {
        String path = type == AuthorizableType.USER ? UserUtil.getAuthorizableRootPath(config, AuthorizableType.USER) : (type == AuthorizableType.GROUP ? UserUtil.getAuthorizableRootPath(config, AuthorizableType.GROUP) : UserUtil.getAuthorizableRootPath(config, AuthorizableType.AUTHORIZABLE));
        StringBuilder searchRoot = new StringBuilder();
        searchRoot.append("/jcr:root").append(path);
        return searchRoot.toString();
    }

    @Nonnull
    public static String getNodeTypeName(AuthorizableType type) {
        if (type == AuthorizableType.USER) {
            return "rep:User";
        }
        if (type == AuthorizableType.GROUP) {
            return "rep:Group";
        }
        return "rep:Authorizable";
    }

    @Nonnull
    public static String escapeNodeName(@Nonnull String string) {
        int j;
        StringBuilder result = new StringBuilder();
        int k = 0;
        do {
            if ((j = string.indexOf(37, k)) < 0) {
                result.append(Text.escapeIllegalJcrChars(string.substring(k)));
            } else if (j > 0 && string.charAt(j - 1) == '\\') {
                result.append(Text.escapeIllegalJcrChars(string.substring(k, j) + '%'));
            } else {
                result.append(Text.escapeIllegalJcrChars(string.substring(k, j))).append('%');
            }
            k = j + 1;
        } while (j >= 0);
        return result.toString();
    }

    @Nonnull
    public static String format(@Nonnull Value value) throws RepositoryException {
        switch (value.getType()) {
            case 1: 
            case 6: {
                return '\'' + QueryUtil.escapeForQuery(value.getString()) + '\'';
            }
            case 3: 
            case 4: {
                return value.getString();
            }
            case 5: {
                return "xs:dateTime('" + value.getString() + "')";
            }
        }
        throw new RepositoryException("Property of type " + PropertyType.nameFromValue((int)value.getType()) + " not supported");
    }

    @Nonnull
    public static String escapeForQuery(@Nonnull String oakName, @Nonnull NamePathMapper namePathMapper) {
        return QueryUtil.escapeForQuery(namePathMapper.getJcrName(oakName));
    }

    @Nonnull
    public static String escapeForQuery(@Nonnull String value) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\'') {
                ret.append("''");
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    @Nonnull
    public static RelationOp getCollation(@Nonnull QueryBuilder.Direction direction) throws RepositoryException {
        switch (direction) {
            case ASCENDING: {
                return RelationOp.GT;
            }
            case DESCENDING: {
                return RelationOp.LT;
            }
        }
        throw new RepositoryException("Unknown sort order " + (Object)((Object)direction));
    }
}

