/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.query.Condition;
import org.apache.jackrabbit.oak.security.user.query.ConditionVisitor;
import org.apache.jackrabbit.oak.security.user.query.QueryUtil;
import org.apache.jackrabbit.oak.security.user.query.RelationOp;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;

class XPathConditionVisitor
implements ConditionVisitor {
    private final StringBuilder statement;
    private final NamePathMapper namePathMapper;
    private final UserManager userMgr;

    XPathConditionVisitor(StringBuilder statement, NamePathMapper namePathMapper, UserManager userMgr) {
        this.statement = statement;
        this.namePathMapper = namePathMapper;
        this.userMgr = userMgr;
    }

    @Override
    public void visit(Condition.Node condition) throws RepositoryException {
        this.statement.append('(').append("jcr:like(@").append(QueryUtil.escapeForQuery("rep:authorizableId", this.namePathMapper)).append(",'").append(QueryUtil.escapeForQuery(condition.getPattern())).append("')").append(" or ").append("jcr:like(@").append(QueryUtil.escapeForQuery("rep:principalName", this.namePathMapper)).append(",'").append(QueryUtil.escapeForQuery(condition.getPattern())).append("')").append(" or ").append("jcr:like(fn:name(),'").append(QueryUtil.escapeNodeName(condition.getPattern())).append("')").append(')');
    }

    @Override
    public void visit(Condition.Property condition) throws RepositoryException {
        RelationOp relOp = condition.getOp();
        if (relOp == RelationOp.EX) {
            this.statement.append(QueryUtil.escapeForQuery(condition.getRelPath()));
        } else if (relOp == RelationOp.LIKE) {
            this.statement.append("jcr:like(").append(QueryUtil.escapeForQuery(condition.getRelPath())).append(",'").append(QueryUtil.escapeForQuery(condition.getPattern())).append("')");
        } else {
            this.statement.append(QueryUtil.escapeForQuery(condition.getRelPath())).append(condition.getOp().getOp()).append(QueryUtil.format(condition.getValue()));
        }
    }

    @Override
    public void visit(Condition.Contains condition) {
        this.statement.append("jcr:contains(").append(QueryUtil.escapeForQuery(condition.getRelPath())).append(",'").append(QueryUtil.escapeForQuery(condition.getSearchExpr())).append("')");
    }

    @Override
    public void visit(Condition.Impersonation condition) {
        String principalName = condition.getName();
        boolean isAdmin = false;
        try {
            Authorizable authorizable = this.userMgr.getAuthorizable(new PrincipalImpl(principalName));
            isAdmin = authorizable != null && !authorizable.isGroup() && ((User)authorizable).isAdmin();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        if (isAdmin) {
            this.statement.append('@').append(QueryUtil.escapeForQuery("jcr:primaryType", this.namePathMapper)).append("='").append(QueryUtil.escapeForQuery("rep:User", this.namePathMapper)).append('\'');
        } else {
            this.statement.append('@').append(QueryUtil.escapeForQuery("rep:impersonators", this.namePathMapper)).append("='").append(QueryUtil.escapeForQuery(condition.getName())).append('\'');
        }
    }

    @Override
    public void visit(Condition.Not condition) throws RepositoryException {
        this.statement.append("not(");
        condition.getCondition().accept(this);
        this.statement.append(')');
    }

    @Override
    public void visit(Condition.And condition) throws RepositoryException {
        int count = 0;
        for (Condition c : condition) {
            this.statement.append(count++ > 0 ? " and " : "");
            c.accept(this);
        }
    }

    @Override
    public void visit(Condition.Or condition) throws RepositoryException {
        int pos = this.statement.length();
        int count = 0;
        for (Condition c : condition) {
            this.statement.append(count++ > 0 ? " or " : "");
            c.accept(this);
        }
        if (count > 1) {
            this.statement.insert(pos, '(');
            this.statement.append(')');
        }
    }
}

