/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.document.ClusterViewDocument;

class ClusterView {
    private final String json;

    static ClusterView fromDocument(int localInstanceId, String clusterId, ClusterViewDocument clusterViewDoc, Set<Integer> backlogIds) {
        Set<Integer> activeIds = clusterViewDoc.getActiveIds();
        HashSet<Integer> deactivatingIds = new HashSet<Integer>();
        deactivatingIds.addAll(clusterViewDoc.getRecoveringIds());
        deactivatingIds.addAll(backlogIds);
        HashSet<Integer> inactiveIds = new HashSet<Integer>();
        inactiveIds.addAll(clusterViewDoc.getInactiveIds());
        if (!inactiveIds.removeAll(backlogIds) && backlogIds.size() > 0) {
            throw new IllegalStateException("not all backlogIds (" + backlogIds + ") are part of inactiveIds (" + clusterViewDoc.getInactiveIds() + ")");
        }
        return new ClusterView(clusterViewDoc.getViewSeqNum(), backlogIds.size() == 0, clusterId, localInstanceId, activeIds, deactivatingIds, inactiveIds);
    }

    ClusterView(long viewSeqNum, boolean viewFinal, String clusterId, int localId, Set<Integer> activeIds, Set<Integer> deactivatingIds, Set<Integer> inactiveIds) {
        if (viewSeqNum < 0L) {
            throw new IllegalStateException("viewSeqNum must be zero or higher: " + viewSeqNum);
        }
        if (clusterId == null || clusterId.length() == 0) {
            throw new IllegalStateException("clusterId must not be zero or empty: " + clusterId);
        }
        if (localId < 0) {
            throw new IllegalStateException("localId must not be zero or higher: " + localId);
        }
        if (activeIds == null || activeIds.size() == 0) {
            throw new IllegalStateException("activeIds must not be null or empty");
        }
        if (deactivatingIds == null) {
            throw new IllegalStateException("deactivatingIds must not be null");
        }
        if (inactiveIds == null) {
            throw new IllegalStateException("inactiveIds must not be null");
        }
        this.json = this.asJson(viewSeqNum, viewFinal, clusterId, localId, activeIds, deactivatingIds, inactiveIds);
    }

    private String asJson(long viewSeqNum, boolean viewFinal, String clusterId, int localId, Set<Integer> activeIds, Set<Integer> deactivatingIds, Set<Integer> inactiveIds) {
        JsopBuilder builder = new JsopBuilder();
        builder.object();
        builder.key("seq").value(viewSeqNum);
        builder.key("final").value(viewFinal);
        builder.key("id").value(clusterId);
        builder.key("me").value(localId);
        builder.key("active").array();
        for (Integer anInstance : activeIds) {
            builder.value(anInstance.intValue());
        }
        builder.endArray();
        builder.key("deactivating").array();
        for (Integer anInstance : deactivatingIds) {
            builder.value(anInstance.intValue());
        }
        builder.endArray();
        builder.key("inactive").array();
        for (Integer anInstance : inactiveIds) {
            builder.value(anInstance.intValue());
        }
        builder.endArray();
        builder.endObject();
        return builder.toString();
    }

    public String toString() {
        return "a ClusterView[" + this.json + "]";
    }

    String asDescriptorValue() {
        return this.json;
    }
}

