/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.locks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

class BulkLock
implements Lock {
    private final List<Lock> locks;

    public BulkLock(Iterable<Lock> locks) {
        this.locks = Lists.newArrayList(locks);
    }

    @Override
    public void lock() {
        for (Lock l : this.locks) {
            l.lock();
        }
    }

    @Override
    public void unlock() {
        for (Lock l : Lists.reverse(this.locks)) {
            l.unlock();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

