/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import java.io.Closeable;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.SplitDocumentCleanUp;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoVersionGCSupport
extends VersionGCSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MongoVersionGCSupport.class);
    private final MongoDocumentStore store;
    private final boolean disableIndexHint = Boolean.getBoolean("oak.mongo.disableVersionGCIndexHint");

    public MongoVersionGCSupport(MongoDocumentStore store) {
        super(store);
        this.store = store;
    }

    public CloseableIterable<NodeDocument> getPossiblyDeletedDocs(long lastModifiedTime) {
        DBObject query = QueryBuilder.start((String)"_deletedOnce").is((Object)Boolean.TRUE).put("_modified").lessThan((Object)NodeDocument.getModifiedInSecs(lastModifiedTime)).get();
        DBCursor cursor = this.getNodeCollection().find(query).setReadPreference(ReadPreference.secondaryPreferred());
        if (!this.disableIndexHint) {
            cursor.hint((DBObject)new BasicDBObject("_deletedOnce", (Object)1));
        }
        return CloseableIterable.wrap(Iterables.transform((Iterable)cursor, (Function)new Function<DBObject, NodeDocument>(){

            public NodeDocument apply(DBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, input);
            }
        }), (Closeable)cursor);
    }

    @Override
    protected SplitDocumentCleanUp createCleanUp(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        return new MongoSplitDocCleanUp(gcTypes, oldestRevTimeStamp, stats);
    }

    @Override
    protected Iterable<NodeDocument> identifyGarbage(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp) {
        return Iterables.transform((Iterable)this.getNodeCollection().find(this.createQuery(gcTypes, oldestRevTimeStamp)), (Function)new Function<DBObject, NodeDocument>(){

            public NodeDocument apply(DBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, input);
            }
        });
    }

    private DBObject createQuery(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp) {
        QueryBuilder orClause = QueryBuilder.start();
        for (NodeDocument.SplitDocType type : gcTypes) {
            orClause.or(new DBObject[]{QueryBuilder.start((String)"_sdType").is((Object)type.typeCode()).get()});
        }
        return QueryBuilder.start().and(new DBObject[]{orClause.get(), QueryBuilder.start((String)"_sdMaxRevTime").lessThan((Object)NodeDocument.getModifiedInSecs(oldestRevTimeStamp)).get()}).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSplitDocIdsTobeDeleted(DBObject query) {
        ImmutableList ids;
        BasicDBObject keys = new BasicDBObject("_id", (Object)1);
        DBCursor cursor = this.getNodeCollection().find(query, (DBObject)keys).setReadPreference(this.store.getConfiguredReadPreference(Collection.NODES));
        try {
            ids = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)cursor, (Function)new Function<DBObject, String>(){

                public String apply(DBObject input) {
                    return (String)input.get("_id");
                }
            }));
        }
        finally {
            cursor.close();
        }
        StringBuilder sb = new StringBuilder("Split documents with following ids were deleted as part of GC \n");
        Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, (Iterable)ids);
        LOG.debug(sb.toString());
    }

    private DBCollection getNodeCollection() {
        return this.store.getDBCollection(Collection.NODES);
    }

    private class MongoSplitDocCleanUp
    extends SplitDocumentCleanUp {
        protected final Set<NodeDocument.SplitDocType> gcTypes;
        protected final long oldestRevTimeStamp;

        protected MongoSplitDocCleanUp(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
            super(MongoVersionGCSupport.this.store, stats, MongoVersionGCSupport.this.identifyGarbage(gcTypes, oldestRevTimeStamp));
            this.gcTypes = gcTypes;
            this.oldestRevTimeStamp = oldestRevTimeStamp;
        }

        @Override
        protected int deleteSplitDocuments() {
            DBObject query = MongoVersionGCSupport.this.createQuery(this.gcTypes, this.oldestRevTimeStamp);
            if (LOG.isDebugEnabled()) {
                MongoVersionGCSupport.this.logSplitDocIdsTobeDeleted(query);
            }
            return MongoVersionGCSupport.this.getNodeCollection().remove(query).getN();
        }
    }
}

