/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={IndexEditorProvider.class})
public class OrderedPropertyIndexEditorProvider
implements IndexEditorProvider,
OrderedIndex {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedPropertyIndexEditorProvider.class);
    private static int hits;
    private static int threshold;

    @Override
    @CheckForNull
    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, @Nonnull IndexUpdateCallback callback) throws CommitFailedException {
        if ("ordered".equals(type) && this.hit() % threshold == 0) {
            LOG.warn("Ordered Index has been deprecated since Oak 1.1.8. Please replace the index definitions with Lucene Property index and remove the index providers from the repository. See docs at http://jackrabbit.apache.org/oak/docs");
        }
        return null;
    }

    private synchronized int hit() {
        return hits++;
    }

    static void setThreshold(int t) {
        threshold = t;
    }

    static {
        threshold = 10000;
    }
}

