/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.jmx;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindexMBean;

public class PropertyIndexAsyncReindex
implements PropertyIndexAsyncReindexMBean {
    public static final String OP_NAME = "Property index asynchronous reindex";
    private final AsyncIndexUpdate async;
    private final Executor executor;
    private ManagementOperation<String> arOp = ManagementOperation.done("Property index asynchronous reindex", "");

    public PropertyIndexAsyncReindex(@Nonnull AsyncIndexUpdate async, @Nonnull Executor executor) {
        this.async = (AsyncIndexUpdate)Preconditions.checkNotNull((Object)async);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    @Nonnull
    public CompositeData startPropertyIndexAsyncReindex() {
        if (this.arOp.isDone()) {
            this.arOp = ManagementOperation.newManagementOperation(OP_NAME, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    boolean done = false;
                    while (!done) {
                        PropertyIndexAsyncReindex.this.async.run();
                        done = PropertyIndexAsyncReindex.this.async.isFinished();
                    }
                    return "Reindex completed in " + ManagementOperation.Status.formatTime(System.nanoTime() - t0);
                }
            });
            this.executor.execute(this.arOp);
        }
        return this.getPropertyIndexAsyncReindexStatus();
    }

    @Override
    @Nonnull
    public CompositeData getPropertyIndexAsyncReindexStatus() {
        return this.arOp.getStatus().toCompositeData();
    }
}

