/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeProvider;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeTreePermission;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;

class CompositePermissionProvider
implements PermissionProvider {
    private final Root root;
    private final AggregatedPermissionProvider[] pps;
    private final Context ctx;
    private final RepositoryPermission repositoryPermission;
    private Root immutableRoot;
    private PrivilegeBitsProvider privilegeBitsProvider;
    private TreeTypeProvider typeProvider;

    CompositePermissionProvider(@Nonnull Root root, @Nonnull List<AggregatedPermissionProvider> pps, @Nonnull Context acContext) {
        this.root = root;
        this.pps = pps.toArray(new AggregatedPermissionProvider[pps.size()]);
        this.ctx = acContext;
        this.repositoryPermission = new CompositeRepositoryPermission();
        this.immutableRoot = RootFactory.createReadOnlyRoot(root);
        this.privilegeBitsProvider = new PrivilegeBitsProvider(this.immutableRoot);
        this.typeProvider = new TreeTypeProvider(this.ctx);
    }

    @Override
    public void refresh() {
        this.immutableRoot = RootFactory.createReadOnlyRoot(this.root);
        this.privilegeBitsProvider = new PrivilegeBitsProvider(this.immutableRoot);
        for (AggregatedPermissionProvider pp : this.pps) {
            pp.refresh();
        }
    }

    @Override
    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        Tree immutableTree = PermissionUtil.getImmutableTree(tree, this.immutableRoot);
        PrivilegeBits result = PrivilegeBits.getInstance();
        PrivilegeBits denied = PrivilegeBits.getInstance();
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            PrivilegeBits supported = aggregatedPermissionProvider.supportedPrivileges(immutableTree, null).modifiable();
            if (!CompositePermissionProvider.doEvaluate(supported)) continue;
            PrivilegeBits granted = this.privilegeBitsProvider.getBits(aggregatedPermissionProvider.getPrivileges(immutableTree));
            if (!granted.isEmpty()) {
                result.add(granted);
            }
            denied.add(supported.diff(granted));
        }
        if (!denied.isEmpty()) {
            result.diff(denied);
        }
        return this.privilegeBitsProvider.getPrivilegeNames(result);
    }

    @Override
    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        Tree immutableTree = PermissionUtil.getImmutableTree(tree, this.immutableRoot);
        PrivilegeBits privilegeBits = this.privilegeBitsProvider.getBits(privilegeNames);
        if (privilegeBits.isEmpty()) {
            return true;
        }
        boolean hasPrivileges = false;
        PrivilegeBits coveredPrivs = PrivilegeBits.getInstance();
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            PrivilegeBits supported = aggregatedPermissionProvider.supportedPrivileges(immutableTree, privilegeBits);
            if (!CompositePermissionProvider.doEvaluate(supported)) continue;
            Set<String> supportedNames = this.privilegeBitsProvider.getPrivilegeNames(supported);
            hasPrivileges = aggregatedPermissionProvider.hasPrivileges(immutableTree, supportedNames.toArray(new String[supportedNames.size()]));
            coveredPrivs.add(supported);
            if (!hasPrivileges) break;
        }
        return hasPrivileges && coveredPrivs.includes(privilegeBits);
    }

    @Override
    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return this.repositoryPermission;
    }

    @Override
    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        ImmutableTree immutableTree = (ImmutableTree)PermissionUtil.getImmutableTree(tree, this.immutableRoot);
        if (tree.isRoot()) {
            return CompositeTreePermission.create(immutableTree, this.typeProvider, this.pps);
        }
        if (parentPermission instanceof CompositeTreePermission) {
            return CompositeTreePermission.create(immutableTree, (CompositeTreePermission)parentPermission);
        }
        return parentPermission.getChildPermission(immutableTree.getName(), immutableTree.getNodeState());
    }

    @Override
    public boolean isGranted(@Nonnull Tree parent, @Nullable PropertyState property, long permissions) {
        Tree immParent = PermissionUtil.getImmutableTree(parent, this.immutableRoot);
        boolean isGranted = false;
        long coveredPermissions = 0L;
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            long supportedPermissions = aggregatedPermissionProvider.supportedPermissions(immParent, property, permissions);
            if (!CompositePermissionProvider.doEvaluate(supportedPermissions)) continue;
            isGranted = aggregatedPermissionProvider.isGranted(immParent, property, supportedPermissions);
            coveredPermissions |= supportedPermissions;
            if (!isGranted) break;
        }
        return isGranted && coveredPermissions == permissions;
    }

    @Override
    public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
        Tree tree;
        TreeLocation location = TreeLocation.create(this.immutableRoot, oakPath);
        boolean isAcContent = this.ctx.definesLocation(location);
        long permissions = Permissions.getPermissions(jcrActions, location, isAcContent);
        PropertyState property = location.getProperty();
        Tree tree2 = tree = property == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            return this.isGranted(tree, property, permissions);
        }
        boolean isGranted = false;
        long coveredPermissions = 0L;
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            long supportedPermissions = aggregatedPermissionProvider.supportedPermissions(location, permissions);
            if (!CompositePermissionProvider.doEvaluate(supportedPermissions)) continue;
            isGranted = aggregatedPermissionProvider.isGranted(location, supportedPermissions);
            coveredPermissions |= supportedPermissions;
            if (!isGranted) break;
        }
        return isGranted && coveredPermissions == permissions;
    }

    private static boolean doEvaluate(long supportedPermissions) {
        return supportedPermissions != 0L;
    }

    private static boolean doEvaluate(PrivilegeBits supportedPrivileges) {
        return !supportedPrivileges.isEmpty();
    }

    private final class CompositeRepositoryPermission
    implements RepositoryPermission {
        private CompositeRepositoryPermission() {
        }

        @Override
        public boolean isGranted(long repositoryPermissions) {
            boolean isGranted = false;
            long coveredPermissions = 0L;
            for (AggregatedPermissionProvider aggregatedPermissionProvider : CompositePermissionProvider.this.pps) {
                long supportedPermissions = aggregatedPermissionProvider.supportedPermissions((Tree)null, null, repositoryPermissions);
                if (!CompositePermissionProvider.doEvaluate(supportedPermissions)) continue;
                isGranted = aggregatedPermissionProvider.getRepositoryPermission().isGranted(supportedPermissions);
                coveredPermissions |= supportedPermissions;
                if (!isGranted) break;
            }
            return isGranted && coveredPermissions == repositoryPermissions;
        }
    }
}

