/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;

public final class ImmutablePrivilegeDefinition
implements PrivilegeDefinition {
    private final String name;
    private final boolean isAbstract;
    private final Set<String> declaredAggregateNames;

    public ImmutablePrivilegeDefinition(String name, boolean isAbstract, Iterable<String> declaredAggregateNames) {
        this.name = name;
        this.isAbstract = isAbstract;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (declaredAggregateNames != null) {
            builder.addAll(declaredAggregateNames);
        }
        this.declaredAggregateNames = builder.build();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    @Nonnull
    public Set<String> getDeclaredAggregateNames() {
        return this.declaredAggregateNames;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.isAbstract(), this.declaredAggregateNames});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutablePrivilegeDefinition) {
            ImmutablePrivilegeDefinition other = (ImmutablePrivilegeDefinition)o;
            return this.name.equals(other.name) && this.isAbstract == other.isAbstract && this.declaredAggregateNames.equals(other.declaredAggregateNames);
        }
        return false;
    }

    public String toString() {
        return "PrivilegeDefinition: " + this.name;
    }
}

