/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.jackrabbit.oak.commons.jmx.JmxUtil;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

public class WhiteboardUtils {
    public static final String JMX_OAK_DOMAIN = "org.apache.jackrabbit.oak";

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, long delayInSeconds) {
        return WhiteboardUtils.scheduleWithFixedDelay(whiteboard, runnable, delayInSeconds, false);
    }

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, long delayInSeconds, boolean runOnSingleClusterNode) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"scheduler.period", (Object)delayInSeconds).put((Object)"scheduler.concurrent", (Object)false);
        if (runOnSingleClusterNode) {
            builder.put((Object)"scheduler.runOn", (Object)"SINGLE");
        }
        return whiteboard.register(Runnable.class, runnable, (Map<?, ?>)builder.build());
    }

    public static <T> Registration registerMBean(Whiteboard whiteboard, Class<T> iface, T bean, String type, String name) {
        return WhiteboardUtils.registerMBean(whiteboard, iface, bean, type, name, Collections.<String, String>emptyMap());
    }

    public static <T> Registration registerMBean(Whiteboard whiteboard, Class<T> iface, T bean, String type, String name, Map<String, String> attrs) {
        try {
            Hashtable<String, String> table = new Hashtable<String, String>(attrs);
            table.put("type", JmxUtil.quoteValueIfRequired(type));
            table.put("name", JmxUtil.quoteValueIfRequired(name));
            return whiteboard.register(iface, bean, (Map<?, ?>)ImmutableMap.of((Object)"jmx.objectname", (Object)new ObjectName(JMX_OAK_DOMAIN, table)));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Registration registerObserver(@Nonnull Whiteboard whiteboard, @Nonnull Observer observer) {
        return ((Whiteboard)Preconditions.checkNotNull((Object)whiteboard)).register(Observer.class, Preconditions.checkNotNull((Object)observer), Collections.emptyMap());
    }

    @Nonnull
    public static <T> List<T> getServices(@Nonnull Whiteboard wb, @Nonnull Class<T> type) {
        return WhiteboardUtils.getServices(wb, type, null);
    }

    @CheckForNull
    public static <T> T getService(@Nonnull Whiteboard wb, @Nonnull Class<T> type) {
        return WhiteboardUtils.getService(wb, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <T> List<T> getServices(@Nonnull Whiteboard wb, @Nonnull Class<T> type, @Nullable Predicate<T> predicate) {
        Tracker<T> tracker = wb.track(type);
        try {
            if (predicate == null) {
                List<T> list = tracker.getServices();
                return list;
            }
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.filter(tracker.getServices(), predicate));
            return immutableList;
        }
        finally {
            tracker.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static <T> T getService(@Nonnull Whiteboard wb, @Nonnull Class<T> type, @Nullable Predicate<T> predicate) {
        Tracker<T> tracker = wb.track(type);
        try {
            for (T service : tracker.getServices()) {
                if (predicate != null && !predicate.apply(service)) continue;
                T t = service;
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            tracker.stop();
        }
    }
}

