/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.ContentSessionImpl;
import org.apache.jackrabbit.oak.core.LazyValue;
import org.apache.jackrabbit.oak.core.MutableTree;
import org.apache.jackrabbit.oak.core.SecureNodeBuilder;
import org.apache.jackrabbit.oak.plugins.index.diffindex.UUIDDiffIndexProviderWrapper;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.QueryEngineImpl;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

class MutableRoot
implements Root {
    private final NodeStore store;
    private final CommitHook hook;
    private final String workspaceName;
    private final Subject subject;
    private final SecurityProvider securityProvider;
    private final QueryEngineSettings queryEngineSettings;
    private final QueryIndexProvider indexProvider;
    private final ContentSessionImpl session;
    private final MutableTree rootTree;
    private final NodeBuilder builder;
    private final SecureNodeBuilder secureBuilder;
    private Move lastMove = new Move();
    private final MoveTracker moveTracker = new MoveTracker();
    private long modCount;
    private final LazyValue<PermissionProvider> permissionProvider = new LazyValue<PermissionProvider>(){

        @Override
        protected PermissionProvider createValue() {
            return MutableRoot.this.getAcConfig().getPermissionProvider(MutableRoot.this, MutableRoot.this.getContentSession().getWorkspaceName(), MutableRoot.this.subject.getPrincipals());
        }
    };

    MutableRoot(NodeStore store, CommitHook hook, String workspaceName, Subject subject, SecurityProvider securityProvider, QueryEngineSettings queryEngineSettings, QueryIndexProvider indexProvider, ContentSessionImpl session) {
        this.store = (NodeStore)Preconditions.checkNotNull((Object)store);
        this.hook = (CommitHook)Preconditions.checkNotNull((Object)hook);
        this.workspaceName = (String)Preconditions.checkNotNull((Object)workspaceName);
        this.subject = (Subject)Preconditions.checkNotNull((Object)subject);
        this.securityProvider = (SecurityProvider)Preconditions.checkNotNull((Object)securityProvider);
        this.queryEngineSettings = queryEngineSettings;
        this.indexProvider = indexProvider;
        this.session = (ContentSessionImpl)Preconditions.checkNotNull((Object)session);
        this.builder = store.getRoot().builder();
        this.secureBuilder = new SecureNodeBuilder(this.builder, this.permissionProvider, this.getAcContext());
        this.rootTree = new MutableTree(this, this.secureBuilder, this.lastMove);
    }

    void checkLive() {
        this.session.checkLive();
    }

    @Override
    @Nonnull
    public ContentSession getContentSession() {
        return this.session;
    }

    @Override
    public boolean move(String sourcePath, String destPath) {
        if (PathUtils.isAncestor((String)Preconditions.checkNotNull((Object)sourcePath), (String)Preconditions.checkNotNull((Object)destPath))) {
            return false;
        }
        if (sourcePath.equals(destPath)) {
            return true;
        }
        this.checkLive();
        MutableTree source = this.rootTree.getTree(sourcePath);
        if (!source.exists()) {
            return false;
        }
        String newName = PathUtils.getName(destPath);
        MutableTree newParent = this.rootTree.getTree(PathUtils.getParentPath(destPath));
        if (!newParent.exists() || newParent.hasChild(newName)) {
            return false;
        }
        boolean success = source.moveTo(newParent, newName);
        if (success) {
            this.lastMove = this.lastMove.setMove(sourcePath, newParent, newName);
            this.updated();
            this.moveTracker.addMove(sourcePath, destPath);
        }
        return success;
    }

    @Override
    @Nonnull
    public MutableTree getTree(@Nonnull String path) {
        this.checkLive();
        return this.rootTree.getTree(path);
    }

    @Override
    public void rebase() {
        this.checkLive();
        this.store.rebase(this.builder);
        this.secureBuilder.baseChanged();
        if (this.permissionProvider.hasValue()) {
            this.permissionProvider.get().refresh();
        }
    }

    @Override
    public final void refresh() {
        this.checkLive();
        this.store.reset(this.builder);
        this.secureBuilder.baseChanged();
        this.modCount = 0L;
        if (this.permissionProvider.hasValue()) {
            this.permissionProvider.get().refresh();
        }
    }

    @Override
    public void commit(@Nonnull Map<String, Object> info) throws CommitFailedException {
        this.checkLive();
        ContentSession session = this.getContentSession();
        CommitInfo commitInfo = new CommitInfo(session.toString(), session.getAuthInfo().getUserID(), info);
        this.store.merge(this.builder, this.getCommitHook(), commitInfo);
        this.secureBuilder.baseChanged();
        this.modCount = 0L;
        if (this.permissionProvider.hasValue()) {
            this.permissionProvider.get().refresh();
        }
        this.moveTracker.clear();
    }

    @Override
    public void commit() throws CommitFailedException {
        this.commit(Collections.<String, Object>emptyMap());
    }

    private CommitHook getCommitHook() {
        ArrayList hooks = Lists.newArrayList();
        hooks.add(this.hook);
        ArrayList<CommitHook> postValidationHooks = new ArrayList<CommitHook>();
        for (SecurityConfiguration securityConfiguration : this.securityProvider.getConfigurations()) {
            for (CommitHook commitHook : securityConfiguration.getCommitHooks(this.workspaceName)) {
                if (commitHook instanceof PostValidationHook) {
                    postValidationHooks.add(commitHook);
                    continue;
                }
                if (commitHook == EmptyHook.INSTANCE) continue;
                hooks.add(commitHook);
            }
            List<? extends ValidatorProvider> validators = securityConfiguration.getValidators(this.workspaceName, this.subject.getPrincipals(), this.moveTracker);
            if (validators.isEmpty()) continue;
            hooks.add(new EditorHook(CompositeEditorProvider.compose(validators)));
        }
        hooks.addAll(postValidationHooks);
        return CompositeHook.compose(hooks);
    }

    @Override
    public boolean hasPendingChanges() {
        this.checkLive();
        return this.modCount > 0L;
    }

    @Override
    @Nonnull
    public QueryEngine getQueryEngine() {
        this.checkLive();
        return new QueryEngineImpl(){

            @Override
            protected ExecutionContext getExecutionContext() {
                QueryIndexProvider provider = MutableRoot.this.indexProvider;
                if (MutableRoot.this.hasPendingChanges()) {
                    provider = new UUIDDiffIndexProviderWrapper(provider, MutableRoot.this.getBaseState(), MutableRoot.this.getRootState());
                }
                return new ExecutionContext(MutableRoot.this.getBaseState(), MutableRoot.this, MutableRoot.this.queryEngineSettings, provider, (PermissionProvider)MutableRoot.this.permissionProvider.get());
            }
        };
    }

    @Override
    @Nonnull
    public Blob createBlob(@Nonnull InputStream inputStream) throws IOException {
        this.checkLive();
        return this.store.createBlob((InputStream)Preconditions.checkNotNull((Object)inputStream));
    }

    @Override
    public Blob getBlob(@Nonnull String reference) {
        return this.store.getBlob(reference);
    }

    @Nonnull
    NodeState getBaseState() {
        return this.builder.getBaseState();
    }

    void updated() {
        ++this.modCount;
    }

    @Nonnull
    private NodeState getRootState() {
        return this.builder.getNodeState();
    }

    @Nonnull
    private Context getAcContext() {
        return this.getAcConfig().getContext();
    }

    @Nonnull
    private AuthorizationConfiguration getAcConfig() {
        return this.securityProvider.getConfiguration(AuthorizationConfiguration.class);
    }

    class Move {
        private String source;
        private MutableTree destParent;
        private String destName;
        private Move next;

        Move() {
        }

        Move setMove(String source, MutableTree destParent, String destName) {
            this.source = source;
            this.destParent = destParent;
            this.destName = destName;
            this.next = new Move();
            return this.next;
        }

        Move apply(MutableTree tree) {
            Move move = this;
            while (move.next != null) {
                if (move.source.equals(tree.getPathInternal())) {
                    tree.setParentAndName(move.destParent, move.destName);
                }
                move = move.next;
            }
            return move;
        }

        public String toString() {
            return this.source == null ? "NIL" : '>' + this.source + ':' + PathUtils.concat(this.destParent.getPathInternal(), this.destName);
        }
    }
}

