/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.value.ValueHelper;

public class NodeDelegate
extends ItemDelegate {
    private final Tree tree;

    public NodeDelegate(SessionDelegate sessionDelegate, Tree tree) {
        super(sessionDelegate);
        this.tree = tree;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.tree.getName();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.tree.getPath();
    }

    @Override
    @CheckForNull
    public NodeDelegate getParent() {
        return this.tree.isRoot() || !this.tree.getParent().exists() ? null : new NodeDelegate(this.sessionDelegate, this.tree.getParent());
    }

    @Override
    public boolean exists() {
        return this.tree.exists();
    }

    @Override
    @CheckForNull
    public Tree.Status getStatus() {
        return this.tree.getStatus();
    }

    @Nonnull
    public String getIdentifier() throws InvalidItemStateException {
        return IdentifierManager.getIdentifier(this.getTree());
    }

    @Override
    public boolean isProtected() throws InvalidItemStateException {
        Tree tree = this.getTree();
        if (tree.isRoot()) {
            return false;
        }
        Tree parent = tree.getParent();
        String nameWithIndex = tree.getName();
        String name = PathUtils.dropIndexFromName(nameWithIndex);
        boolean sns = !name.equals(nameWithIndex);
        Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
        List<Tree> types = TreeUtil.getEffectiveType(parent, typeRoot);
        boolean protectedResidual = false;
        for (Tree type : types) {
            if (Iterables.contains(TreeUtil.getNames(type, "rep:protectedChildNodes"), (Object)name)) {
                return true;
            }
            if (protectedResidual) continue;
            protectedResidual = TreeUtil.getBoolean(type, "rep:hasProtectedResidualChildNodes");
        }
        if (protectedResidual) {
            HashSet typeNames = Sets.newHashSet();
            for (Tree type : TreeUtil.getEffectiveType(tree, typeRoot)) {
                typeNames.add(TreeUtil.getName(type, "jcr:nodeTypeName"));
                Iterables.addAll((Collection)typeNames, TreeUtil.getNames(type, "rep:supertypes"));
            }
            for (Tree type : types) {
                Tree definitions = type.getChild("rep:residualChildNodeDefinitions");
                for (String typeName : typeNames) {
                    Tree definition = definitions.getChild(typeName);
                    if (sns && !TreeUtil.getBoolean(definition, "jcr:sameNameSiblings") || !TreeUtil.getBoolean(definition, "jcr:protected")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    boolean isProtected(String property) throws InvalidItemStateException {
        Tree tree = this.getTree();
        Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
        List<Tree> types = TreeUtil.getEffectiveType(tree, typeRoot);
        boolean protectedResidual = false;
        for (Tree type : types) {
            if (Iterables.contains(TreeUtil.getNames(type, "rep:protectedProperties"), (Object)property)) {
                return true;
            }
            if (protectedResidual) continue;
            protectedResidual = TreeUtil.getBoolean(type, "rep:hasProtectedResidualProperties");
        }
        if (protectedResidual) {
            for (Tree type : types) {
                Tree definitions = type.getChild("rep:residualPropertyDefinitions");
                for (Tree definition : definitions.getChildren()) {
                    if (!TreeUtil.getBoolean(definition, "jcr:protected")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRoot() throws InvalidItemStateException {
        return this.getTree().isRoot();
    }

    public long getPropertyCount() throws InvalidItemStateException {
        return this.getTree().getPropertyCount();
    }

    @CheckForNull
    public PropertyDelegate getPropertyOrNull(String relPath) throws RepositoryException {
        PropertyDelegate property;
        Tree parent = this.tree;
        String name = relPath;
        int slash = relPath.lastIndexOf(47);
        if (slash != -1) {
            parent = this.getTree(relPath.substring(0, slash));
            name = relPath.substring(slash + 1);
        }
        if (parent != null && (property = new PropertyDelegate(this.sessionDelegate, parent, name)).exists()) {
            return property;
        }
        return null;
    }

    @Nonnull
    public PropertyDelegate getProperty(String relPath) throws RepositoryException {
        Tree parent = this.tree;
        String name = relPath;
        int slash = relPath.lastIndexOf(47);
        if (slash != -1) {
            parent = this.getTree(relPath.substring(0, slash));
            name = relPath.substring(slash + 1);
        }
        return new PropertyDelegate(this.sessionDelegate, parent, name);
    }

    @Nonnull
    public Iterator<PropertyDelegate> getProperties() throws InvalidItemStateException {
        return Iterators.transform(this.getTree().getProperties().iterator(), (Function)new Function<PropertyState, PropertyDelegate>(){

            public PropertyDelegate apply(PropertyState propertyState) {
                return new PropertyDelegate(NodeDelegate.this.sessionDelegate, NodeDelegate.this.tree, propertyState.getName());
            }
        });
    }

    public long getChildCount(long max) throws InvalidItemStateException {
        return this.getTree().getChildrenCount(max);
    }

    @CheckForNull
    public NodeDelegate getChild(String relPath) throws RepositoryException {
        if (relPath.isEmpty()) {
            return this;
        }
        Tree tree = this.getTree(relPath);
        return tree == null || !tree.exists() ? null : new NodeDelegate(this.sessionDelegate, tree);
    }

    @Nonnull
    public Iterator<NodeDelegate> getChildren() throws InvalidItemStateException {
        Iterator<Tree> iterator = this.getTree().getChildren().iterator();
        return Iterators.transform((Iterator)Iterators.filter(iterator, (Predicate)new Predicate<Tree>(){

            public boolean apply(Tree tree) {
                return tree.exists();
            }
        }), (Function)new Function<Tree, NodeDelegate>(){

            public NodeDelegate apply(Tree tree) {
                return new NodeDelegate(NodeDelegate.this.sessionDelegate, tree);
            }
        });
    }

    public void orderBefore(String source, String target) throws ItemNotFoundException, InvalidItemStateException {
        Tree tree = this.getTree();
        if (!tree.getChild(source).exists()) {
            throw new ItemNotFoundException("Not a child: " + source);
        }
        if (target != null && !tree.getChild(target).exists()) {
            throw new ItemNotFoundException("Not a child: " + target);
        }
        tree.getChild(source).orderBefore(target);
    }

    public boolean canAddMixin(String typeName) throws RepositoryException {
        Tree type = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes").getChild(typeName);
        if (type.exists()) {
            return !TreeUtil.getBoolean(type, "jcr:isAbstract") && TreeUtil.getBoolean(type, "jcr:isMixin");
        }
        throw new NoSuchNodeTypeException("Node type " + typeName + " does not exist");
    }

    public void addMixin(String typeName) throws RepositoryException {
        TreeUtil.addMixin(this.getTree(), typeName, this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes"), this.getUserID());
    }

    public void removeMixin(String typeName) throws RepositoryException {
        Tree tree = this.getTree();
        LinkedHashSet mixins = Sets.newLinkedHashSet(TreeUtil.getNames(tree, "jcr:mixinTypes"));
        if (!mixins.remove(typeName)) {
            throw new NoSuchNodeTypeException("Mixin " + typeName + " not contained in " + this.getPath());
        }
        this.updateMixins(mixins, Collections.singleton(typeName));
    }

    public void setMixins(Set<String> mixinNames) throws RepositoryException {
        LinkedHashSet existingMixins = Sets.newLinkedHashSet(TreeUtil.getNames(this.tree, "jcr:mixinTypes"));
        if (existingMixins.isEmpty()) {
            this.updateMixins(mixinNames, Collections.<String>emptySet());
        } else {
            LinkedHashSet toRemove = Sets.newLinkedHashSet();
            for (String name : existingMixins) {
                if (mixinNames.remove(name)) continue;
                toRemove.add(name);
            }
            this.updateMixins(mixinNames, toRemove);
        }
    }

    public void updateMixins(Set<String> addMixinNames, Set<String> removedOakMixinNames) throws RepositoryException {
        for (String oakMixinName : addMixinNames) {
            this.addMixin(oakMixinName);
        }
        if (!removedOakMixinNames.isEmpty()) {
            Tree newDefinition;
            Tree oldDefinition;
            String name;
            LinkedHashSet mixinNames = Sets.newLinkedHashSet(TreeUtil.getNames(this.getTree(), "jcr:mixinTypes"));
            if (mixinNames.removeAll(removedOakMixinNames)) {
                mixinNames.addAll(addMixinNames);
                this.tree.setProperty("jcr:mixinTypes", mixinNames, Type.NAMES);
            }
            boolean wasLockable = this.isNodeType("mix:lockable");
            boolean isLockable = this.isNodeType("mix:lockable");
            if (wasLockable && !isLockable && this.holdsLock(false)) {
                this.unlock();
                this.sessionDelegate.refresh(true);
            }
            Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
            ArrayList<Tree> removed = new ArrayList<Tree>();
            for (String name2 : removedOakMixinNames) {
                removed.add(typeRoot.getChild(name2));
            }
            List<Tree> remaining = this.getNodeTypes(this.tree, typeRoot);
            for (PropertyState propertyState : this.tree.getProperties()) {
                Type<?> type;
                name = propertyState.getName();
                oldDefinition = this.findMatchingPropertyDefinition(removed, name, type = propertyState.getType(), true);
                if (oldDefinition == null || (newDefinition = this.findMatchingPropertyDefinition(remaining, name, type, true)) != null && (!TreeUtil.getBoolean(oldDefinition, "jcr:protected") || TreeUtil.getBoolean(newDefinition, "jcr:protected"))) continue;
                this.tree.removeProperty(name);
            }
            for (Tree tree : this.tree.getChildren()) {
                name = tree.getName();
                LinkedHashSet typeNames = Sets.newLinkedHashSet();
                for (Tree type : this.getNodeTypes(tree, typeRoot)) {
                    typeNames.add(TreeUtil.getName(type, "jcr:nodeTypeName"));
                    Iterables.addAll((Collection)typeNames, TreeUtil.getNames(type, "rep:supertypes"));
                }
                oldDefinition = this.findMatchingChildNodeDefinition(removed, name, typeNames);
                if (oldDefinition == null || (newDefinition = this.findMatchingChildNodeDefinition(remaining, name, typeNames)) != null && (!TreeUtil.getBoolean(oldDefinition, "jcr:protected") || TreeUtil.getBoolean(newDefinition, "jcr:protected"))) continue;
                tree.remove();
            }
        }
    }

    @Nonnull
    public PropertyDelegate setProperty(PropertyState propertyState, boolean exactTypeMatch, boolean setProtected) throws RepositoryException {
        Tree tree = this.getTree();
        String name = propertyState.getName();
        Type<?> type = propertyState.getType();
        PropertyState old = tree.getProperty(name);
        if (old != null && old.isArray() && !propertyState.isArray()) {
            throw new ValueFormatException("Can not assign a single value to multi-valued property: " + propertyState);
        }
        if (old != null && !old.isArray() && propertyState.isArray()) {
            throw new ValueFormatException("Can not assign multiple values to single valued property: " + propertyState);
        }
        Tree definition = this.findMatchingPropertyDefinition(this.getNodeTypes(tree), name, type, exactTypeMatch);
        if (definition == null) {
            throw new ConstraintViolationException("No matching property definition: " + propertyState);
        }
        if (!setProtected && TreeUtil.getBoolean(definition, "jcr:protected")) {
            throw new ConstraintViolationException("Property is protected: " + propertyState);
        }
        Type<?> requiredType = Type.fromString(TreeUtil.getString(definition, "jcr:requiredType"));
        if (requiredType != Type.UNDEFINED) {
            if (TreeUtil.getBoolean(definition, "jcr:multiple")) {
                requiredType = requiredType.getArrayType();
            }
            ValueHelper.checkSupportedConversion(propertyState.getType().tag(), requiredType.tag());
            propertyState = PropertyStates.convert(propertyState, requiredType);
        }
        tree.setProperty(propertyState);
        return new PropertyDelegate(this.sessionDelegate, tree, name);
    }

    private List<Tree> getNodeTypes(Tree tree) {
        Root root = this.sessionDelegate.getRoot();
        return this.getNodeTypes(tree, root.getTree("/jcr:system/jcr:nodeTypes"));
    }

    private List<Tree> getNodeTypes(Tree tree, Tree typeRoot) {
        ArrayList types = Lists.newArrayList();
        String primaryName = TreeUtil.getName(tree, "jcr:primaryType");
        if (primaryName == null) {
            primaryName = "nt:base";
        }
        types.add(typeRoot.getChild(primaryName));
        for (String mixinName : TreeUtil.getNames(tree, "jcr:mixinTypes")) {
            types.add(typeRoot.getChild(mixinName));
        }
        return types;
    }

    private boolean isNodeType(String typeName) {
        return this.isNodeType(this.tree, typeName, this.sessionDelegate.getRoot());
    }

    private boolean isNodeType(Tree tree, String typeName, Root root) {
        return TreeUtil.isNodeType(tree, typeName, root.getTree("/jcr:system/jcr:nodeTypes"));
    }

    private Tree findMatchingPropertyDefinition(List<Tree> types, String propertyName, Type<?> propertyType, boolean exactTypeMatch) {
        Tree definition;
        Tree definitions;
        String escapedName = "jcr:primaryType".equals(propertyName) ? "rep:primaryType" : ("jcr:mixinTypes".equals(propertyName) ? "rep:mixinTypes" : ("jcr:uuid".equals(propertyName) ? "rep:uuid" : propertyName));
        String definedType = propertyType.toString();
        String undefinedType = Type.UNDEFINED.toString();
        if (propertyType.isArray()) {
            undefinedType = Type.UNDEFINEDS.toString();
        }
        Tree fuzzyMatch = null;
        for (Tree type : types) {
            definitions = type.getChild("rep:namedPropertyDefinitions").getChild(escapedName);
            definition = definitions.getChild(definedType);
            if (definition.exists()) {
                return definition;
            }
            definition = definitions.getChild(undefinedType);
            if (definition.exists()) {
                return definition;
            }
            for (Tree def : definitions.getChildren()) {
                if (propertyType.isArray() != TreeUtil.getBoolean(def, "jcr:multiple")) continue;
                if (TreeUtil.getBoolean(def, "jcr:protected")) {
                    return null;
                }
                if (exactTypeMatch || fuzzyMatch != null) continue;
                fuzzyMatch = def;
            }
        }
        block2: for (Tree type : types) {
            definitions = type.getChild("rep:residualPropertyDefinitions");
            definition = definitions.getChild(definedType);
            if (definition.exists()) {
                return definition;
            }
            definition = definitions.getChild(undefinedType);
            if (definition.exists()) {
                return definition;
            }
            if (exactTypeMatch || fuzzyMatch != null) continue;
            for (Tree def : definitions.getChildren()) {
                if (propertyType.isArray() != TreeUtil.getBoolean(def, "jcr:multiple")) continue;
                fuzzyMatch = def;
                continue block2;
            }
        }
        return fuzzyMatch;
    }

    private Tree findMatchingChildNodeDefinition(List<Tree> types, String childNodeName, Set<String> typeNames) {
        Tree definition;
        Tree definitions;
        for (Tree type : types) {
            definitions = type.getChild("rep:namedChildNodeDefinitions").getChild(childNodeName);
            for (String typeName : typeNames) {
                definition = definitions.getChild(typeName);
                if (!definition.exists()) continue;
                return definition;
            }
        }
        for (Tree type : types) {
            definitions = type.getChild("rep:residualChildNodeDefinitions");
            for (String typeName : typeNames) {
                definition = definitions.getChild(typeName);
                if (!definition.exists()) continue;
                return definition;
            }
        }
        return null;
    }

    @CheckForNull
    public NodeDelegate addChild(String name, String typeName) throws RepositoryException {
        Tree tree = this.getTree();
        if (tree.hasChild(name)) {
            return null;
        }
        Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
        Tree child = TreeUtil.addChild(tree, name, typeName, typeRoot, this.getUserID());
        return new NodeDelegate(this.sessionDelegate, child);
    }

    @Override
    public boolean remove() throws InvalidItemStateException {
        return this.getTree().remove();
    }

    public void setOrderableChildren(boolean enable) throws InvalidItemStateException {
        this.getTree().setOrderableChildren(enable);
    }

    public boolean isLocked() {
        return this.getLock() != null;
    }

    @CheckForNull
    public NodeDelegate getLock() {
        Tree lock = this.findLock(this.tree, false);
        if (lock != null) {
            NodeDelegate delegate = new NodeDelegate(this.sessionDelegate, lock);
            if (delegate.isNodeType("mix:lockable")) {
                return delegate;
            }
            if (lock.isRoot()) {
                return null;
            }
            lock = this.findLock(lock.getParent(), true);
        }
        return null;
    }

    @CheckForNull
    private Tree findLock(@Nonnull Tree tree, boolean deep) {
        if (this.holdsLock(tree, deep)) {
            return tree;
        }
        if (tree.isRoot()) {
            return null;
        }
        return this.findLock(tree.getParent(), true);
    }

    private boolean holdsLock(Tree tree, boolean deep) {
        PropertyState property = tree.getProperty("jcr:lockIsDeep");
        return property != null && property.getType() == Type.BOOLEAN && (!deep || property.getValue(Type.BOOLEAN) != false);
    }

    @CheckForNull
    private Tree findDescendantLock(@Nonnull Tree tree) {
        for (Tree child : tree.getChildren()) {
            if (this.holdsLock(child, false)) {
                return child;
            }
            Tree desc = this.findDescendantLock(child);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    public boolean holdsLock(boolean deep) {
        return this.holdsLock(this.tree, deep) && this.isNodeType("mix:lockable");
    }

    public String getLockOwner() {
        PropertyState property = this.tree.getProperty("jcr:lockOwner");
        if (property != null && property.getType() == Type.STRING) {
            return property.getValue(Type.STRING);
        }
        return null;
    }

    public boolean isLockOwner(String user) {
        return user != null && user.equals(this.getLockOwner());
    }

    public void lock(boolean isDeep) throws RepositoryException {
        Tree descendantLock;
        String path = this.getPath();
        Root root = this.sessionDelegate.getContentSession().getLatestRoot();
        Tree tree = root.getTree(path);
        if (!tree.exists()) {
            throw new ItemNotFoundException("Node " + path + " does not exist");
        }
        if (!this.isNodeType(tree, "mix:lockable", root)) {
            throw new LockException("Node " + path + " is not lockable");
        }
        if (tree.hasProperty("jcr:lockIsDeep")) {
            throw new LockException("Node " + path + " is already locked");
        }
        Tree inheritedLock = this.findLock(tree, true);
        if (inheritedLock != null) {
            throw new LockException("Node already indirectly locked by " + inheritedLock.getPath());
        }
        if (isDeep && (descendantLock = this.findDescendantLock(tree)) != null) {
            throw new LockException("Lock conflicts with lock hold by " + descendantLock.getPath());
        }
        try {
            String owner = this.sessionDelegate.getAuthInfo().getUserID();
            if (owner == null) {
                owner = "";
            }
            tree.setProperty("jcr:lockIsDeep", isDeep);
            tree.setProperty("jcr:lockOwner", owner);
            this.sessionDelegate.commit(root);
        }
        catch (CommitFailedException e) {
            if (e.isAccessViolation()) {
                throw new AccessControlException("Access denied to lock node " + path, (Throwable)e);
            }
            throw new RepositoryException("Unable to lock node " + path, (Throwable)e);
        }
    }

    public void unlock() throws RepositoryException {
        String path = this.getPath();
        Root root = this.sessionDelegate.getContentSession().getLatestRoot();
        Tree tree = root.getTree(path);
        if (!tree.exists()) {
            throw new ItemNotFoundException("Node " + path + " does not exist");
        }
        if (!this.isNodeType(tree, "mix:lockable", root)) {
            throw new LockException("Node " + path + " is not lockable");
        }
        if (!tree.hasProperty("jcr:lockIsDeep")) {
            throw new LockException("Node " + path + " is not locked");
        }
        try {
            tree.removeProperty("jcr:lockIsDeep");
            tree.removeProperty("jcr:lockOwner");
            this.sessionDelegate.commit(root);
        }
        catch (CommitFailedException e) {
            if (e.isAccessViolation()) {
                throw new AccessControlException("Access denied to unlock node " + path, (Throwable)e);
            }
            throw new RepositoryException("Unable to unlock node " + path, (Throwable)e);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tree", (Object)this.tree).toString();
    }

    @Nonnull
    public Tree getTree() throws InvalidItemStateException {
        if (!this.tree.exists()) {
            throw new InvalidItemStateException("Item is stale " + this.tree.getPath());
        }
        return this.tree;
    }

    private Tree getTree(String relPath) throws RepositoryException {
        if (PathUtils.isAbsolute(relPath)) {
            throw new RepositoryException("Not a relative path: " + relPath);
        }
        return TreeUtil.getTree(this.tree, relPath);
    }

    private String getUserID() {
        return this.sessionDelegate.getAuthInfo().getUserID();
    }
}

