/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.osgi;

import com.google.common.base.Preconditions;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class OsgiUtil {
    private OsgiUtil() {
    }

    public static String lookup(ComponentContext context, String name) {
        return OsgiUtil.asString(((ComponentContext)Preconditions.checkNotNull((Object)context)).getProperties().get(Preconditions.checkNotNull((Object)name)));
    }

    public static String lookup(BundleContext context, String name) {
        return OsgiUtil.asString(((BundleContext)Preconditions.checkNotNull((Object)context)).getProperty((String)Preconditions.checkNotNull((Object)name)));
    }

    public static String lookupConfigurationThenFramework(ComponentContext context, String name) {
        return OsgiUtil.lookupConfigurationThenFramework(context, name, name);
    }

    public static String lookupConfigurationThenFramework(ComponentContext context, String nameInComponent, String nameInFramework) {
        String fromComponent = OsgiUtil.lookup(context, nameInComponent);
        if (fromComponent != null) {
            return fromComponent;
        }
        String fromFramework = OsgiUtil.lookup(context.getBundleContext(), nameInFramework);
        if (fromFramework != null) {
            return fromFramework;
        }
        return null;
    }

    public static String lookupFrameworkThenConfiguration(ComponentContext context, String name) {
        return OsgiUtil.lookupFrameworkThenConfiguration(context, name, name);
    }

    public static String lookupFrameworkThenConfiguration(ComponentContext context, String nameInComponent, String nameInFramework) {
        String fromFramework = OsgiUtil.lookup(((ComponentContext)Preconditions.checkNotNull((Object)context)).getBundleContext(), nameInFramework);
        if (fromFramework != null) {
            return fromFramework;
        }
        String fromComponent = OsgiUtil.lookup(context, nameInComponent);
        if (fromComponent != null) {
            return fromComponent;
        }
        return null;
    }

    private static String asString(Object value) {
        if (value == null) {
            return null;
        }
        String string = value.toString().trim();
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }
}

