/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.jackrabbit.core.data.CachingFDS;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.datastore.AbstractDataStoreService;
import org.apache.jackrabbit.oak.plugins.blob.datastore.OakFileDataStore;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, name="org.apache.jackrabbit.oak.plugins.blob.datastore.FileDataStore")
public class FileDataStoreService
extends AbstractDataStoreService {
    public static final String NAME = "org.apache.jackrabbit.oak.plugins.blob.datastore.FileDataStore";
    public static final String CACHE_PATH = "cachePath";
    public static final String CACHE_SIZE = "cacheSize";
    public static final String FS_BACKEND_PATH = "fsBackendPath";
    public static final String PATH = "path";
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected DataStore createDataStore(ComponentContext context, Map<String, Object> config) {
        long cacheSize = PropertiesUtil.toLong(config.get(CACHE_SIZE), 0L);
        if (cacheSize > 0L) {
            String fsBackendPath = PropertiesUtil.toString(config.get(PATH), null);
            Preconditions.checkNotNull((Object)fsBackendPath, (Object)"Cannot create FileDataStoreService with caching. [{path}] property not configured.");
            CachingFDS dataStore = new CachingFDS();
            dataStore.setAsyncUploadLimit(PropertiesUtil.toInteger(config.get("asyncUploadLimit"), 0));
            config.remove(PATH);
            config.remove(CACHE_SIZE);
            config.put(FS_BACKEND_PATH, fsBackendPath);
            config.put(CACHE_SIZE, cacheSize);
            String cachePath = PropertiesUtil.toString(config.get(CACHE_PATH), null);
            if (cachePath != null) {
                config.remove(CACHE_PATH);
                config.put(PATH, cachePath);
            }
            Properties properties = new Properties();
            properties.putAll(config);
            dataStore.setProperties(properties);
            this.log.info("CachingFDS initialized with properties " + properties);
            return dataStore;
        }
        this.log.info("OakFileDataStore initialized");
        return new OakFileDataStore();
    }

    @Override
    protected String[] getDescription() {
        return new String[]{"type=filesystem"};
    }
}

