/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

class CommitDiff
implements NodeStateDiff {
    private final DocumentNodeStore store;
    private final Commit commit;
    private final String path;
    private final JsopBuilder builder;
    private final BlobSerializer blobs;

    CommitDiff(@Nonnull DocumentNodeStore store, @Nonnull Commit commit, @Nonnull BlobSerializer blobs) {
        this((DocumentNodeStore)Preconditions.checkNotNull((Object)store), (Commit)Preconditions.checkNotNull((Object)commit), "/", new JsopBuilder(), (BlobSerializer)Preconditions.checkNotNull((Object)blobs));
    }

    private CommitDiff(DocumentNodeStore store, Commit commit, String path, JsopBuilder builder, BlobSerializer blobs) {
        this.store = store;
        this.commit = commit;
        this.path = path;
        this.builder = builder;
        this.blobs = blobs;
    }

    @Override
    public boolean propertyAdded(PropertyState after) {
        this.setProperty(after);
        return true;
    }

    @Override
    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.setProperty(after);
        return true;
    }

    @Override
    public boolean propertyDeleted(PropertyState before) {
        this.commit.updateProperty(this.path, before.getName(), null);
        return true;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        String p = PathUtils.concat(this.path, name);
        this.commit.addNode(new DocumentNodeState(this.store, p, new RevisionVector(this.commit.getRevision())));
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, new CommitDiff(this.store, this.commit, p, this.builder, this.blobs));
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        String p = PathUtils.concat(this.path, name);
        return after.compareAgainstBaseState(before, new CommitDiff(this.store, this.commit, p, this.builder, this.blobs));
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        String p = PathUtils.concat(this.path, name);
        this.commit.removeNode(p, before);
        return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, new CommitDiff(this.store, this.commit, p, this.builder, this.blobs));
    }

    private void setProperty(PropertyState property) {
        this.builder.resetWriter();
        JsonSerializer serializer = new JsonSerializer(this.builder, this.blobs);
        serializer.serialize(property);
        this.commit.updateProperty(this.path, property.getName(), serializer.toString());
        if (property.getType() == Type.BINARY || property.getType() == Type.BINARIES) {
            this.commit.markNodeHavingBinary(this.path);
        }
    }
}

