/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.LoggerFactory;

public class DocumentNodeState
extends AbstractNodeState
implements CacheValue {
    private static final PerfLogger perfLogger = new PerfLogger(LoggerFactory.getLogger((String)(DocumentNodeState.class.getName() + ".perf")));
    public static final Children NO_CHILDREN = new Children();
    static final int INITIAL_FETCH_SIZE = 100;
    static final int MAX_FETCH_SIZE = 1600;
    final String path;
    final RevisionVector readRevision;
    RevisionVector lastRevision;
    final RevisionVector rootRevision;
    final boolean fromExternalChange;
    final Map<String, PropertyState> properties;
    final boolean hasChildren;
    private final DocumentNodeStore store;

    DocumentNodeState(@Nonnull DocumentNodeStore store, @Nonnull String path, @Nonnull RevisionVector readRevision) {
        this(store, path, readRevision, false);
    }

    DocumentNodeState(@Nonnull DocumentNodeStore store, @Nonnull String path, @Nonnull RevisionVector readRevision, boolean hasChildren) {
        this(store, path, readRevision, new HashMap<String, PropertyState>(), hasChildren, null, null, false);
    }

    private DocumentNodeState(@Nonnull DocumentNodeStore store, @Nonnull String path, @Nonnull RevisionVector readRevision, @Nonnull Map<String, PropertyState> properties, boolean hasChildren, @Nullable RevisionVector lastRevision, @Nullable RevisionVector rootRevision, boolean fromExternalChange) {
        this.store = (DocumentNodeStore)Preconditions.checkNotNull((Object)store);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.readRevision = (RevisionVector)Preconditions.checkNotNull((Object)readRevision);
        this.lastRevision = lastRevision;
        this.rootRevision = rootRevision != null ? rootRevision : readRevision;
        this.fromExternalChange = fromExternalChange;
        this.hasChildren = hasChildren;
        this.properties = (Map)Preconditions.checkNotNull(properties);
    }

    private DocumentNodeState withRootRevision(@Nonnull RevisionVector root, boolean externalChange) {
        if (this.rootRevision.equals(root) && this.fromExternalChange == externalChange) {
            return this;
        }
        return new DocumentNodeState(this.store, this.path, this.readRevision, this.properties, this.hasChildren, this.lastRevision, root, externalChange);
    }

    @Nonnull
    DocumentNodeState fromExternalChange() {
        return new DocumentNodeState(this.store, this.path, this.readRevision, this.properties, this.hasChildren, this.lastRevision, this.rootRevision, true);
    }

    boolean isFromExternalChange() {
        return this.fromExternalChange;
    }

    @Nonnull
    RevisionVector getRevision() {
        return this.readRevision;
    }

    @Nonnull
    RevisionVector getRootRevision() {
        return this.rootRevision;
    }

    @Override
    public boolean equals(Object that) {
        ModifiedNodeState modified;
        if (this == that) {
            return true;
        }
        if (that instanceof DocumentNodeState) {
            DocumentNodeState other = (DocumentNodeState)that;
            if (!this.getPath().equals(other.getPath())) {
                return false;
            }
            if (this.revisionEquals(other)) {
                return true;
            }
        } else if (that instanceof ModifiedNodeState && (modified = (ModifiedNodeState)that).getBaseState() == this) {
            return EqualsDiff.equals(this, modified);
        }
        if (that instanceof NodeState) {
            return AbstractNodeState.equals(this, (NodeState)that);
        }
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public PropertyState getProperty(@Nonnull String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean hasProperty(@Nonnull String name) {
        return this.properties.containsKey(name);
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        return this.properties.values();
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        if (!this.hasChildren || !DocumentNodeState.isValidName(name)) {
            return false;
        }
        String p = PathUtils.concat(this.getPath(), name);
        return this.store.getNode(p, this.lastRevision) != null;
    }

    @Override
    @Nonnull
    public NodeState getChildNode(@Nonnull String name) {
        if (!this.hasChildren) {
            DocumentNodeState.checkValidName(name);
            return EmptyNodeState.MISSING_NODE;
        }
        String p = PathUtils.concat(this.getPath(), name);
        DocumentNodeState child = this.store.getNode(p, this.lastRevision);
        if (child == null) {
            DocumentNodeState.checkValidName(name);
            return EmptyNodeState.MISSING_NODE;
        }
        return child.withRootRevision(this.rootRevision, this.fromExternalChange);
    }

    @Override
    public long getChildNodeCount(long max) {
        if (!this.hasChildren) {
            return 0L;
        }
        if (max > (long)DocumentNodeStore.NUM_CHILDREN_CACHE_LIMIT) {
            return Iterators.size((Iterator)new ChildNodeEntryIterator());
        }
        Children c = this.store.getChildren(this, null, (int)max);
        if (c.hasMore) {
            return Long.MAX_VALUE;
        }
        return c.children.size();
    }

    @Override
    @Nonnull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        if (!this.hasChildren) {
            return Collections.emptyList();
        }
        return new Iterable<ChildNodeEntry>(){

            @Override
            public Iterator<ChildNodeEntry> iterator() {
                return new ChildNodeEntryIterator();
            }
        };
    }

    @Override
    @Nonnull
    public NodeBuilder builder() {
        if ("/".equals(this.getPath())) {
            if (this.readRevision.isBranch()) {
                Branch b = this.store.getBranches().getBranch(this.readRevision);
                if (b == null) {
                    if (this.store.isDisableBranches()) {
                        if (DocumentNodeStoreBranch.getCurrentBranch() != null) {
                            return new DocumentRootBuilder(this, this.store);
                        }
                        return new MemoryNodeBuilder(this);
                    }
                    throw new IllegalStateException("No branch for revision: " + this.readRevision);
                }
                if (b.isHead(this.readRevision.getBranchRevision()) && DocumentNodeStoreBranch.getCurrentBranch() != null) {
                    return new DocumentRootBuilder(this, this.store);
                }
                return new MemoryNodeBuilder(this);
            }
            return new DocumentRootBuilder(this, this.store);
        }
        return new MemoryNodeBuilder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (this == base) {
            return true;
        }
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState(this, diff);
        }
        if (base instanceof DocumentNodeState) {
            DocumentNodeState mBase = (DocumentNodeState)base;
            if (this.store == mBase.store && this.getPath().equals(mBase.getPath())) {
                boolean bl;
                if (this.revisionEquals(mBase)) {
                    return true;
                }
                long start = perfLogger.start();
                try {
                    bl = this.store.compare(this, mBase, diff);
                }
                catch (Throwable throwable) {
                    perfLogger.end(start, 1L, "compareAgainstBaseState, path={}, readRevision={}, lastRevision={}, base.path={}, base.readRevision={}, base.lastRevision={}", this.path, this.readRevision, this.lastRevision, mBase.path, mBase.readRevision, mBase.lastRevision);
                    throw throwable;
                }
                perfLogger.end(start, 1L, "compareAgainstBaseState, path={}, readRevision={}, lastRevision={}, base.path={}, base.readRevision={}, base.lastRevision={}", this.path, this.readRevision, this.lastRevision, mBase.path, mBase.readRevision, mBase.lastRevision);
                return bl;
            }
        }
        return super.compareAgainstBaseState(base, diff);
    }

    void setProperty(String propertyName, String value) {
        if (value == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, new DocumentPropertyState(this.store, propertyName, value));
        }
    }

    void setProperty(PropertyState property) {
        this.properties.put(property.getName(), property);
    }

    String getPropertyAsString(String propertyName) {
        PropertyState prop = this.properties.get(propertyName);
        if (prop == null) {
            return null;
        }
        if (prop instanceof DocumentPropertyState) {
            return ((DocumentPropertyState)prop).getValue();
        }
        JsopBuilder builder = new JsopBuilder();
        new JsonSerializer(builder, this.store.getBlobSerializer()).serialize(prop);
        return builder.toString();
    }

    Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    void copyTo(DocumentNodeState newNode) {
        newNode.properties.putAll(this.properties);
    }

    boolean hasNoChildren() {
        return !this.hasChildren;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("{ path: '").append(this.path).append("', ");
        buff.append("readRevision: '").append(this.readRevision).append("', ");
        buff.append("properties: '").append(this.properties.values()).append("' }");
        return buff.toString();
    }

    UpdateOp asOperation(@Nonnull Revision revision) {
        String id = Utils.getIdFromPath(this.path);
        UpdateOp op = new UpdateOp(id, true);
        op.set("_id", id);
        if (Utils.isLongPath(this.path)) {
            op.set("_path", this.path);
        }
        NodeDocument.setModified(op, revision);
        NodeDocument.setDeleted(op, revision, false);
        for (String p : this.properties.keySet()) {
            String key = Utils.escapePropertyName(p);
            op.setMapEntry(key, revision, this.getPropertyAsString(p));
        }
        return op;
    }

    String getPath() {
        return this.path;
    }

    String getId() {
        return this.path + "@" + this.lastRevision;
    }

    void append(JsopWriter json, boolean includeId) {
        if (includeId) {
            json.key(":id").value(this.getId());
        }
        for (String p : this.properties.keySet()) {
            json.key(p).encodedValue(this.getPropertyAsString(p));
        }
    }

    void setLastRevision(RevisionVector lastRevision) {
        this.lastRevision = lastRevision;
    }

    RevisionVector getLastRevision() {
        return this.lastRevision;
    }

    @Override
    public int getMemory() {
        int size = 40 + this.readRevision.getMemory() + (this.lastRevision != null ? this.lastRevision.getMemory() : 0) + this.rootRevision.getMemory() + StringUtils.estimateMemoryUsage(this.path);
        for (Map.Entry<String, PropertyState> entry : this.properties.entrySet()) {
            size += StringUtils.estimateMemoryUsage(entry.getKey());
            PropertyState propState = entry.getValue();
            if (propState.getType() != Type.BINARY && propState.getType() != Type.BINARIES) {
                for (int i = 0; i < propState.count(); ++i) {
                    size = (int)((long)size + (56L + propState.size(i) * 2L) * 2L);
                }
                continue;
            }
            size += StringUtils.estimateMemoryUsage(this.getPropertyAsString(entry.getKey())) * 2;
        }
        return size;
    }

    private boolean revisionEquals(DocumentNodeState other) {
        return this.readRevision.equals(other.readRevision) || this.lastRevision.equals(other.lastRevision);
    }

    @Nonnull
    private Iterable<ChildNodeEntry> getChildNodeEntries(@Nullable String name, int limit) {
        Iterable<DocumentNodeState> children = this.store.getChildNodes(this, name, limit);
        return Iterables.transform(children, (Function)new Function<DocumentNodeState, ChildNodeEntry>(){

            public ChildNodeEntry apply(final DocumentNodeState input) {
                return new AbstractChildNodeEntry(){

                    @Override
                    @Nonnull
                    public String getName() {
                        return PathUtils.getName(input.getPath());
                    }

                    @Override
                    @Nonnull
                    public NodeState getNodeState() {
                        return input.withRootRevision(DocumentNodeState.this.rootRevision, DocumentNodeState.this.fromExternalChange);
                    }
                };
            }
        });
    }

    public String asString() {
        JsopBuilder json = new JsopBuilder();
        json.key("path").value(this.path);
        json.key("rev").value(this.readRevision.toString());
        if (this.lastRevision != null) {
            json.key("lastRev").value(this.lastRevision.toString());
        }
        if (this.hasChildren) {
            json.key("hasChildren").value(true);
        }
        if (this.properties.size() > 0) {
            json.key("prop").object();
            for (String k : this.properties.keySet()) {
                json.key(k).value(this.getPropertyAsString(k));
            }
            json.endObject();
        }
        return ((Object)json).toString();
    }

    public static DocumentNodeState fromString(DocumentNodeStore store, String s) {
        JsopTokenizer json = new JsopTokenizer(s);
        String path = null;
        RevisionVector rev = null;
        RevisionVector lastRev = null;
        boolean hasChildren = false;
        DocumentNodeState state = null;
        HashMap<String, String> map = new HashMap<String, String>();
        while (true) {
            String k = json.readString();
            json.read(58);
            if ("path".equals(k)) {
                path = json.readString();
            } else if ("rev".equals(k)) {
                rev = RevisionVector.fromString(json.readString());
            } else if ("lastRev".equals(k)) {
                lastRev = RevisionVector.fromString(json.readString());
            } else if ("hasChildren".equals(k)) {
                hasChildren = json.read() == 3;
            } else if ("prop".equals(k)) {
                json.read(123);
                while (!json.matches(125)) {
                    k = json.readString();
                    json.read(58);
                    String v = json.readString();
                    map.put(k, v);
                    json.matches(44);
                }
            }
            if (json.matches(0)) break;
            json.read(44);
        }
        state = new DocumentNodeState(store, path, rev, hasChildren);
        state.setLastRevision(lastRev);
        for (Map.Entry e : map.entrySet()) {
            state.setProperty((String)e.getKey(), (String)e.getValue());
        }
        return state;
    }

    private class ChildNodeEntryIterator
    implements Iterator<ChildNodeEntry> {
        private String previousName;
        private Iterator<ChildNodeEntry> current;
        private int fetchSize;
        private int currentRemaining;

        ChildNodeEntryIterator() {
            this.currentRemaining = this.fetchSize = 100;
            this.fetchMore();
        }

        @Override
        public boolean hasNext() {
            while (this.current != null) {
                if (this.current.hasNext()) {
                    return true;
                }
                if (this.currentRemaining > 0) {
                    return false;
                }
                this.fetchMore();
            }
            return false;
        }

        @Override
        public ChildNodeEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ChildNodeEntry entry = this.current.next();
            this.previousName = entry.getName();
            --this.currentRemaining;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchMore() {
            Iterator entries = DocumentNodeState.this.getChildNodeEntries(this.previousName, this.fetchSize).iterator();
            this.currentRemaining = this.fetchSize;
            this.fetchSize = Math.min(this.fetchSize * 2, 1600);
            this.current = entries.hasNext() ? entries : null;
        }
    }

    public static class Children
    implements CacheValue {
        final ArrayList<String> children = new ArrayList();
        int cachedMemory;
        boolean hasMore;

        @Override
        public int getMemory() {
            if (this.cachedMemory == 0) {
                int size = 48;
                if (!this.children.isEmpty()) {
                    size = 114;
                    for (String c : this.children) {
                        size += StringUtils.estimateMemoryUsage(c) + 8;
                    }
                }
                this.cachedMemory = size;
            }
            return this.cachedMemory;
        }

        public String toString() {
            return this.children.toString();
        }

        public String asString() {
            JsopBuilder json = new JsopBuilder();
            if (this.hasMore) {
                json.key("hasMore").value(true);
            }
            if (this.children.size() > 0) {
                json.key("children").array();
                for (String c : this.children) {
                    json.value(c);
                }
                json.endArray();
            }
            return ((Object)json).toString();
        }

        public static Children fromString(String s) {
            JsopTokenizer json = new JsopTokenizer(s);
            Children children = new Children();
            while (!json.matches(0)) {
                String k = json.readString();
                json.read(58);
                if ("hasMore".equals(k)) {
                    children.hasMore = json.read() == 3;
                } else if ("children".equals(k)) {
                    json.read(91);
                    while (!json.matches(93)) {
                        String value = json.readString();
                        children.children.add(value);
                        json.matches(44);
                    }
                }
                if (json.matches(0)) break;
                json.read(44);
            }
            return children;
        }
    }
}

