/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.RevisionsKey;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiffCache
extends DiffCache {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDiffCache.class);
    private static int MAX_ENTRY_SIZE = 0x1000000;
    private final Cache<RevisionsKey, Diff> diffCache;
    private final CacheStats diffCacheStats;

    LocalDiffCache(DocumentMK.Builder builder) {
        this.diffCache = builder.buildLocalDiffCache();
        this.diffCacheStats = new CacheStats(this.diffCache, "Document-LocalDiff", builder.getWeigher(), builder.getLocalDiffCacheSize());
    }

    @Override
    public String getChanges(@Nonnull RevisionVector from, @Nonnull RevisionVector to, @Nonnull String path, @Nullable DiffCache.Loader loader) {
        RevisionsKey key = new RevisionsKey(from, to);
        Diff diff = (Diff)this.diffCache.getIfPresent((Object)key);
        if (diff != null) {
            String result = diff.get(path);
            return result != null ? result : "";
        }
        if (loader != null) {
            return loader.call();
        }
        return null;
    }

    @Override
    @Nonnull
    public DiffCache.Entry newEntry(final @Nonnull RevisionVector from, final @Nonnull RevisionVector to, boolean local) {
        return new DiffCache.Entry(){
            private final Map<String, String> changesPerPath = Maps.newHashMap();
            private int size;

            @Override
            public void append(@Nonnull String path, @Nonnull String changes) {
                if (this.exceedsSize()) {
                    return;
                }
                this.size += LocalDiffCache.size(path) + LocalDiffCache.size(changes);
                this.changesPerPath.put(path, changes);
            }

            @Override
            public boolean done() {
                if (this.exceedsSize()) {
                    return false;
                }
                LocalDiffCache.this.diffCache.put((Object)new RevisionsKey(from, to), (Object)new Diff(this.changesPerPath, this.size));
                LOG.debug("Adding cache entry from {} to {}", (Object)from, (Object)to);
                return true;
            }

            private boolean exceedsSize() {
                return this.size > MAX_ENTRY_SIZE;
            }
        };
    }

    @Override
    @Nonnull
    public Iterable<CacheStats> getStats() {
        return Collections.singleton(this.diffCacheStats);
    }

    private static int size(String s) {
        return StringValue.getMemory(s);
    }

    public static final class Diff
    implements CacheValue {
        private final Map<String, String> changes;
        private int memory;

        public Diff(Map<String, String> changes, int memory) {
            this.changes = changes;
            this.memory = memory;
        }

        public static Diff fromString(String value) {
            HashMap map = Maps.newHashMap();
            JsopTokenizer reader = new JsopTokenizer(value);
            while (!reader.matches(0)) {
                String k = reader.readString();
                reader.read(58);
                String v = reader.readString();
                map.put(k, v);
                if (reader.matches(0)) break;
                reader.read(44);
            }
            return new Diff(map, 0);
        }

        public String asString() {
            JsopBuilder builder = new JsopBuilder();
            for (Map.Entry<String, String> entry : this.changes.entrySet()) {
                builder.key(entry.getKey());
                builder.value(entry.getValue());
            }
            return builder.toString();
        }

        public Map<String, String> getChanges() {
            return Collections.unmodifiableMap(this.changes);
        }

        @Override
        public int getMemory() {
            if (this.memory == 0) {
                int m = 0;
                for (Map.Entry<String, String> e : this.changes.entrySet()) {
                    m += LocalDiffCache.size(e.getKey()) + LocalDiffCache.size(e.getValue());
                }
                this.memory = m;
            }
            return this.memory;
        }

        String get(String path) {
            return this.changes.get(path);
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Diff) {
                Diff other = (Diff)obj;
                return this.changes.equals(other.changes);
            }
            return false;
        }
    }
}

