/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryDiffCache
extends DiffCache {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryDiffCache.class);
    protected final Cache<PathRev, StringValue> diffCache;
    protected final CacheStats diffCacheStats;

    protected MemoryDiffCache(DocumentMK.Builder builder) {
        this.diffCache = builder.buildMemoryDiffCache();
        this.diffCacheStats = new CacheStats(this.diffCache, "Document-MemoryDiff", builder.getWeigher(), builder.getMemoryDiffCacheSize());
    }

    @Override
    @CheckForNull
    public String getChanges(final @Nonnull RevisionVector from, final @Nonnull RevisionVector to, final @Nonnull String path, final @Nullable DiffCache.Loader loader) {
        StringValue diff;
        PathRev key = MemoryDiffCache.diffCacheKey(path, from, to);
        if (loader == null) {
            diff = (StringValue)this.diffCache.getIfPresent((Object)key);
            if (diff == null && this.isUnchanged(from, to, path)) {
                diff = new StringValue("");
            }
        } else {
            try {
                diff = (StringValue)this.diffCache.get((Object)key, (Callable)new Callable<StringValue>(){

                    @Override
                    public StringValue call() throws Exception {
                        if (MemoryDiffCache.this.isUnchanged(from, to, path)) {
                            return new StringValue("");
                        }
                        return new StringValue(loader.call());
                    }
                });
            }
            catch (ExecutionException e) {
                diff = new StringValue(loader.call());
            }
        }
        return diff != null ? diff.toString() : null;
    }

    @Override
    @Nonnull
    public DiffCache.Entry newEntry(@Nonnull RevisionVector from, @Nonnull RevisionVector to, boolean local) {
        return new MemoryEntry(from, to);
    }

    @Override
    @Nonnull
    public Iterable<CacheStats> getStats() {
        return Collections.singleton(this.diffCacheStats);
    }

    private static PathRev diffCacheKey(@Nonnull String path, @Nonnull RevisionVector from, @Nonnull RevisionVector to) {
        return new PathRev(from + path, to);
    }

    private boolean isUnchanged(@Nonnull RevisionVector from, @Nonnull RevisionVector to, @Nonnull String path) {
        return !PathUtils.denotesRoot(path) && this.isChildUnchanged(from, to, PathUtils.getParentPath(path), PathUtils.getName(path));
    }

    private boolean isChildUnchanged(@Nonnull RevisionVector from, @Nonnull RevisionVector to, @Nonnull String parent, final @Nonnull String name) {
        PathRev parentKey = MemoryDiffCache.diffCacheKey(parent, from, to);
        StringValue parentCachedEntry = (StringValue)this.diffCache.getIfPresent((Object)parentKey);
        boolean unchanged = parentCachedEntry == null ? (PathUtils.denotesRoot(parent) ? false : this.isChildUnchanged(from, to, PathUtils.getParentPath(parent), PathUtils.getName(parent))) : MemoryDiffCache.parseJsopDiff(parentCachedEntry.asString(), new DiffCache.Diff(){

            @Override
            public boolean childNodeAdded(String n) {
                return !name.equals(n);
            }

            @Override
            public boolean childNodeChanged(String n) {
                return !name.equals(n);
            }

            @Override
            public boolean childNodeDeleted(String n) {
                return !name.equals(n);
            }
        });
        return unchanged;
    }

    protected class MemoryEntry
    implements DiffCache.Entry {
        private final RevisionVector from;
        private final RevisionVector to;

        protected MemoryEntry(RevisionVector from, RevisionVector to) {
            this.from = (RevisionVector)Preconditions.checkNotNull((Object)from);
            this.to = (RevisionVector)Preconditions.checkNotNull((Object)to);
        }

        @Override
        public void append(@Nonnull String path, @Nonnull String changes) {
            PathRev key = MemoryDiffCache.diffCacheKey(path, this.from, this.to);
            LOG.debug("Adding cache entry for {} from {} to {}", new Object[]{path, this.from, this.to});
            MemoryDiffCache.this.diffCache.put((Object)key, (Object)new StringValue(changes));
        }

        @Override
        public boolean done() {
            return true;
        }
    }
}

