/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;

public final class PathRev
implements CacheValue {
    private final String path;
    private final RevisionVector revision;

    public PathRev(@Nonnull String path, @Nonnull RevisionVector revision) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.revision = (RevisionVector)Preconditions.checkNotNull((Object)revision);
    }

    @Override
    public int getMemory() {
        return 24 + StringUtils.estimateMemoryUsage(this.path) + this.revision.getMemory();
    }

    public int hashCode() {
        return this.path.hashCode() ^ this.revision.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathRev) {
            PathRev other = (PathRev)obj;
            return this.revision.equals(other.revision) && this.path.equals(other.path);
        }
        return false;
    }

    public String toString() {
        return this.path + "@" + this.revision;
    }

    public String asString() {
        return this.toString();
    }

    public static PathRev fromString(String s) {
        int index = s.lastIndexOf(64);
        return new PathRev(s.substring(0, index), RevisionVector.fromString(s.substring(index + 1)));
    }

    public int compareTo(PathRev b) {
        if (this == b) {
            return 0;
        }
        int compare = this.path.compareTo(b.path);
        if (compare == 0) {
            compare = this.revision.compareTo(b.revision);
        }
        return compare;
    }
}

