/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;

public class UpdateUtils {
    public static void applyChanges(@Nonnull Document doc, @Nonnull UpdateOp update) {
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> e : ((UpdateOp)Preconditions.checkNotNull((Object)update)).getChanges().entrySet()) {
            UpdateOp.Key k = e.getKey();
            UpdateOp.Operation op = e.getValue();
            switch (op.type) {
                case SET: {
                    doc.put(k.toString(), op.value);
                    break;
                }
                case MAX: {
                    Comparable newValue = (Comparable)op.value;
                    Object old = doc.get(k.toString());
                    if (old != null && newValue.compareTo(old) <= 0) break;
                    doc.put(k.toString(), op.value);
                    break;
                }
                case INCREMENT: {
                    Object old = doc.get(k.toString());
                    Long x = (Long)op.value;
                    if (old == null) {
                        old = 0L;
                    }
                    doc.put(k.toString(), (Long)old + x);
                    break;
                }
                case SET_MAP_ENTRY: {
                    Object old = doc.get(k.getName());
                    TreeMap<Revision, Object> m = (TreeMap<Revision, Object>)old;
                    if (m == null) {
                        m = new TreeMap<Revision, Object>(StableRevisionComparator.REVERSE);
                        doc.put(k.getName(), m);
                    }
                    if (k.getRevision() == null) {
                        throw new IllegalArgumentException("Cannot set map entry " + k.getName() + " with null revision");
                    }
                    m.put(k.getRevision(), op.value);
                    break;
                }
                case REMOVE_MAP_ENTRY: {
                    Object old = doc.get(k.getName());
                    TreeMap<Revision, Object> m = (Map)old;
                    if (m == null) break;
                    m.remove(k.getRevision());
                    break;
                }
            }
        }
    }

    public static boolean checkConditions(@Nonnull Document doc, @Nonnull Map<UpdateOp.Key, UpdateOp.Condition> conditions) {
        for (Map.Entry<UpdateOp.Key, UpdateOp.Condition> entry : conditions.entrySet()) {
            UpdateOp.Condition c = entry.getValue();
            UpdateOp.Key k = entry.getKey();
            Object value = doc.get(k.getName());
            Revision r = k.getRevision();
            if (c.type == UpdateOp.Condition.Type.EXISTS) {
                if (r == null) {
                    throw new IllegalStateException("EXISTS must not contain null revision");
                }
                if (value == null) {
                    if (!Boolean.TRUE.equals(c.value)) continue;
                    return false;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    if (!(Boolean.TRUE.equals(c.value) ? !map.containsKey(r) : map.containsKey(r))) continue;
                    return false;
                }
                return false;
            }
            if (c.type == UpdateOp.Condition.Type.EQUALS || c.type == UpdateOp.Condition.Type.NOTEQUALS) {
                if (r != null) {
                    value = value instanceof Map ? ((Map)value).get(r) : null;
                }
                boolean equal = Objects.equal((Object)value, (Object)c.value);
                if (c.type == UpdateOp.Condition.Type.EQUALS && !equal) {
                    return false;
                }
                if (c.type != UpdateOp.Condition.Type.NOTEQUALS || !equal) continue;
                return false;
            }
            throw new IllegalArgumentException("Unknown condition: " + (Object)((Object)c.type));
        }
        return true;
    }

    public static void assertUnconditional(@Nonnull UpdateOp up) {
        Map<UpdateOp.Key, UpdateOp.Condition> conditions = up.getConditions();
        if (!conditions.isEmpty()) {
            throw new IllegalArgumentException("This DocumentStore method does not support conditional updates, but the UpdateOp contained: " + conditions);
        }
    }
}

