/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.cache;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class NodeDocumentCache
implements Closeable {
    private final Cache<CacheValue, NodeDocument> nodeDocumentsCache;
    private final CacheStats nodeDocumentsCacheStats;
    private final Cache<StringValue, NodeDocument> prevDocumentsCache;
    private final CacheStats prevDocumentsCacheStats;
    private final NodeDocumentLocks locks;

    public NodeDocumentCache(@Nonnull Cache<CacheValue, NodeDocument> nodeDocumentsCache, @Nonnull CacheStats nodeDocumentsCacheStats, @Nonnull Cache<StringValue, NodeDocument> prevDocumentsCache, @Nonnull CacheStats prevDocumentsCacheStats, @Nonnull NodeDocumentLocks locks) {
        this.nodeDocumentsCache = nodeDocumentsCache;
        this.nodeDocumentsCacheStats = nodeDocumentsCacheStats;
        this.prevDocumentsCache = prevDocumentsCache;
        this.prevDocumentsCacheStats = prevDocumentsCacheStats;
        this.locks = locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(@Nonnull String key) {
        Lock lock = this.locks.acquire(key);
        try {
            if (Utils.isLeafPreviousDocId(key)) {
                this.prevDocumentsCache.invalidate((Object)new StringValue(key));
            } else {
                this.nodeDocumentsCache.invalidate((Object)new StringValue(key));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Nonnegative
    public int invalidateOutdated(@Nonnull Map<String, Long> modCounts) {
        int invalidatedCount = 0;
        for (Map.Entry<String, Long> e : modCounts.entrySet()) {
            String id = e.getKey();
            Long modCount = e.getValue();
            NodeDocument doc = this.getIfPresent(id);
            if (doc == null || Objects.equal((Object)modCount, (Object)doc.getModCount())) continue;
            this.invalidate(id);
            ++invalidatedCount;
        }
        return invalidatedCount;
    }

    @CheckForNull
    public NodeDocument getIfPresent(@Nonnull String key) {
        if (Utils.isLeafPreviousDocId(key)) {
            return (NodeDocument)this.prevDocumentsCache.getIfPresent((Object)new StringValue(key));
        }
        return (NodeDocument)this.nodeDocumentsCache.getIfPresent((Object)new StringValue(key));
    }

    @Nonnull
    public NodeDocument get(@Nonnull String key, @Nonnull Callable<NodeDocument> valueLoader) throws ExecutionException {
        if (Utils.isLeafPreviousDocId(key)) {
            return (NodeDocument)this.prevDocumentsCache.get((Object)new StringValue(key), valueLoader);
        }
        return (NodeDocument)this.nodeDocumentsCache.get((Object)new StringValue(key), valueLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@Nonnull NodeDocument doc) {
        if (doc != NodeDocument.NULL) {
            Lock lock = this.locks.acquire(doc.getId());
            try {
                this.putInternal(doc);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public NodeDocument putIfNewer(@Nonnull NodeDocument doc) {
        NodeDocument newerDoc;
        if (doc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        doc.seal();
        String id = doc.getId();
        Lock lock = this.locks.acquire(id);
        try {
            NodeDocument cachedDoc = this.getIfPresent(id);
            if (cachedDoc == null || cachedDoc == NodeDocument.NULL) {
                newerDoc = doc;
                this.putInternal(doc);
            } else {
                Long cachedModCount = cachedDoc.getModCount();
                Long modCount = doc.getModCount();
                if (cachedModCount == null || modCount == null) {
                    throw new IllegalStateException("Missing _modCount");
                }
                if (modCount > cachedModCount) {
                    newerDoc = doc;
                    this.putInternal(doc);
                } else {
                    newerDoc = cachedDoc;
                }
            }
        }
        finally {
            lock.unlock();
        }
        return newerDoc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public NodeDocument putIfAbsent(final @Nonnull NodeDocument doc) {
        if (doc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        doc.seal();
        String id = doc.getId();
        Lock lock = this.locks.acquire(id);
        try {
            while (true) {
                NodeDocument cached;
                if ((cached = this.get(id, new Callable<NodeDocument>(){

                    @Override
                    public NodeDocument call() {
                        return doc;
                    }
                })) != NodeDocument.NULL) {
                    NodeDocument nodeDocument = cached;
                    return nodeDocument;
                }
                this.invalidate(id);
                continue;
                break;
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceCachedDocument(@Nonnull NodeDocument oldDoc, @Nonnull NodeDocument newDoc) {
        if (newDoc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        String key = oldDoc.getId();
        Lock lock = this.locks.acquire(key);
        try {
            NodeDocument cached = this.getIfPresent(key);
            if (cached != null) {
                if (Objects.equal((Object)cached.getModCount(), (Object)oldDoc.getModCount())) {
                    this.putInternal(newDoc);
                } else {
                    this.invalidate(key);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Iterable<CacheValue> keys() {
        return Iterables.concat(this.nodeDocumentsCache.asMap().keySet(), this.prevDocumentsCache.asMap().keySet());
    }

    public Iterable<NodeDocument> values() {
        return Iterables.concat(this.nodeDocumentsCache.asMap().values(), this.prevDocumentsCache.asMap().values());
    }

    public Iterable<CacheStats> getCacheStats() {
        return Lists.newArrayList((Object[])new CacheStats[]{this.nodeDocumentsCacheStats, this.prevDocumentsCacheStats});
    }

    @Override
    public void close() throws IOException {
        if (this.prevDocumentsCache instanceof Closeable) {
            ((Closeable)this.prevDocumentsCache).close();
        }
        if (this.nodeDocumentsCache instanceof Closeable) {
            ((Closeable)this.nodeDocumentsCache).close();
        }
    }

    protected final void putInternal(@Nonnull NodeDocument doc) {
        if (Utils.isLeafPreviousDocId(doc.getId())) {
            this.prevDocumentsCache.put((Object)new StringValue(doc.getId()), (Object)doc);
        } else {
            this.nodeDocumentsCache.put((Object)new StringValue(doc.getId()), (Object)doc);
        }
    }
}

