/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.locks;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import org.apache.jackrabbit.oak.plugins.document.locks.BulkLock;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class StripedNodeDocumentLocks
implements NodeDocumentLocks {
    private static final String ROOT = Utils.getIdFromPath("/");
    private final Striped<Lock> locks = Striped.lock((int)4096);
    private final Lock rootLock = (Lock)Striped.lock((int)1).get((Object)ROOT);

    @Override
    public Lock acquire(String key) {
        Lock lock = ROOT.equals(key) ? this.rootLock : (Lock)this.locks.get((Object)key);
        lock.lock();
        return lock;
    }

    @Override
    public Lock acquire(Collection<String> keys) {
        ArrayList<Lock> lockList = new ArrayList<Lock>();
        if (keys.contains(ROOT)) {
            lockList.add(this.rootLock);
        }
        for (Lock l : this.locks.bulkGet(Iterables.filter(keys, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)ROOT))))) {
            lockList.add(l);
        }
        BulkLock lock = new BulkLock(lockList);
        lock.lock();
        return lock;
    }
}

