/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.HashSet;

class MongoUtils {
    MongoUtils() {
    }

    static void createIndex(DBCollection collection, String field, boolean ascending, boolean unique, boolean sparse) throws MongoException {
        MongoUtils.createIndex(collection, new String[]{field}, new boolean[]{ascending}, unique, sparse);
    }

    static void createIndex(DBCollection collection, String[] fields, boolean[] ascending, boolean unique, boolean sparse) throws MongoException {
        Preconditions.checkArgument((fields.length == ascending.length ? 1 : 0) != 0);
        BasicDBObject index = new BasicDBObject();
        for (int i = 0; i < fields.length; ++i) {
            index.put(fields[i], (Object)(ascending[i] ? 1 : -1));
        }
        BasicDBObject options = new BasicDBObject();
        options.put("unique", (Object)unique);
        options.put("sparse", (Object)sparse);
        collection.createIndex((DBObject)index, (DBObject)options);
    }

    static boolean hasIndex(DBCollection collection, String ... fields) throws MongoException {
        HashSet uniqueFields = Sets.newHashSet((Object[])fields);
        for (DBObject info : collection.getIndexInfo()) {
            DBObject key = (DBObject)info.get("key");
            HashSet indexFields = Sets.newHashSet((Iterable)key.keySet());
            if (!uniqueFields.equals(indexFields)) continue;
            return true;
        }
        return false;
    }
}

