/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.api.jmx.PersistentCacheStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

public class PersistentCacheStats
extends AnnotatedStandardMBean
implements PersistentCacheStatsMBean {
    private static final Boolean ENABLE_READ_TIMER;
    private static final Boolean ENABLE_LOAD_TIMER;
    private static final String HITS = "HITS";
    private static final String REQUESTS = "REQUESTS";
    private static final String LOAD_TIMER = "LOAD_TIMER";
    private static final String LOAD_EXCEPTIONS = "LOAD_EXCEPTIONS";
    private static final String PUT_ONE = "CACHE_PUT";
    private static final String BROADCAST_RECV = "BROADCAST_RECV";
    private static final String INVALIDATE_ONE = "INVALIDATE_ONE";
    private static final String INVALIDATE_ALL = "INVALIDATE_ALL";
    private static final String READ_TIMER = "READ_TIMER";
    private static final String USED_DISK_SPACE = "USED_SPACE_BYTES";
    private final StatisticsProvider statisticsProvider;
    private final String cacheName;
    private final MeterStats hitMeter;
    private final TimeSeries hitRateHistory;
    private final MeterStats requestMeter;
    private final TimeSeries requestRateHistory;
    private final MeterStats loadExceptionMeter;
    private final TimeSeries loadExceptionRateHistory;
    private final TimerStats loadTimer;
    private final TimeSeries loadRateHistory;
    private final MeterStats putMeter;
    private final TimeSeries putRateHistory;
    private final MeterStats broadcastRecvMeter;
    private final TimeSeries broadcastRecvRateHistory;
    private final MeterStats invalidateOneMeter;
    private final TimeSeries invalidateOneRateHistory;
    private final MeterStats invalidateAllMeter;
    private final TimeSeries invalidateAllRateHistory;
    private final TimerStats readTimer;
    private final CounterStats usedSpaceByteCounter;
    private final TimeSeries usedSpaceByteCounterHistory;
    private final UsedSpaceTracker diskStats;
    private final TimeSeries hitPercentageHistory;

    public PersistentCacheStats(CacheType cacheType, StatisticsProvider provider) {
        super(PersistentCacheStatsMBean.class);
        this.statisticsProvider = provider == null ? StatisticsProvider.NOOP : provider;
        this.cacheName = "PersistentCache.NodeCache." + cacheType.name().toLowerCase();
        String statName = PersistentCacheStats.getStatName(HITS, this.cacheName);
        this.hitMeter = this.statisticsProvider.getMeter(statName, StatsOptions.DEFAULT);
        this.hitRateHistory = this.getTimeSeries(statName);
        statName = PersistentCacheStats.getStatName(REQUESTS, this.cacheName);
        this.requestMeter = this.statisticsProvider.getMeter(statName, StatsOptions.DEFAULT);
        this.requestRateHistory = this.getTimeSeries(statName);
        this.hitPercentageHistory = new PercentageTimeSeries(this.hitRateHistory, this.requestRateHistory);
        statName = PersistentCacheStats.getStatName(LOAD_TIMER, this.cacheName);
        this.loadRateHistory = new DifferenceTimeSeries(this.requestRateHistory, this.hitRateHistory);
        this.loadTimer = ENABLE_LOAD_TIMER != false ? this.statisticsProvider.getTimer(statName, StatsOptions.METRICS_ONLY) : StatisticsProvider.NOOP.getTimer(statName, StatsOptions.METRICS_ONLY);
        statName = PersistentCacheStats.getStatName(LOAD_EXCEPTIONS, this.cacheName);
        this.loadExceptionMeter = this.statisticsProvider.getMeter(statName, StatsOptions.DEFAULT);
        this.loadExceptionRateHistory = this.getTimeSeries(statName);
        statName = PersistentCacheStats.getStatName(PUT_ONE, this.cacheName);
        this.putMeter = this.statisticsProvider.getMeter(statName, StatsOptions.DEFAULT);
        this.putRateHistory = this.getTimeSeries(statName);
        statName = PersistentCacheStats.getStatName(BROADCAST_RECV, this.cacheName);
        this.broadcastRecvMeter = this.statisticsProvider.getMeter(statName, StatsOptions.DEFAULT);
        this.broadcastRecvRateHistory = this.getTimeSeries(statName);
        statName = PersistentCacheStats.getStatName(INVALIDATE_ONE, this.cacheName);
        this.invalidateOneMeter = this.statisticsProvider.getMeter(statName, StatsOptions.DEFAULT);
        this.invalidateOneRateHistory = this.getTimeSeries(statName);
        statName = PersistentCacheStats.getStatName(INVALIDATE_ALL, this.cacheName);
        this.invalidateAllMeter = this.statisticsProvider.getMeter(statName, StatsOptions.DEFAULT);
        this.invalidateAllRateHistory = this.getTimeSeries(statName);
        statName = PersistentCacheStats.getStatName(USED_DISK_SPACE, this.cacheName);
        this.usedSpaceByteCounter = this.statisticsProvider.getCounterStats(statName, StatsOptions.DEFAULT);
        this.usedSpaceByteCounterHistory = this.getTimeSeries(statName, false);
        statName = PersistentCacheStats.getStatName(READ_TIMER, this.cacheName);
        this.readTimer = ENABLE_READ_TIMER != false ? this.statisticsProvider.getTimer(statName, StatsOptions.METRICS_ONLY) : StatisticsProvider.NOOP.getTimer(statName, StatsOptions.METRICS_ONLY);
        this.diskStats = new UsedSpaceTracker(this.usedSpaceByteCounter);
    }

    public void markHit() {
        this.hitMeter.mark();
    }

    public void markRequest() {
        this.requestMeter.mark();
    }

    public void markException() {
        this.loadExceptionMeter.mark();
    }

    public void markPut() {
        this.putMeter.mark();
    }

    public void markRecvBroadcast() {
        this.broadcastRecvMeter.mark();
    }

    public void markInvalidateOne() {
        this.invalidateOneMeter.mark();
    }

    public void markInvalidateAll() {
        this.invalidateAllMeter.mark();
    }

    public TimerStats.Context startReadTimer() {
        return this.readTimer.time();
    }

    public TimerStats.Context startLoaderTimer() {
        return this.loadTimer.time();
    }

    public void addWriteGeneration(int generation) {
        this.diskStats.addWriteGeneration(generation);
    }

    public void removeReadGeneration(int generation) {
        this.diskStats.removeReadGeneration(generation);
    }

    public void markBytesWritten(long numBytes) {
        this.diskStats.markBytesWritten(numBytes);
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public long getRequestCount() {
        return this.requestMeter.getCount();
    }

    @Override
    public long getHitCount() {
        return this.hitMeter.getCount();
    }

    @Override
    public double getHitRate() {
        long hitCount = this.hitMeter.getCount();
        long requestCount = this.requestMeter.getCount();
        return requestCount == 0L ? 0.0 : (double)hitCount / (double)requestCount;
    }

    @Override
    public long getMissCount() {
        return this.requestMeter.getCount() - this.hitMeter.getCount();
    }

    @Override
    public double getMissRate() {
        long missCount = this.getMissCount();
        long requestCount = this.requestMeter.getCount();
        return requestCount == 0L ? 0.0 : (double)missCount / (double)requestCount;
    }

    @Override
    public long getLoadCount() {
        return this.getMissCount();
    }

    @Override
    public long getLoadSuccessCount() {
        return this.getLoadCount() - this.getLoadExceptionCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.loadExceptionMeter.getCount();
    }

    @Override
    public double getLoadExceptionRate() {
        long exceptionCount = this.loadExceptionMeter.getCount();
        long loadCount = this.loadTimer.getCount();
        return loadCount == 0L ? 0.0 : (double)exceptionCount / (double)loadCount;
    }

    @Override
    public long estimateCurrentWeight() {
        return this.usedSpaceByteCounter.getCount();
    }

    @Override
    public CompositeData getRequestRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.requestRateHistory, "Persistent cache requests");
    }

    @Override
    public CompositeData getHitRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.hitRateHistory, "Persistent cache hits");
    }

    @Override
    public CompositeData getLoadRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.loadRateHistory, "Persistent cache loads/misses");
    }

    @Override
    public CompositeData getLoadExceptionRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.loadExceptionRateHistory, "Persistent cache load exceptions");
    }

    @Override
    public CompositeData getHitPercentageHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.hitPercentageHistory, "Persistent cache hit percentage");
    }

    @Override
    public CompositeData getPutRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.putRateHistory, "Persistent cache manual put entry");
    }

    @Override
    public CompositeData getInvalidateOneRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.invalidateOneRateHistory, "Persistent cache invalidate one entry");
    }

    @Override
    public CompositeData getInvalidateAllRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.invalidateAllRateHistory, "Persistent cache invalidate all entries");
    }

    @Override
    public CompositeData getBroadcastRecvRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.broadcastRecvRateHistory, "Persistent cache entries received from broadcast");
    }

    @Override
    public CompositeData getUsedSpaceHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.usedSpaceByteCounterHistory, "Persistent cache estimated size (bytes)");
    }

    @Override
    public String cacheInfoAsString() {
        return Objects.toStringHelper((String)"PersistentCacheStats").add("requestCount", this.getRequestCount()).add("hitCount", this.getHitCount()).add("hitRate", (Object)String.format("%1.2f", this.getHitRate())).add("missCount", this.getMissCount()).add("missRate", (Object)String.format("%1.2f", this.getMissRate())).add("loadCount", this.getLoadCount()).add("loadSuccessCount", this.getLoadSuccessCount()).add("loadExceptionCount", this.getLoadExceptionCount()).add("totalWeight", (Object)IOUtils.humanReadableByteCount(this.estimateCurrentWeight())).toString();
    }

    @Override
    public long getTotalLoadTime() {
        return 0L;
    }

    @Override
    public double getAverageLoadPenalty() {
        return 0.0;
    }

    @Override
    public long getEvictionCount() {
        return 0L;
    }

    @Override
    public long getElementCount() {
        return 0L;
    }

    @Override
    public long getMaxTotalWeight() {
        return Long.MAX_VALUE;
    }

    @Override
    public void resetStats() {
    }

    private static String getStatName(String meter, String cacheName) {
        return cacheName + "." + meter;
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }

    private TimeSeries getTimeSeries(String name, boolean resetValues) {
        return this.statisticsProvider.getStats().getTimeSeries(name, resetValues);
    }

    static {
        String enableReadTimer = System.getProperty("PersistentCacheStats.readTimer", "false");
        String enableLoadTimer = System.getProperty("PersistentCacheStats.loadTimer", "false");
        ENABLE_READ_TIMER = Boolean.parseBoolean(enableReadTimer);
        ENABLE_LOAD_TIMER = Boolean.parseBoolean(enableLoadTimer);
    }

    private static class DifferenceTimeSeries
    implements TimeSeries {
        private TimeSeries tsA;
        private TimeSeries tsB;

        DifferenceTimeSeries(TimeSeries tsA, TimeSeries tsB) {
            this.tsA = tsA;
            this.tsB = tsB;
        }

        @Override
        public long[] getValuePerSecond() {
            return DifferenceTimeSeries.difference(this.tsA.getValuePerSecond(), this.tsB.getValuePerSecond());
        }

        @Override
        public long[] getValuePerMinute() {
            return DifferenceTimeSeries.difference(this.tsA.getValuePerMinute(), this.tsB.getValuePerMinute());
        }

        @Override
        public long[] getValuePerHour() {
            return DifferenceTimeSeries.difference(this.tsA.getValuePerHour(), this.tsB.getValuePerHour());
        }

        @Override
        public long[] getValuePerWeek() {
            return DifferenceTimeSeries.difference(this.tsA.getValuePerWeek(), this.tsB.getValuePerWeek());
        }

        @Override
        public long getMissingValue() {
            return 0L;
        }

        private static long[] difference(long[] a, long[] b) {
            long[] result = new long[a.length];
            for (int i = 0; i < a.length; ++i) {
                result[i] = a[i] - b[i];
            }
            return result;
        }
    }

    private static class PercentageTimeSeries
    implements TimeSeries {
        private TimeSeries hit;
        private TimeSeries total;

        PercentageTimeSeries(TimeSeries hit, TimeSeries total) {
            this.hit = hit;
            this.total = total;
        }

        @Override
        public long[] getValuePerSecond() {
            return PercentageTimeSeries.percentage(this.hit.getValuePerSecond(), this.total.getValuePerSecond());
        }

        @Override
        public long[] getValuePerMinute() {
            return PercentageTimeSeries.percentage(this.hit.getValuePerMinute(), this.total.getValuePerMinute());
        }

        @Override
        public long[] getValuePerHour() {
            return PercentageTimeSeries.percentage(this.hit.getValuePerHour(), this.total.getValuePerHour());
        }

        @Override
        public long[] getValuePerWeek() {
            return PercentageTimeSeries.percentage(this.hit.getValuePerWeek(), this.total.getValuePerWeek());
        }

        @Override
        public long getMissingValue() {
            return 0L;
        }

        private static long[] percentage(long[] a, long[] b) {
            long[] result = new long[a.length];
            for (int i = 0; i < a.length; ++i) {
                result[i] = b[i] == 0L ? 0L : a[i] * 100L / b[i];
            }
            return result;
        }
    }

    static class UsedSpaceTracker {
        private final CounterStats byteCounter;
        private final Map<Integer, AtomicLong> generationByteCounters;
        private AtomicLong currentGenCounter;

        UsedSpaceTracker(CounterStats usageCounter) {
            this.byteCounter = usageCounter;
            this.generationByteCounters = new ConcurrentHashMap<Integer, AtomicLong>();
            this.currentGenCounter = new AtomicLong();
        }

        void addWriteGeneration(int generation) {
            this.currentGenCounter = new AtomicLong(0L);
            this.generationByteCounters.put(generation, this.currentGenCounter);
        }

        void removeReadGeneration(int generation) {
            AtomicLong genCounter = this.generationByteCounters.remove(generation);
            this.byteCounter.dec(genCounter == null ? 0L : genCounter.get());
        }

        void markBytesWritten(long bytes) {
            this.currentGenCounter.addAndGet(bytes);
            this.byteCounter.inc(bytes);
        }
    }
}

