/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheAction;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheWriteQueue;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.InvalidateCacheAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheActionDispatcher
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CacheActionDispatcher.class);
    static final int MAX_SIZE = 1024;
    static final int ACTIONS_TO_REMOVE = 256;
    final BlockingQueue<CacheAction<?, ?>> queue = new ArrayBlockingQueue(2048);
    private volatile boolean isRunning = true;

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                CacheAction<?, ?> action = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                if (action == null || !this.isRunning) continue;
                action.execute();
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted the queue.poll()", (Throwable)e);
            }
        }
        this.applyInvalidateActions();
    }

    public void stop() {
        this.isRunning = false;
    }

    synchronized void add(CacheAction<?, ?> action) {
        if (this.queue.size() >= 1024) {
            this.cleanTheQueue();
        }
        this.queue.offer(action);
    }

    private void cleanTheQueue() {
        List<CacheAction> removed = this.removeOldest();
        for (Map.Entry<CacheWriteQueue, Collection<CacheAction>> e : CacheActionDispatcher.groupByOwner(removed).entrySet()) {
            CacheWriteQueue owner = e.getKey();
            Collection<CacheAction> actions = e.getValue();
            List<Object> affectedKeys = CacheActionDispatcher.cancelAll(actions);
            owner.addInvalidate(affectedKeys);
        }
    }

    private List<CacheAction> removeOldest() {
        CacheAction toBeCanceled;
        ArrayList<CacheAction> removed = new ArrayList<CacheAction>();
        while (this.queue.size() > 768 && (toBeCanceled = (CacheAction)this.queue.poll()) != null) {
            removed.add(toBeCanceled);
        }
        return removed;
    }

    private static Map<CacheWriteQueue, Collection<CacheAction>> groupByOwner(List<CacheAction> actions) {
        return Multimaps.index(actions, (Function)new Function<CacheAction, CacheWriteQueue>(){

            public CacheWriteQueue apply(CacheAction input) {
                return input.getOwner();
            }
        }).asMap();
    }

    private static List<Object> cancelAll(Collection<CacheAction> actions) {
        ArrayList<Object> cancelledKeys = new ArrayList<Object>();
        for (CacheAction action : actions) {
            action.cancel();
            Iterables.addAll(cancelledKeys, action.getAffectedKeys());
        }
        return cancelledKeys;
    }

    private void applyInvalidateActions() {
        CacheAction action;
        do {
            if (!((action = (CacheAction)this.queue.poll()) instanceof InvalidateCacheAction)) continue;
            action.execute();
        } while (action != null);
    }
}

